/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.core.internal.jobs.Deadlock;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

class DeadlockDetector {
    private static int NO_STATE = 0;
    private static int WAITING_FOR_LOCK = -1;
    private static final int[][] EMPTY_MATRIX = new int[0][0];
    private int[][] graph = EMPTY_MATRIX;
    private final ArrayList<ISchedulingRule> locks = new ArrayList();
    private final ArrayList<Thread> lockThreads = new ArrayList();
    private boolean resize = false;

    DeadlockDetector() {
    }

    private boolean addCycleThreads(ArrayList<Thread> deadlockedThreads, Thread next) {
        Thread[] blocking = this.blockingThreads(next);
        if (blocking.length == 0) {
            return false;
        }
        boolean inCycle = false;
        Thread[] threadArray = blocking;
        int n = blocking.length;
        int n2 = 0;
        while (n2 < n) {
            Thread element = threadArray[n2];
            if (deadlockedThreads.contains(element)) {
                inCycle = true;
            } else {
                deadlockedThreads.add(element);
                if (this.addCycleThreads(deadlockedThreads, element)) {
                    inCycle = true;
                } else {
                    deadlockedThreads.remove(element);
                }
            }
            ++n2;
        }
        return inCycle;
    }

    private Thread[] blockingThreads(Thread current) {
        ISchedulingRule lock = (ISchedulingRule)this.getWaitingLock(current);
        return this.getThreadsOwningLock(lock);
    }

    private boolean checkWaitCycles(int[] waitingThreads, int lockIndex) {
        int i = 0;
        while (i < this.graph.length) {
            if (this.graph[i][lockIndex] > NO_STATE) {
                if (waitingThreads[i] > NO_STATE) {
                    return true;
                }
                int n = i;
                waitingThreads[n] = waitingThreads[n] + 1;
                int j = 0;
                while (j < this.graph[i].length) {
                    if (this.graph[i][j] == WAITING_FOR_LOCK && this.checkWaitCycles(waitingThreads, j)) {
                        return true;
                    }
                    ++j;
                }
                int n2 = i;
                waitingThreads[n2] = waitingThreads[n2] - 1;
            }
            ++i;
        }
        return false;
    }

    boolean contains(Thread t) {
        return this.lockThreads.contains(t);
    }

    private void fillPresentEntries(ISchedulingRule newLock, int lockIndex) {
        int i;
        int j = 0;
        while (j < this.locks.size()) {
            if (j != lockIndex && newLock.isConflicting(this.locks.get(j))) {
                i = 0;
                while (i < this.graph.length) {
                    if (this.graph[i][j] > NO_STATE && this.graph[i][lockIndex] == NO_STATE) {
                        this.graph[i][lockIndex] = this.graph[i][j];
                    }
                    ++i;
                }
            }
            ++j;
        }
        j = 0;
        while (j < this.locks.size()) {
            if (j != lockIndex && newLock.isConflicting(this.locks.get(j))) {
                i = 0;
                while (i < this.graph.length) {
                    if (this.graph[i][lockIndex] > NO_STATE && this.graph[i][j] == NO_STATE) {
                        this.graph[i][j] = this.graph[i][lockIndex];
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    private Object[] getOwnedLocks(Thread current) {
        ArrayList<ISchedulingRule> ownedLocks = new ArrayList<ISchedulingRule>(1);
        int index = this.indexOf(current, false);
        int j = 0;
        while (j < this.graph[index].length) {
            if (this.graph[index][j] > NO_STATE) {
                ownedLocks.add(this.locks.get(j));
            }
            ++j;
        }
        if (ownedLocks.size() == 0) {
            Assert.isLegal(false, "A thread with no locks is part of a deadlock.");
        }
        return ownedLocks.toArray();
    }

    private Thread[] getThreadsInDeadlock(Thread cause) {
        ArrayList<Thread> deadlockedThreads = new ArrayList<Thread>(2);
        if (this.ownsLocks(cause)) {
            deadlockedThreads.add(cause);
        }
        this.addCycleThreads(deadlockedThreads, cause);
        return deadlockedThreads.toArray(new Thread[deadlockedThreads.size()]);
    }

    private Thread[] getThreadsOwningLock(ISchedulingRule rule) {
        if (rule == null) {
            return new Thread[0];
        }
        int lockIndex = this.indexOf(rule, false);
        ArrayList<Thread> blocking = new ArrayList<Thread>(1);
        int i = 0;
        while (i < this.graph.length) {
            if (this.graph[i][lockIndex] > NO_STATE) {
                blocking.add(this.lockThreads.get(i));
            }
            ++i;
        }
        if (blocking.size() == 0 && JobManager.DEBUG_LOCKS) {
            System.out.println("Lock " + rule + " is involved in deadlock but is not owned by any thread.");
        }
        if (blocking.size() > 1 && rule instanceof ILock && JobManager.DEBUG_LOCKS) {
            System.out.println("Lock " + rule + " is owned by more than 1 thread, but it is not a rule.");
        }
        return blocking.toArray(new Thread[blocking.size()]);
    }

    private Object getWaitingLock(Thread current) {
        int index = this.indexOf(current, false);
        int j = 0;
        while (j < this.graph[index].length) {
            if (this.graph[index][j] == WAITING_FOR_LOCK) {
                return this.locks.get(j);
            }
            ++j;
        }
        return null;
    }

    private int indexOf(ISchedulingRule lock, boolean add) {
        int index = this.locks.indexOf(lock);
        if (index < 0 && add) {
            this.locks.add(lock);
            this.resize = true;
            index = this.locks.size() - 1;
        }
        return index;
    }

    private int indexOf(Thread owner, boolean add) {
        int index = this.lockThreads.indexOf(owner);
        if (index < 0 && add) {
            this.lockThreads.add(owner);
            this.resize = true;
            index = this.lockThreads.size() - 1;
        }
        return index;
    }

    boolean isEmpty() {
        return this.locks.size() == 0 && this.lockThreads.size() == 0 && this.graph.length == 0;
    }

    void lockAcquired(Thread owner, ISchedulingRule lock) {
        int lockIndex = this.indexOf(lock, true);
        int threadIndex = this.indexOf(owner, true);
        if (this.resize) {
            this.resizeGraph();
        }
        if (this.graph[threadIndex][lockIndex] == WAITING_FOR_LOCK) {
            this.graph[threadIndex][lockIndex] = NO_STATE;
        }
        ArrayList<ISchedulingRule> conflicting = new ArrayList<ISchedulingRule>(1);
        int NUM_PASSES = 2;
        conflicting.add(lock);
        int[] nArray = this.graph[threadIndex];
        int n = lockIndex;
        nArray[n] = nArray[n] + 1;
        int i = 0;
        while (i < NUM_PASSES) {
            int k = 0;
            while (k < conflicting.size()) {
                ISchedulingRule current = (ISchedulingRule)conflicting.get(k);
                int j = 0;
                while (j < this.locks.size()) {
                    ISchedulingRule possible = this.locks.get(j);
                    if (current.isConflicting(possible) && !conflicting.contains(possible)) {
                        conflicting.add(possible);
                        int[] nArray2 = this.graph[threadIndex];
                        int n2 = j;
                        nArray2[n2] = nArray2[n2] + 1;
                    }
                    ++j;
                }
                ++k;
            }
            ++i;
        }
    }

    void lockReleased(Thread owner, ISchedulingRule lock) {
        int lockIndex = this.indexOf(lock, false);
        int threadIndex = this.indexOf(owner, false);
        if (threadIndex < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("[lockReleased] Lock " + lock + " was already released by thread " + owner.getName());
            }
            return;
        }
        if (lockIndex < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("[lockReleased] Thread " + owner.getName() + " already released lock " + lock);
            }
            return;
        }
        if (lock instanceof ILock && this.graph[threadIndex][lockIndex] == WAITING_FOR_LOCK) {
            this.graph[threadIndex][lockIndex] = NO_STATE;
            return;
        }
        int j = 0;
        while (j < this.graph[threadIndex].length) {
            if (lock.isConflicting(this.locks.get(j)) || !(lock instanceof ILock) && !(this.locks.get(j) instanceof ILock) && this.graph[threadIndex][j] > NO_STATE) {
                if (this.graph[threadIndex][j] == NO_STATE) {
                    if (JobManager.DEBUG_LOCKS) {
                        System.out.println("[lockReleased] More releases than acquires for thread " + owner.getName() + " and lock " + lock);
                    }
                } else {
                    int[] nArray = this.graph[threadIndex];
                    int n = j;
                    nArray[n] = nArray[n] - 1;
                }
            }
            ++j;
        }
        if (this.graph[threadIndex][lockIndex] == NO_STATE) {
            this.reduceGraph(threadIndex, lock);
        }
    }

    void lockReleasedCompletely(Thread owner, ISchedulingRule rule) {
        int ruleIndex = this.indexOf(rule, false);
        int threadIndex = this.indexOf(owner, false);
        if (threadIndex < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("[lockReleasedCompletely] Lock " + rule + " was already released by thread " + owner.getName());
            }
            return;
        }
        if (ruleIndex < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("[lockReleasedCompletely] Thread " + owner.getName() + " already released lock " + rule);
            }
            return;
        }
        int j = 0;
        while (j < this.graph[threadIndex].length) {
            if (!(this.locks.get(j) instanceof ILock) && this.graph[threadIndex][j] > NO_STATE) {
                this.graph[threadIndex][j] = NO_STATE;
            }
            ++j;
        }
        this.reduceGraph(threadIndex, rule);
    }

    Deadlock lockWaitStart(Thread client, ISchedulingRule lock) {
        this.setToWait(client, lock, false);
        int lockIndex = this.indexOf(lock, false);
        int[] temp = new int[this.lockThreads.size()];
        if (!this.checkWaitCycles(temp, lockIndex)) {
            return null;
        }
        Thread[] threads = this.getThreadsInDeadlock(client);
        Thread candidate = this.resolutionCandidate(threads);
        ISchedulingRule[] locksToSuspend = this.realLocksForThread(candidate);
        Deadlock deadlock = new Deadlock(threads, locksToSuspend, candidate);
        this.reportDeadlock(deadlock);
        if (JobManager.DEBUG_DEADLOCK) {
            throw new IllegalStateException("Deadlock detected. Caused by thread " + client.getName() + '.');
        }
        ISchedulingRule[] iSchedulingRuleArray = locksToSuspend;
        int n = locksToSuspend.length;
        int n2 = 0;
        while (n2 < n) {
            ISchedulingRule element = iSchedulingRuleArray[n2];
            this.setToWait(deadlock.getCandidate(), element, true);
            ++n2;
        }
        return deadlock;
    }

    void lockWaitStop(Thread owner, ISchedulingRule lock) {
        int lockIndex = this.indexOf(lock, false);
        int threadIndex = this.indexOf(owner, false);
        if (threadIndex < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("Thread " + owner.getName() + " was already removed.");
            }
            return;
        }
        if (lockIndex < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("Lock " + lock + " was already removed.");
            }
            return;
        }
        if (this.graph[threadIndex][lockIndex] != WAITING_FOR_LOCK) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("Lock " + lock + " already granted to depth: " + this.graph[threadIndex][lockIndex]);
            }
            return;
        }
        this.graph[threadIndex][lockIndex] = NO_STATE;
        this.reduceGraph(threadIndex, lock);
    }

    private boolean ownsLocks(Thread cause) {
        int threadIndex = this.indexOf(cause, false);
        int j = 0;
        while (j < this.graph[threadIndex].length) {
            if (this.graph[threadIndex][j] > NO_STATE) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private boolean ownsRealLocks(Thread owner) {
        int threadIndex = this.indexOf(owner, false);
        int j = 0;
        while (j < this.graph[threadIndex].length) {
            ISchedulingRule lock;
            if (this.graph[threadIndex][j] > NO_STATE && (lock = this.locks.get(j)) instanceof ILock) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private boolean ownsRuleLocks(Thread owner) {
        int threadIndex = this.indexOf(owner, false);
        int j = 0;
        while (j < this.graph[threadIndex].length) {
            ISchedulingRule lock;
            if (this.graph[threadIndex][j] > NO_STATE && !((lock = this.locks.get(j)) instanceof ILock)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private ISchedulingRule[] realLocksForThread(Thread owner) {
        int threadIndex = this.indexOf(owner, false);
        ArrayList<ISchedulingRule> ownedLocks = new ArrayList<ISchedulingRule>(1);
        int j = 0;
        while (j < this.graph[threadIndex].length) {
            if (this.graph[threadIndex][j] > NO_STATE && this.locks.get(j) instanceof ILock) {
                ownedLocks.add(this.locks.get(j));
            }
            ++j;
        }
        if (ownedLocks.size() == 0) {
            Assert.isLegal(false, "A thread with no real locks was chosen to resolve deadlock.");
        }
        return ownedLocks.toArray(new ISchedulingRule[ownedLocks.size()]);
    }

    /*
     * Unable to fully structure code
     */
    private void reduceGraph(int row, ISchedulingRule lock) {
        numLocks = this.locks.size();
        emptyColumns = new boolean[numLocks];
        j = 0;
        while (j < numLocks) {
            if (lock.isConflicting(this.locks.get(j)) || !(this.locks.get(j) instanceof ILock)) {
                emptyColumns[j] = true;
            }
            ++j;
        }
        rowEmpty = true;
        numEmpty = 0;
        j = 0;
        while (j < this.graph[row].length) {
            if (this.graph[row][j] != DeadlockDetector.NO_STATE) {
                rowEmpty = false;
                break;
            }
            ++j;
        }
        j = emptyColumns.length - 1;
        while (j >= 0) {
            var11_11 = this.graph;
            var10_10 = this.graph.length;
            var9_9 = 0;
            while (var9_9 < var10_10) {
                element = var11_11[var9_9];
                if (emptyColumns[j] && element[j] != DeadlockDetector.NO_STATE) {
                    emptyColumns[j] = false;
                    break;
                }
                ++var9_9;
            }
            if (emptyColumns[j]) {
                this.locks.remove(j);
                ++numEmpty;
            }
            --j;
        }
        if (numEmpty == 0 && !rowEmpty) {
            return;
        }
        if (rowEmpty) {
            this.lockThreads.remove(row);
        }
        numThreads = this.lockThreads.size();
        numLocks = this.locks.size();
        if (numThreads == 0 && numLocks == 0) {
            this.graph = DeadlockDetector.EMPTY_MATRIX;
            return;
        }
        tempGraph = new int[numThreads][numLocks];
        numRowsSkipped = 0;
        i = 0;
        while (i < this.graph.length - numRowsSkipped) {
            block15: {
                block14: {
                    if (i == row && rowEmpty && i >= this.graph.length - ++numRowsSkipped) break;
                    numColsSkipped = 0;
                    j = 0;
                    break block14;
                    while (j < this.graph[i].length - ++numColsSkipped) lbl-1000:
                    // 2 sources

                    {
                        ** while (!emptyColumns[j + numColsSkipped])
lbl56:
                        // 1 sources

                    }
lbl57:
                    // 2 sources

                    if (j >= this.graph[i].length - numColsSkipped) break block15;
                    tempGraph[i][j] = this.graph[i + numRowsSkipped][j + numColsSkipped];
                    ++j;
                }
                if (j < this.graph[i].length - numColsSkipped) ** GOTO lbl-1000
            }
            ++i;
        }
        this.graph = tempGraph;
        Assert.isTrue(numThreads == this.graph.length, "Rows and threads don't match.");
        Assert.isTrue(numLocks == (this.graph.length > 0 ? this.graph[0].length : 0), "Columns and locks don't match.");
    }

    private void reportDeadlock(Deadlock deadlock) {
        Thread[] threads;
        String msg = "Deadlock detected. All locks owned by thread " + deadlock.getCandidate().getName() + " will be suspended.";
        MultiStatus main = new MultiStatus("org.eclipse.core.jobs", 2, msg, (Throwable)new IllegalStateException());
        Thread[] threadArray = threads = deadlock.getThreads();
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            Object[] ownedLocks = this.getOwnedLocks(thread);
            Object waitLock = this.getWaitingLock(thread);
            StringBuilder buf = new StringBuilder("Thread ");
            buf.append(thread.getName());
            buf.append(" has locks: ");
            int j = 0;
            while (j < ownedLocks.length) {
                buf.append(ownedLocks[j]);
                buf.append(j < ownedLocks.length - 1 ? ", " : " ");
                ++j;
            }
            buf.append("and is waiting for lock ");
            buf.append(waitLock);
            Status child = new Status(4, "org.eclipse.core.jobs", 2, buf.toString(), null);
            main.add(child);
            ++n2;
        }
        RuntimeLog.log(main);
    }

    private void resizeGraph() {
        int newRows = this.lockThreads.size();
        int newCols = this.locks.size();
        if (newRows == 0 && newCols == 0) {
            this.graph = EMPTY_MATRIX;
            return;
        }
        int[][] tempGraph = new int[newRows][newCols];
        int i = 0;
        while (i < this.graph.length) {
            System.arraycopy(this.graph[i], 0, tempGraph[i], 0, this.graph[i].length);
            ++i;
        }
        this.graph = tempGraph;
        this.resize = false;
    }

    private Thread resolutionCandidate(Thread[] candidates) {
        int i = 0;
        while (i < candidates.length) {
            if (!this.ownsRuleLocks(candidates[i])) {
                return candidates[i];
            }
            ++i;
        }
        Thread[] threadArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            Thread candidate = threadArray[n2];
            if (this.ownsRealLocks(candidate)) {
                return candidate;
            }
            ++n2;
        }
        return candidates[0];
    }

    private void setToWait(Thread owner, ISchedulingRule lock, boolean suspend) {
        boolean needTransfer = false;
        if (!suspend && !(lock instanceof ILock)) {
            needTransfer = true;
        }
        int lockIndex = this.indexOf(lock, !suspend);
        int threadIndex = this.indexOf(owner, !suspend);
        if (this.resize) {
            this.resizeGraph();
        }
        this.graph[threadIndex][lockIndex] = WAITING_FOR_LOCK;
        if (needTransfer) {
            this.fillPresentEntries(lock, lockIndex);
        }
    }

    public String toDebugString() {
        StringWriter sWriter = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)sWriter, true);
        out.println(" :: ");
        int j = 0;
        while (j < this.locks.size()) {
            out.print(" " + this.locks.get(j) + ',');
            ++j;
        }
        out.println();
        int i = 0;
        while (i < this.graph.length) {
            out.print(" " + this.lockThreads.get(i).getName() + " : ");
            int j2 = 0;
            while (j2 < this.graph[i].length) {
                out.print(" " + this.graph[i][j2] + ',');
                ++j2;
            }
            out.println();
            ++i;
        }
        out.println("-------");
        return sWriter.toString();
    }
}

