/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.core.util.Util;

public class GenericsMapper {
    private final Deque<Map<String, ClassNode>> allGenerics = new LinkedList<Map<String, ClassNode>>();

    public static GenericsMapper gatherGenerics(ClassNode resolvedType, ClassNode declaringType) {
        GenericsMapper mapper = new GenericsMapper();
        ClassNode rCandidate = resolvedType;
        ClassNode uCandidate = resolvedType.redirect();
        Iterator<ClassNode> rIterator = GenericsMapper.getTypeHierarchy(rCandidate, true);
        Iterator<ClassNode> uIterator = GenericsMapper.getTypeHierarchy(uCandidate, false);
        while (rIterator.hasNext() && uIterator.hasNext()) {
            rCandidate = rIterator.next();
            uCandidate = uIterator.next();
            GenericsType[] rgts = GroovyUtils.getGenericsTypes(rCandidate);
            GenericsType[] ugts = GroovyUtils.getGenericsTypes(uCandidate);
            int n = ugts.length;
            if (n > 0 && rgts.length < 1) {
                rgts = new GenericsType[n];
                int i = 0;
                while (i < n) {
                    rgts[i] = new GenericsType(Optional.ofNullable(ugts[i].getUpperBounds()).map(bounds -> bounds[0]).orElse(VariableScope.OBJECT_CLASS_NODE));
                    ++i;
                }
            }
            assert (rgts.length == ugts.length);
            Map resolved = n > 0 ? new TreeMap() : Collections.EMPTY_MAP;
            int i = 0;
            while (i < n) {
                resolved.put(ugts[i].getName(), mapper.resolveParameter(rgts[i], 0));
                ++i;
            }
            mapper.allGenerics.add(resolved);
            if (rCandidate.getName().equals(declaringType.getName())) break;
        }
        return mapper;
    }

    public static GenericsMapper gatherGenerics(List<ClassNode> argumentTypes, ClassNode delegateOrThisType, MethodNode methodDeclaration, GenericsType ... methodGenerics) {
        GenericsMapper mapper;
        block11: {
            Map<Object, Object> resolved;
            GenericsType[] ugts;
            block12: {
                mapper = GenericsMapper.gatherGenerics(delegateOrThisType, methodDeclaration.getDeclaringClass());
                ugts = GroovyUtils.getGenericsTypes(methodDeclaration);
                if (ugts.length <= 0) break block11;
                if (mapper.allGenerics.isEmpty() || (resolved = mapper.allGenerics.removeLast()).isEmpty()) {
                    resolved = new TreeMap();
                }
                mapper.allGenerics.add(resolved);
                if (methodGenerics == null || methodGenerics.length <= 0) break block12;
                assert (methodGenerics.length == ugts.length);
                int i = 0;
                while (i < ugts.length) {
                    resolved.put(ugts[i].getName(), methodGenerics[i].getType());
                    ++i;
                }
                break block11;
            }
            if (argumentTypes == null) break block11;
            GenericsType[] genericsTypeArray = ugts;
            int n = ugts.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType ugt = genericsTypeArray[n2];
                Parameter[] methodParameters = methodDeclaration.getParameters();
                int i = 0;
                int n3 = GenericsMapper.isVargs(methodParameters) ? argumentTypes.size() : Math.min(argumentTypes.size(), methodParameters.length);
                while (i < n3) {
                    ClassNode rbt = argumentTypes.get(i);
                    ClassNode ubt = methodParameters[Math.min(i, methodParameters.length - 1)].getType();
                    while (rbt.isArray() && ubt.isArray()) {
                        rbt = rbt.getComponentType();
                        ubt = ubt.getComponentType();
                    }
                    if (ubt.isGenericsPlaceHolder() && ubt.getUnresolvedName().equals(ugt.getName())) {
                        if (GroovyUtils.isAssignable(rbt, ubt)) {
                            GenericsMapper.saveParameterType(resolved, ugt.getName(), rbt, true);
                        }
                    } else {
                        GenericsType[] ubt_gts = GroovyUtils.getGenericsTypes(ubt);
                        int j = 0;
                        while (j < ubt_gts.length) {
                            if (ubt_gts[j].getType().isGenericsPlaceHolder() && ubt_gts[j].getName().equals(ugt.getName()) && ubt.redirect().isUsingGenerics()) {
                                String key = GroovyUtils.getGenericsTypes(ubt.redirect())[j].getName();
                                GenericsMapper map = GenericsMapper.gatherGenerics(rbt, ubt.redirect());
                                ClassNode rt = map.findParameter(key, null);
                                if (rt == null || !GroovyUtils.isAssignable(rt, ubt_gts[j].getType())) break;
                                GenericsMapper.saveParameterType(resolved, ugt.getName(), rt, false);
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                ++n2;
            }
        }
        return mapper;
    }

    public ClassNode resolveParameter(GenericsType topGT, int depth) {
        if (this.allGenerics.isEmpty()) {
            return topGT.getType();
        }
        if (depth > 10) {
            Util.log(new Status(2, "org.eclipse.jdt.groovy.core", "GRECLIPSE-1040: prevent infinite recursion when resolving type parameters on generics type: " + topGT));
            return topGT.getType();
        }
        ClassNode origType = this.findParameter(topGT.getName(), topGT.getType());
        if (origType.getGenericsTypes() != null) {
            GenericsType[] genericsTypes;
            origType = VariableScope.clone(origType);
            GenericsType[] genericsTypeArray = genericsTypes = origType.getGenericsTypes();
            int n = genericsTypes.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType genericsType = genericsTypeArray[n2];
                if (!genericsType.getName().equals(topGT.getName())) {
                    genericsType.setType(this.findParameter(genericsType.getName(), this.resolveParameter(genericsType, depth + 1)));
                    genericsType.setLowerBound(null);
                    genericsType.setUpperBounds(null);
                    genericsType.setName(genericsType.getType().getName());
                }
                ++n2;
            }
        }
        return origType;
    }

    protected boolean hasGenerics() {
        return !this.allGenerics.isEmpty() && !this.allGenerics.getLast().isEmpty();
    }

    protected ClassNode findParameter(String parameterName, ClassNode defaultType) {
        if (this.allGenerics.isEmpty()) {
            return defaultType;
        }
        ClassNode type = this.allGenerics.getLast().get(parameterName);
        if (type == null) {
            return defaultType;
        }
        return type;
    }

    protected static Iterator<ClassNode> getTypeHierarchy(ClassNode type, boolean useResolved) {
        LinkedHashSet<ClassNode> hierarchy = new LinkedHashSet<ClassNode>();
        VariableScope.createTypeHierarchy(type, hierarchy, useResolved);
        hierarchy.remove(VariableScope.GROOVY_OBJECT_CLASS_NODE);
        hierarchy.remove(VariableScope.OBJECT_CLASS_NODE);
        return hierarchy.iterator();
    }

    protected static boolean isVargs(Parameter[] parameters) {
        Parameter last;
        ClassNode type;
        return parameters.length > 0 && (type = (last = parameters[parameters.length - 1]).getType()).isArray();
    }

    protected static void saveParameterType(Map<String, ClassNode> map, String key, ClassNode val, boolean weak) {
        ClassNode old = map.remove(key);
        if (old != null && !old.equals(val) && !old.equals(VariableScope.OBJECT_CLASS_NODE) && weak) {
            val = old;
        }
        map.put(key, val);
    }
}

