/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.Comment;
import org.codehaus.groovy.ast.TaskEntry;

class MultiLineComment
extends Comment {
    MultiLineComment(int sline, int scol, int eline, int ecol, String string) {
        super(string.charAt(2) == '*' ? 2 : 0, sline, scol, eline, ecol, string);
    }

    @Override
    public List<TaskEntry> getPositionsOf(String taskTag, String taskPriority, int[] lineseps, boolean caseSensitive) {
        int i = this.findTaskTag(this.comment, taskTag, caseSensitive, 0);
        if (i == -1) {
            return Collections.emptyList();
        }
        ArrayList<TaskEntry> taskPositions = new ArrayList<TaskEntry>();
        while (i != -1) {
            if (this.isValidStartLocationForTask(this.comment, i, taskTag)) {
                int pos;
                char ch;
                int taskTagStart;
                int offsetToCommentStart = (this.sline == 1 ? 0 : lineseps[this.sline - 2] + 1) + this.scol - 1;
                int taskEnd = taskTagStart = offsetToCommentStart + i;
                while ((ch = this.comment.charAt(pos = taskEnd - offsetToCommentStart)) != '\n' && ch != '\r') {
                    if (pos + 2 > this.comment.length()) {
                        --taskEnd;
                        break;
                    }
                    ++taskEnd;
                }
                TaskEntry taskEntry = new TaskEntry(taskTagStart, taskEnd - 1, taskTag, taskPriority, this.comment, offsetToCommentStart);
                taskPositions.add(taskEntry);
            }
            i = this.findTaskTag(this.comment, taskTag, caseSensitive, i + taskTag.length());
        }
        return taskPositions;
    }
}

