/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.xbean.classloader;

import java.io.IOException;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/**
 * Abstract implementation of {@link ResourceHandle}.
 * 
 * @author Dain Sundstrom
 */
public abstract class AbstractResourceHandle implements ResourceHandle {

	public byte[] getBytes() throws IOException {
		return IoUtil.getBytes(getInputStream());
	}

	public Manifest getManifest() throws IOException {
		return null;
	}

	public Certificate[] getCertificates() {
		return null;
	}

	public Attributes getAttributes() throws IOException {
		Manifest manifest = getManifest();
		if (manifest == null) {
			return null;
		}
		String entry = getUrl().getFile();
		return manifest.getAttributes(entry);
	}

	public void close() {
	}

	public String toString() {
		return "[" + getName() + ": " + getUrl() + "; code source: " + getCodeSourceUrl() + "]";
	}
}
