/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.trait;

import groovy.lang.MetaProperty;
import java.util.List;
import java.util.function.Function;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.tools.ClosureUtils;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.trait.Traits;

class SuperCallTraitTransformer
extends ClassCodeExpressionTransformer {
    static final String UNRESOLVED_HELPER_CLASS = "UNRESOLVED_HELPER_CLASS";
    private final SourceUnit unit;

    SuperCallTraitTransformer(SourceUnit unit) {
        this.unit = unit;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.unit;
    }

    @Override
    public Expression transform(Expression exp) {
        if (exp instanceof BinaryExpression) {
            return this.transformBinaryExpression((BinaryExpression)exp);
        }
        if (exp instanceof ClosureExpression) {
            return this.transformClosureExpression((ClosureExpression)exp);
        }
        if (exp instanceof PropertyExpression) {
            return this.transformPropertyExpression((PropertyExpression)exp);
        }
        if (exp instanceof MethodCallExpression) {
            return this.transformMethodCallExpression((MethodCallExpression)exp);
        }
        return super.transform(exp);
    }

    private Expression transformBinaryExpression(BinaryExpression exp) {
        Expression trn;
        if (exp.getOperation().isA(1100)) {
            exp.getLeftExpression().putNodeMetaData("assign.target", exp.getOperation());
        }
        if ((trn = super.transform(exp)) instanceof BinaryExpression) {
            BinaryExpression bin = (BinaryExpression)trn;
            Expression leftExpression = bin.getLeftExpression();
            if (bin.getOperation().getType() == 100 && leftExpression instanceof PropertyExpression) {
                ClassNode traitReceiver = null;
                PropertyExpression leftPropertyExpression = (PropertyExpression)leftExpression;
                if (this.isTraitSuperPropertyExpression(leftPropertyExpression.getObjectExpression())) {
                    PropertyExpression pexp = (PropertyExpression)leftPropertyExpression.getObjectExpression();
                    traitReceiver = pexp.getObjectExpression().getType();
                }
                if (traitReceiver != null) {
                    ClassNode helper = this.getHelper(traitReceiver);
                    String setterName = MetaProperty.getSetterName(leftPropertyExpression.getPropertyAsString());
                    List<MethodNode> methods = helper.getMethods(setterName);
                    for (MethodNode method : methods) {
                        Parameter[] parameters = method.getParameters();
                        if (parameters.length != 2 || !SuperCallTraitTransformer.isSelfType(parameters[0], traitReceiver)) continue;
                        ArgumentListExpression args = new ArgumentListExpression(parameters[0].getType().equals(ClassHelper.CLASS_Type) ? GeneralUtils.thisPropX(false, "class") : GeneralUtils.varX("this"), bin.getRightExpression());
                        MethodCallExpression setterCall = new MethodCallExpression((Expression)new ClassExpression(helper), setterName, (Expression)args);
                        setterCall.getMethod().setSourcePosition(leftPropertyExpression.getProperty());
                        setterCall.getObjectExpression().setSourcePosition(traitReceiver);
                        setterCall.setImplicitThis(false);
                        return setterCall;
                    }
                    return bin;
                }
            }
        }
        return trn;
    }

    private Expression transformClosureExpression(ClosureExpression exp) {
        Parameter[] parameterArray = ClosureUtils.getParametersSafe(exp);
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter prm = parameterArray[n2];
            Expression ini = this.transform(prm.getInitialExpression());
            prm.setInitialExpression(ini);
            ++n2;
        }
        this.visitClassCodeContainer(exp.getCode());
        return super.transform(exp);
    }

    private Expression transformPropertyExpression(PropertyExpression exp) {
        Expression classExpression;
        ClassNode traitType;
        if (exp.getNodeMetaData("assign.target") == null && this.isTraitSuperPropertyExpression(exp.getObjectExpression()) && (traitType = (classExpression = ((PropertyExpression)exp.getObjectExpression()).getObjectExpression()).getType()) != null) {
            ClassNode helperType = this.getHelper(traitType);
            Function<MethodNode, MethodCallExpression> makeCall = methodNode -> {
                MethodCallExpression methodCall = new MethodCallExpression((Expression)new ClassExpression(helperType), methodNode.getName(), (Expression)new ArgumentListExpression(methodNode.getParameters()[0].getType().equals(ClassHelper.CLASS_Type) ? GeneralUtils.thisPropX(false, "class") : GeneralUtils.varX("this")));
                methodCall.getObjectExpression().setSourcePosition(traitType);
                methodCall.getMethod().setSourcePosition(exp.getProperty());
                methodCall.setMethodTarget((MethodNode)methodNode);
                methodCall.setImplicitThis(false);
                return methodCall;
            };
            String getterName = MetaProperty.getGetterName(exp.getPropertyAsString(), null);
            for (MethodNode method : helperType.getMethods(getterName)) {
                if (!method.isStatic() || method.getParameters().length != 1 || !SuperCallTraitTransformer.isSelfType(method.getParameters()[0], traitType) || method.getReturnType().equals(ClassHelper.VOID_TYPE)) continue;
                return makeCall.apply(method);
            }
            String isserName = "is" + getterName.substring(3);
            for (MethodNode method : helperType.getMethods(isserName)) {
                if (!method.isStatic() || method.getParameters().length != 1 || !SuperCallTraitTransformer.isSelfType(method.getParameters()[0], traitType) || !method.getReturnType().equals(ClassHelper.boolean_TYPE)) continue;
                return makeCall.apply(method);
            }
        }
        exp.removeNodeMetaData("assign.target");
        return super.transform(exp);
    }

    private Expression transformMethodCallExpression(MethodCallExpression exp) {
        Expression objectExpression;
        ClassNode traitReceiver;
        if (this.isTraitSuperPropertyExpression(exp.getObjectExpression()) && (traitReceiver = ((PropertyExpression)(objectExpression = exp.getObjectExpression())).getObjectExpression().getType()) != null) {
            ClassExpression receiver = new ClassExpression(this.getHelper(traitReceiver));
            receiver.setSourcePosition(traitReceiver);
            List<MethodNode> targets = receiver.getType().getMethods(exp.getMethodAsString());
            boolean isStatic = !targets.isEmpty() && targets.stream().map(MethodNode::getParameters).allMatch(params -> ((Parameter[])params).length > 0 && params[0].getType().equals(ClassHelper.CLASS_Type));
            ArgumentListExpression newArgs = new ArgumentListExpression(isStatic ? GeneralUtils.thisPropX(false, "class") : GeneralUtils.varX("this"));
            Expression arguments = exp.getArguments();
            if (arguments instanceof TupleExpression) {
                List<Expression> expressions = ((TupleExpression)arguments).getExpressions();
                for (Expression expression : expressions) {
                    newArgs.addExpression(this.transform(expression));
                }
            } else {
                newArgs.addExpression(this.transform(arguments));
            }
            MethodCallExpression result = new MethodCallExpression((Expression)receiver, this.transform(exp.getMethod()), (Expression)newArgs);
            result.setImplicitThis(false);
            result.setSpreadSafe(exp.isSpreadSafe());
            result.setSafe(exp.isSafe());
            return result;
        }
        return super.transform(exp);
    }

    private ClassNode getHelper(ClassNode traitReceiver) {
        if (this.helperClassNotCreatedYet(traitReceiver)) {
            ClassNode ret = new InnerClassNode(traitReceiver, Traits.helperClassName(traitReceiver), 5129, ClassHelper.OBJECT_TYPE, ClassNode.EMPTY_ARRAY, null).getPlainNodeReference();
            ret.setRedirect(null);
            traitReceiver.redirect().setNodeMetaData(UNRESOLVED_HELPER_CLASS, ret);
            return ret;
        }
        return Traits.findHelper(traitReceiver).getPlainNodeReference();
    }

    private boolean helperClassNotCreatedYet(ClassNode traitReceiver) {
        return !traitReceiver.redirect().getInnerClasses().hasNext() && this.unit.getAST().getClasses().contains(traitReceiver.redirect());
    }

    private boolean isTraitSuperPropertyExpression(Expression exp) {
        ClassNode type;
        PropertyExpression pexp;
        Expression objectExpression;
        return exp instanceof PropertyExpression && (objectExpression = (pexp = (PropertyExpression)exp).getObjectExpression()) instanceof ClassExpression && Traits.isTrait(type = objectExpression.getType()) && "super".equals(pexp.getPropertyAsString());
    }

    private static boolean isSelfType(Parameter parameter, ClassNode traitType) {
        ClassNode paramType = parameter.getType();
        if (paramType.equals(traitType)) {
            return true;
        }
        return paramType.equals(ClassHelper.CLASS_Type) && paramType.getGenericsTypes() != null && paramType.getGenericsTypes()[0].getType().equals(traitType);
    }
}

