/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.control.SourceUnit;

public class GenericsVisitor
extends ClassCodeVisitorSupport {
    private final SourceUnit source;

    public GenericsVisitor(SourceUnit source) {
        this.source = source;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    @Override
    public void visitClass(ClassNode node) {
        ClassNode[] interfaces;
        boolean error = this.checkWildcard(node);
        if (error) {
            return;
        }
        boolean isAnon = node instanceof InnerClassNode && ((InnerClassNode)node).isAnonymous();
        this.checkGenericsUsage(node.getUnresolvedSuperClass(false), node.getSuperClass(), isAnon ? Boolean.valueOf(true) : null);
        ClassNode[] classNodeArray = interfaces = node.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode anInterface = classNodeArray[n2];
            this.checkGenericsUsage(anInterface, anInterface.redirect());
            ++n2;
        }
        node.visitContents(this);
    }

    @Override
    public void visitField(FieldNode node) {
        ClassNode type = node.getType();
        this.checkGenericsUsage(type, type.redirect());
        super.visitField(node);
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        ClassNode type = call.getType();
        boolean isAnon = type instanceof InnerClassNode && ((InnerClassNode)type).isAnonymous();
        this.checkGenericsUsage(type, type.redirect(), isAnon);
    }

    @Override
    public void visitMethod(MethodNode node) {
        Parameter[] parameters;
        Parameter[] parameterArray = parameters = node.getParameters();
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter param = parameterArray[n2];
            ClassNode paramType = param.getType();
            this.checkGenericsUsage(paramType, paramType.redirect());
            ++n2;
        }
        ClassNode returnType = node.getReturnType();
        this.checkGenericsUsage(returnType, returnType.redirect());
        super.visitMethod(node);
    }

    @Override
    public void visitDeclarationExpression(DeclarationExpression expression) {
        if (expression.isMultipleAssignmentDeclaration()) {
            TupleExpression tExpr = expression.getTupleExpression();
            for (Expression nextExpr : tExpr.getExpressions()) {
                ClassNode declType = nextExpr.getType();
                this.checkGenericsUsage(declType, declType.redirect());
            }
        } else {
            ClassNode declType = expression.getVariableExpression().getType();
            this.checkGenericsUsage(declType, declType.redirect());
        }
        super.visitDeclarationExpression(expression);
    }

    private boolean checkWildcard(ClassNode cn) {
        ClassNode sn = cn.getUnresolvedSuperClass(false);
        if (sn == null) {
            return false;
        }
        GenericsType[] generics = sn.getGenericsTypes();
        if (generics == null) {
            return false;
        }
        boolean error = false;
        GenericsType[] genericsTypeArray = generics;
        int n = generics.length;
        int n2 = 0;
        while (n2 < n) {
            GenericsType generic = genericsTypeArray[n2];
            if (generic.isWildcard()) {
                this.addError("A supertype may not specify a wildcard type", sn);
                error = true;
            }
            ++n2;
        }
        return error;
    }

    private void checkGenericsUsage(ClassNode n, ClassNode cn) {
        this.checkGenericsUsage(n, cn, null);
    }

    private void checkGenericsUsage(ClassNode n, ClassNode cn, Boolean isAnonInnerClass) {
        if (n.isGenericsPlaceHolder()) {
            return;
        }
        GenericsType[] nTypes = n.getGenericsTypes();
        GenericsType[] cnTypes = cn.getGenericsTypes();
        if (nTypes == null) {
            return;
        }
        if (cnTypes == null) {
            String message = "The class " + GenericsVisitor.getPrintName(n) + " (supplied with " + this.plural("type parameter", nTypes.length) + ") refers to the class " + GenericsVisitor.getPrintName(cn) + " which takes no parameters";
            if (nTypes.length == 0) {
                message = String.valueOf(message) + " (invalid Diamond <> usage?)";
            }
            this.addError(message, n);
            return;
        }
        if (nTypes.length != cnTypes.length) {
            String message;
            if (Boolean.FALSE.equals(isAnonInnerClass) && nTypes.length == 0) {
                return;
            }
            if (Boolean.TRUE.equals(isAnonInnerClass) && nTypes.length == 0) {
                message = "Cannot use diamond <> with anonymous inner classes";
            } else {
                message = "The class " + GenericsVisitor.getPrintName(n) + " (supplied with " + this.plural("type parameter", nTypes.length) + ") refers to the class " + GenericsVisitor.getPrintName(cn) + " which takes " + this.plural("parameter", cnTypes.length);
                if (nTypes.length == 0) {
                    message = String.valueOf(message) + " (invalid Diamond <> usage?)";
                }
            }
            this.addError(message, n);
            return;
        }
        int i = 0;
        while (i < nTypes.length) {
            ClassNode nType = nTypes[i].getType();
            ClassNode cnType = cnTypes[i].getType();
            this.checkGenericsUsage(nType, nType.redirect());
            if (!(nTypes[i].isWildcard() || nType.isDerivedFrom(cnType) || cnType.isInterface() && nType.implementsInterface(cnType))) {
                this.addError("The type " + nTypes[i].getName() + " is not a valid substitute for the bounded parameter <" + GenericsVisitor.getPrintName(cnTypes[i]) + ">", n);
            }
            ++i;
        }
    }

    private String plural(String orig, int count) {
        return count + " " + (count == 1 ? orig : String.valueOf(orig) + "s");
    }

    private static String getPrintName(GenericsType gt) {
        StringBuilder ret = new StringBuilder(gt.getName());
        ClassNode[] upperBounds = gt.getUpperBounds();
        ClassNode lowerBound = gt.getLowerBound();
        if (upperBounds != null) {
            if (upperBounds.length != 1 || !"java.lang.Object".equals(GenericsVisitor.getPrintName(upperBounds[0]))) {
                ret.append(" extends ");
                int i = 0;
                while (i < upperBounds.length) {
                    ret.append(GenericsVisitor.getPrintName(upperBounds[i]));
                    if (i + 1 < upperBounds.length) {
                        ret.append(" & ");
                    }
                    ++i;
                }
            }
        } else if (lowerBound != null) {
            ret.append(" super ").append(GenericsVisitor.getPrintName(lowerBound));
        }
        return ret.toString();
    }

    private static String getPrintName(ClassNode cn) {
        StringBuilder ret = new StringBuilder(cn.getName());
        GenericsType[] gts = cn.getGenericsTypes();
        if (gts != null) {
            ret.append("<");
            int i = 0;
            while (i < gts.length) {
                if (i != 0) {
                    ret.append(",");
                }
                ret.append(GenericsVisitor.getPrintName(gts[i]));
                ++i;
            }
            ret.append(">");
        }
        return ret.toString();
    }
}

