/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import java.util.ArrayList;
import java.util.Collections;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyClassScope;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.util.ArrayUtils;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.core.builder.NameEnvironment;

public class GroovyCompilationUnitScope
extends CompilationUnitScope {
    private static final char[][] javaLang = TypeConstants.JAVA_LANG;
    private static final char[][] javaIo = CharOperation.splitOn('.', "java.io".toCharArray());
    private static final char[][] javaNet = CharOperation.splitOn('.', "java.net".toCharArray());
    private static final char[][] javaUtil = CharOperation.splitOn('.', "java.util".toCharArray());
    private static final char[][] groovyLang = CharOperation.splitOn('.', "groovy.lang".toCharArray());
    private static final char[][] groovyUtil = CharOperation.splitOn('.', "groovy.util".toCharArray());
    private static final char[][] javaMathBigDecimal = CharOperation.splitOn('.', "java.math.BigDecimal".toCharArray());
    private static final char[][] javaMathBigInteger = CharOperation.splitOn('.', "java.math.BigInteger".toCharArray());
    static final char[][] GROOVY_LANG_METACLASS = CharOperation.splitOn('.', "groovy.lang.MetaClass".toCharArray());
    static final char[][] GROOVY_LANG_GROOVYOBJECT = CharOperation.splitOn('.', "groovy.lang.GroovyObject".toCharArray());
    private boolean isScript;
    private ImportBinding[] defaultGroovyImports;
    private volatile boolean verified;

    public GroovyCompilationUnitScope(GroovyCompilationUnitDeclaration compilationUnitDeclaration, LookupEnvironment lookupEnvironment) {
        super((CompilationUnitDeclaration)compilationUnitDeclaration, lookupEnvironment);
        if (lookupEnvironment.nameEnvironment instanceof NameEnvironment) {
            ((NameEnvironment)lookupEnvironment.nameEnvironment).avoidAdditionalGroovyAnswers = true;
        }
    }

    public boolean isScript() {
        return this.isScript;
    }

    public void setIsScript(boolean isScript) {
        this.isScript = isScript;
    }

    @Override
    protected ImportBinding[] getDefaultImports() {
        if (this.defaultGroovyImports == null) {
            ArrayList<ImportBinding> importBindings = new ArrayList<ImportBinding>(8);
            Collections.addAll(importBindings, super.getDefaultImports());
            importBindings.add(new ImportBinding(javaIo, true, this.environment.getPackage(javaIo, this.module()), null));
            importBindings.add(new ImportBinding(javaNet, true, this.environment.getPackage(javaNet, this.module()), null));
            importBindings.add(new ImportBinding(javaUtil, true, this.environment.getPackage(javaUtil, this.module()), null));
            importBindings.add(new ImportBinding(groovyLang, true, this.environment.getPackage(groovyLang, this.module()), null));
            importBindings.add(new ImportBinding(groovyUtil, true, this.environment.getPackage(groovyUtil, this.module()), null));
            importBindings.add(new ImportBinding(javaMathBigDecimal, false, this.environment.getType(javaMathBigDecimal), null));
            importBindings.add(new ImportBinding(javaMathBigInteger, false, this.environment.getType(javaMathBigInteger), null));
            this.defaultGroovyImports = importBindings.toArray(new ImportBinding[importBindings.size()]);
        }
        return this.defaultGroovyImports;
    }

    @Override
    protected ClassScope buildClassScope(Scope parent, TypeDeclaration typeDecl) {
        return new GroovyClassScope(parent, typeDecl);
    }

    @Override
    protected void buildTypeBindings(AccessRestriction accessRestriction) {
        super.buildTypeBindings(accessRestriction);
    }

    @Override
    public void augmentTypeHierarchy() {
        SourceTypeBinding[] sourceTypeBindingArray = this.topLevelTypes;
        int n = this.topLevelTypes.length;
        int n2 = 0;
        while (n2 < n) {
            SourceTypeBinding topLevelType = sourceTypeBindingArray[n2];
            if (!topLevelType.isInterface() && !topLevelType.isAnnotationType() && topLevelType.superInterfaces != null) {
                CompilationUnitScope unitScope = this.compilationUnitScope();
                unitScope.recordQualifiedReference(GROOVY_LANG_GROOVYOBJECT);
                ReferenceBinding groovyLangObjectBinding = unitScope.environment.getResolvedType(GROOVY_LANG_GROOVYOBJECT, this);
                if (!topLevelType.implementsInterface(groovyLangObjectBinding, true)) {
                    topLevelType.superInterfaces = (ReferenceBinding[])ArrayUtils.add(topLevelType.superInterfaces, groovyLangObjectBinding);
                }
            }
            ++n2;
        }
    }

    @Override
    protected void checkPublicTypeNameMatchesFilename(TypeDeclaration typeDecl) {
    }

    @Override
    protected boolean reportPackageIsNotExpectedPackage(CompilationUnitDeclaration compUnitDecl) {
        char[][] declaredPackage;
        char[][] cArray = declaredPackage = compUnitDecl.currentPackage != null ? compUnitDecl.currentPackage.tokens : CharOperation.NO_CHAR_CHAR;
        if (!(CharOperation.equals(declaredPackage, new char[][]{{'?'}}) || declaredPackage.length == 0 && this.isScript)) {
            this.problemReporter().packageIsNotExpectedPackage(compUnitDecl);
            return true;
        }
        return false;
    }

    @Override
    protected void checkParameterizedTypes() {
    }

    @Override
    public boolean reportInvalidType(TypeReference typeReference, TypeBinding resolvedType) {
        ProblemReferenceBinding problemRefBinding;
        return resolvedType instanceof ProblemReferenceBinding && (problemRefBinding = (ProblemReferenceBinding)resolvedType).problemId() == 3;
    }

    @Override
    protected void reportImportProblem(ImportReference importReference, Binding importBinding) {
        if (importBinding instanceof ProblemReferenceBinding && ((ProblemReferenceBinding)importBinding).problemId() == 1) {
            return;
        }
        super.reportImportProblem(importReference, importBinding);
    }

    @Override
    public boolean canSeeEverything() {
        return true;
    }

    @Override
    public boolean checkTargetCompatibility() {
        return false;
    }

    @Override
    protected boolean canBeSeenBy(ReferenceBinding type, PackageBinding fPackage) {
        return true;
    }

    @Override
    public boolean scannerAvailable() {
        return false;
    }

    @Override
    public ReferenceBinding selectBinding(ReferenceBinding newlyFound, ReferenceBinding originallyFound, boolean isDeclaredImport) {
        if (isDeclaredImport && originallyFound.fPackage != null) {
            char[][] packageName = originallyFound.fPackage.compoundName;
            if (CharOperation.equals(javaLang, packageName) || CharOperation.equals(javaUtil, packageName) || CharOperation.equals(javaIo, packageName) || CharOperation.equals(javaNet, packageName) || CharOperation.equals(groovyLang, packageName) || CharOperation.equals(groovyUtil, packageName)) {
                return newlyFound;
            }
            return originallyFound;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verifyMethods(MethodVerifier verifier) {
        if (!this.verified) {
            GroovyCompilationUnitScope groovyCompilationUnitScope = this;
            synchronized (groovyCompilationUnitScope) {
                if (!this.verified) {
                    this.verified = true;
                    super.verifyMethods(verifier);
                }
            }
        }
    }
}

