/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.classloader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.xbean.classloader.AbstractUrlResourceLocation;
import org.apache.xbean.classloader.DirectoryResourceLocation;
import org.apache.xbean.classloader.JarResourceLocation;
import org.apache.xbean.classloader.ResourceEnumeration;
import org.apache.xbean.classloader.ResourceFinder;
import org.apache.xbean.classloader.ResourceHandle;
import org.apache.xbean.classloader.ResourceLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlResourceFinder
implements ResourceFinder {
    private static final JarFileFactory DEFAULT_JAR_FILE_FACTORY = new JarFileFactory(){

        public JarFile newJarFile(File file) throws IOException {
            return new JarFile(file);
        }
    };
    private final Object lock = new Object();
    private final LinkedHashSet<URL> urls = new LinkedHashSet();
    private final LinkedHashMap<URL, ResourceLocation> classPath = new LinkedHashMap();
    private final LinkedHashSet<File> watchedFiles = new LinkedHashSet();
    private boolean destroyed = false;
    private JarFileFactory jarFileFactory;

    public UrlResourceFinder(JarFileFactory jarFileFactory) {
        this(jarFileFactory, new URL[0]);
    }

    public UrlResourceFinder(JarFileFactory jarFileFactory, URL[] urls) {
        this.jarFileFactory = jarFileFactory == null ? DEFAULT_JAR_FILE_FACTORY : jarFileFactory;
        this.addUrls(urls);
    }

    protected final JarFileFactory getJarFileFactory() {
        return this.jarFileFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            this.urls.clear();
            for (ResourceLocation resourceLocation : this.classPath.values()) {
                resourceLocation.close();
            }
            this.classPath.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceHandle getResource(String resourceName) {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (!this.destroyed) break block5;
                return null;
            }
            for (Map.Entry<URL, ResourceLocation> entry : this.getClassPath().entrySet()) {
                ResourceLocation resourceLocation = entry.getValue();
                ResourceHandle resourceHandle = resourceLocation.getResourceHandle(resourceName);
                if (resourceHandle == null || resourceHandle.isDirectory()) continue;
                return resourceHandle;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL findResource(String resourceName) {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (!this.destroyed) break block5;
                return null;
            }
            for (Map.Entry<URL, ResourceLocation> entry : this.getClassPath().entrySet()) {
                ResourceLocation resourceLocation = entry.getValue();
                ResourceHandle resourceHandle = resourceLocation.getResourceHandle(resourceName);
                if (resourceHandle == null) continue;
                return resourceHandle.getUrl();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> findResources(String resourceName) {
        Object object = this.lock;
        synchronized (object) {
            return new ResourceEnumeration(new ArrayList<ResourceLocation>(this.getClassPath().values()), resourceName);
        }
    }

    public void addUrl(URL url) {
        this.addUrls(Collections.singletonList(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getUrls() {
        Object object = this.lock;
        synchronized (object) {
            return this.urls.toArray(new URL[this.urls.size()]);
        }
    }

    protected void addUrls(URL[] urls) {
        this.addUrls(Arrays.asList(urls));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUrls(List<URL> urls) {
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed) {
                throw new IllegalStateException("UrlResourceFinder has been destroyed");
            }
            boolean shouldRebuild = this.urls.addAll(urls);
            if (shouldRebuild) {
                this.rebuildClassPath();
            }
        }
    }

    private LinkedHashMap<URL, ResourceLocation> getClassPath() {
        assert (Thread.holdsLock(this.lock)) : "This method can only be called while holding the lock";
        for (File file : this.watchedFiles) {
            if (!file.canRead()) continue;
            this.rebuildClassPath();
            break;
        }
        return this.classPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rebuildClassPath() {
        assert (Thread.holdsLock(this.lock)) : "This method can only be called while holding the lock";
        LinkedHashMap<URL, ResourceLocation> existingJarFiles = new LinkedHashMap<URL, ResourceLocation>(this.classPath);
        this.classPath.clear();
        LinkedList<URL> locationStack = new LinkedList<URL>(this.urls);
        try {
            while (!locationStack.isEmpty()) {
                URL url = locationStack.removeFirst();
                if (this.classPath.containsKey(url)) continue;
                ResourceLocation resourceLocation = (ResourceLocation)existingJarFiles.remove(url);
                if (resourceLocation == null) {
                    try {
                        File file = this.cacheUrl(url);
                        resourceLocation = this.createResourceLocation(url, file);
                    }
                    catch (FileNotFoundException e) {
                        if ("file".equals(url.getProtocol())) {
                            File file = new File(url.getPath());
                            this.watchedFiles.add(file);
                            continue;
                        }
                    }
                    catch (IOException ignored) {
                        continue;
                    }
                }
                this.classPath.put(resourceLocation.getCodeSource(), resourceLocation);
                List<URL> manifestClassPath = this.getManifestClassPath(resourceLocation);
                locationStack.addAll(0, manifestClassPath);
            }
        }
        catch (Error e) {
            this.destroy();
            throw e;
        }
        for (ResourceLocation resourceLocation : existingJarFiles.values()) {
            resourceLocation.close();
        }
    }

    protected File cacheUrl(URL url) throws IOException {
        File file;
        if (!"file".equals(url.getProtocol())) {
            throw new Error("Only local file jars are supported " + url);
        }
        try {
            file = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            file = new File(url.getPath());
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IOException("File is not readable: " + file.getAbsolutePath());
        }
        return file;
    }

    protected ResourceLocation createResourceLocation(URL codeSource, File cacheFile) throws IOException {
        if (!cacheFile.exists()) {
            throw new FileNotFoundException(cacheFile.getAbsolutePath());
        }
        if (!cacheFile.canRead()) {
            throw new IOException("File is not readable: " + cacheFile.getAbsolutePath());
        }
        AbstractUrlResourceLocation resourceLocation = null;
        resourceLocation = cacheFile.isDirectory() ? new DirectoryResourceLocation(cacheFile) : new JarResourceLocation(codeSource, this.jarFileFactory.newJarFile(cacheFile));
        return resourceLocation;
    }

    private List<URL> getManifestClassPath(ResourceLocation resourceLocation) {
        try {
            Manifest manifest = resourceLocation.getManifest();
            if (manifest == null) {
                return Collections.emptyList();
            }
            String manifestClassPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (manifestClassPath == null) {
                return Collections.emptyList();
            }
            URL codeSource = resourceLocation.getCodeSource();
            LinkedList<URL> classPathUrls = new LinkedList<URL>();
            StringTokenizer tokenizer = new StringTokenizer(manifestClassPath, " ");
            while (tokenizer.hasMoreTokens()) {
                String entry = tokenizer.nextToken();
                try {
                    URL entryUrl = new URL(codeSource, entry);
                    classPathUrls.addLast(entryUrl);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return classPathUrls;
        }
        catch (IOException ignored) {
            return Collections.emptyList();
        }
    }

    public static interface JarFileFactory {
        public JarFile newJarFile(File var1) throws IOException;
    }
}

