/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import groovyjarjarasm.asm.Opcodes;
import java.util.List;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.apache.groovy.ast.tools.MethodNodeUtils;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AstToTextHelper;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class MethodNode
extends AnnotatedNode
implements Opcodes {
    public static final String SCRIPT_BODY_METHOD_KEY = "org.codehaus.groovy.ast.MethodNode.isScriptBody";
    private final String name;
    private int modifiers;
    private boolean syntheticPublic;
    private ClassNode returnType;
    private Parameter[] parameters;
    private boolean hasDefaultValue = false;
    private Statement code;
    private boolean dynamicReturnType;
    private VariableScope variableScope;
    private final ClassNode[] exceptions;
    private final boolean staticConstructor;
    private GenericsType[] genericsTypes = null;
    private boolean hasDefault;
    String typeDescriptor;
    private MethodNode original = this;

    public MethodNode(String name, int modifiers, ClassNode returnType, Parameter[] parameters, ClassNode[] exceptions, Statement code) {
        this.name = name;
        this.modifiers = modifiers;
        this.code = code;
        this.setReturnType(returnType);
        this.setParameters(parameters);
        this.hasDefault = false;
        this.exceptions = exceptions;
        this.staticConstructor = name != null && name.equals("<clinit>");
    }

    public String getTypeDescriptor() {
        if (this.typeDescriptor == null) {
            this.typeDescriptor = MethodNodeUtils.methodDescriptor(this);
        }
        return this.typeDescriptor;
    }

    private void invalidateCachedData() {
        this.typeDescriptor = null;
    }

    public boolean isVoidMethod() {
        return this.returnType == ClassHelper.VOID_TYPE;
    }

    public Statement getCode() {
        return this.code;
    }

    public void setCode(Statement code) {
        this.code = code;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.invalidateCachedData();
        this.modifiers = modifiers;
    }

    public String getName() {
        return this.name;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameter[] parameters) {
        this.invalidateCachedData();
        VariableScope scope = new VariableScope();
        this.hasDefaultValue = false;
        this.parameters = parameters;
        if (parameters != null && parameters.length > 0) {
            Parameter[] parameterArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter para = parameterArray[n2];
                if (para.hasInitialExpression()) {
                    this.hasDefaultValue = true;
                }
                para.setInStaticContext(this.isStatic());
                scope.putDeclaredVariable(para);
                ++n2;
            }
        }
        this.setVariableScope(scope);
    }

    public ClassNode getReturnType() {
        return this.returnType;
    }

    public VariableScope getVariableScope() {
        return this.variableScope;
    }

    public void setVariableScope(VariableScope variableScope) {
        this.variableScope = variableScope;
        variableScope.setInStaticContext(this.isStatic());
    }

    public boolean isDynamicReturnType() {
        return this.dynamicReturnType;
    }

    public boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isPackageScope() {
        return !this.isPrivate() && !this.isProtected() && !this.isPublic();
    }

    public boolean hasDefaultValue() {
        return this.hasDefaultValue;
    }

    public boolean isScriptBody() {
        return this.getDeclaringClass() != null && this.getDeclaringClass().isScript() && this.getName().equals("run") && (this.parameters == null || this.parameters.length == 0) && this.returnType != null && this.returnType.getName().equals("java.lang.Object");
    }

    public void setIsScriptBody() {
        this.setNodeMetaData(SCRIPT_BODY_METHOD_KEY, true);
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[" + this.getTypeDescriptor() + " from " + ClassNodeUtils.formatTypeName(this.getDeclaringClass()) + "]";
    }

    public void setReturnType(ClassNode returnType) {
        this.invalidateCachedData();
        this.dynamicReturnType |= ClassHelper.DYNAMIC_TYPE == returnType;
        this.returnType = returnType;
        if (returnType == null) {
            this.returnType = ClassHelper.OBJECT_TYPE;
        }
    }

    public ClassNode[] getExceptions() {
        return this.exceptions;
    }

    public Statement getFirstStatement() {
        if (this.code == null) {
            return null;
        }
        Statement first = this.code;
        while (first instanceof BlockStatement) {
            List<Statement> list = ((BlockStatement)first).getStatements();
            first = list.isEmpty() ? null : list.get(0);
        }
        return first;
    }

    public GenericsType[] getGenericsTypes() {
        return this.genericsTypes;
    }

    public void setGenericsTypes(GenericsType[] genericsTypes) {
        this.invalidateCachedData();
        this.genericsTypes = genericsTypes;
    }

    public void setAnnotationDefault(boolean b) {
        this.hasDefault = b;
    }

    public boolean hasAnnotationDefault() {
        return this.hasDefault;
    }

    public boolean isStaticConstructor() {
        return this.staticConstructor;
    }

    public boolean isSyntheticPublic() {
        return this.syntheticPublic;
    }

    public void setSyntheticPublic(boolean syntheticPublic) {
        this.syntheticPublic = syntheticPublic;
    }

    @Override
    public String getText() {
        String retType = AstToTextHelper.getClassText(this.returnType);
        String exceptionTypes = AstToTextHelper.getThrowsClauseText(this.exceptions);
        String parms = AstToTextHelper.getParametersText(this.parameters);
        return String.valueOf(AstToTextHelper.getModifiersText(this.modifiers)) + " " + retType + " " + this.name + "(" + parms + ") " + exceptionTypes + " { ... }";
    }

    public MethodNode getOriginal() {
        return this.original;
    }

    public void setOriginal(MethodNode original) {
        this.original = original;
    }
}

