/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import java.io.IOException;
import java.io.Reader;
import org.apache.groovy.parser.antlr4.AstBuilder;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.antlr.ErrorRecoveredCSTParserPluginFactory;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.ParserPlugin;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.StringReaderSource;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.syntax.ParserException;
import org.codehaus.groovy.syntax.Reduction;

public abstract class ParserPluginFactory {
    public abstract ParserPlugin createParserPlugin();

    public static ParserPluginFactory antlr4() {
        return new ParserPluginFactory(){

            @Override
            public ParserPlugin createParserPlugin() {
                return new ParserPlugin(){

                    @Override
                    public Reduction parseCST(SourceUnit sourceUnit, Reader reader) throws CompilationFailedException {
                        if (!sourceUnit.getSource().canReopenSource()) {
                            try {
                                sourceUnit.setSource(new StringReaderSource(IOGroovyMethods.getText(reader), sourceUnit.getConfiguration()));
                            }
                            catch (IOException e) {
                                throw new GroovyBugError("Failed to create StringReaderSource", e);
                            }
                        }
                        return null;
                    }

                    @Override
                    public ModuleNode buildAST(SourceUnit sourceUnit, ClassLoader classLoader, Reduction cst) throws ParserException {
                        if (!($assertionsDisabled || sourceUnit.getSource() != null && sourceUnit.getSource().canReopenSource())) {
                            throw new AssertionError();
                        }
                        return new AstBuilder(sourceUnit, sourceUnit.getConfiguration().isGroovydocEnabled(), sourceUnit.getConfiguration().isRuntimeGroovydocEnabled()).buildAST();
                    }
                };
            }
        };
    }

    @Deprecated
    public static ParserPluginFactory antlr2() {
        return new ErrorRecoveredCSTParserPluginFactory();
    }
}

