/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc.transformers;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.WideningCategories;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.classgen.asm.sc.StaticPropertyAccessHelper;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.Types;
import org.codehaus.groovy.transform.sc.ListOfExpressionsExpression;
import org.codehaus.groovy.transform.sc.StaticCompilationMetadataKeys;
import org.codehaus.groovy.transform.sc.transformers.CompareIdentityExpression;
import org.codehaus.groovy.transform.sc.transformers.CompareToNullExpression;
import org.codehaus.groovy.transform.sc.transformers.StaticCompilationTransformer;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

public class BinaryExpressionTransformer {
    private static final MethodNode COMPARE_TO_METHOD = ClassHelper.COMPARABLE_TYPE.getMethods("compareTo").get(0);
    private static final ConstantExpression CONSTANT_MINUS_ONE = GeneralUtils.constX(-1, true);
    private static final ConstantExpression CONSTANT_ZERO = GeneralUtils.constX(0, true);
    private static final ConstantExpression CONSTANT_ONE = GeneralUtils.constX(1, true);
    private int tmpVarCounter;
    private final StaticCompilationTransformer staticCompilationTransformer;

    public BinaryExpressionTransformer(StaticCompilationTransformer staticCompilationTransformer) {
        this.staticCompilationTransformer = staticCompilationTransformer;
    }

    /*
     * WARNING - void declaration
     */
    public Expression transformBinaryExpression(BinaryExpression bin) {
        Expression right;
        Expression left;
        MethodNode directMCT;
        Expression optimized;
        if (bin instanceof DeclarationExpression && (optimized = BinaryExpressionTransformer.transformDeclarationExpression(bin)) != null) {
            return optimized;
        }
        Object[] list = (Object[])bin.getNodeMetaData((Object)StaticCompilationMetadataKeys.BINARY_EXP_TARGET);
        Token operation = bin.getOperation();
        int operationType = operation.getType();
        Expression rightExpression = bin.getRightExpression();
        Expression leftExpression = bin.getLeftExpression();
        if (bin instanceof DeclarationExpression && leftExpression instanceof VariableExpression) {
            ClassNode declarationType = ((VariableExpression)leftExpression).getOriginType();
            if (rightExpression instanceof ConstantExpression) {
                ConstantExpression constant;
                ClassNode unwrapper = ClassHelper.getUnwrapper(declarationType);
                ClassNode wrapper = ClassHelper.getWrapper(declarationType);
                if (!rightExpression.getType().equals(declarationType) && wrapper.isDerivedFrom(ClassHelper.Number_TYPE) && WideningCategories.isDoubleCategory(unwrapper) && !(constant = (ConstantExpression)rightExpression).isNullExpression()) {
                    return BinaryExpressionTransformer.optimizeConstantInitialization(bin, operation, constant, leftExpression, declarationType);
                }
            }
        }
        if (operationType == 100 && leftExpression instanceof PropertyExpression && (directMCT = (MethodNode)leftExpression.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET)) != null) {
            left = (PropertyExpression)leftExpression;
            right = this.staticCompilationTransformer.transform(rightExpression);
            return BinaryExpressionTransformer.transformPropertyAssignmentToSetterCall(left, right, directMCT);
        }
        if (operationType == 123 || operationType == 120) {
            AnnotatedNode compareToNullExpression = null;
            if (AsmClassGenerator.isNullConstant(leftExpression)) {
                compareToNullExpression = new CompareToNullExpression(this.staticCompilationTransformer.transform(rightExpression), operationType == 123);
            } else if (AsmClassGenerator.isNullConstant(rightExpression)) {
                compareToNullExpression = new CompareToNullExpression(this.staticCompilationTransformer.transform(leftExpression), operationType == 123);
            }
            if (compareToNullExpression != null) {
                compareToNullExpression.setSourcePosition(bin);
                return compareToNullExpression;
            }
        } else if (operationType == 573) {
            return this.staticCompilationTransformer.transform(BinaryExpressionTransformer.convertInOperatorToTernary(bin, rightExpression, leftExpression));
        }
        if (list != null) {
            MethodCallExpression call;
            left = this.staticCompilationTransformer.transform(leftExpression);
            right = this.staticCompilationTransformer.transform(rightExpression);
            if (operationType == 128 && this.findType(leftExpression).implementsInterface(ClassHelper.COMPARABLE_TYPE) && this.findType(rightExpression).implementsInterface(ClassHelper.COMPARABLE_TYPE)) {
                call = GeneralUtils.callX(left, "compareTo", (Expression)GeneralUtils.args(right));
                call.setImplicitThis(false);
                call.setMethodTarget(COMPARE_TO_METHOD);
                call.setSourcePosition(bin);
                TernaryExpression expr = GeneralUtils.ternaryX(GeneralUtils.boolX(new CompareToNullExpression(right, true)), CONSTANT_ONE, call);
                expr.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, ClassHelper.int_TYPE);
                expr = GeneralUtils.ternaryX(GeneralUtils.boolX(new CompareToNullExpression(left, true)), CONSTANT_MINUS_ONE, expr);
                expr.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, ClassHelper.int_TYPE);
                expr = GeneralUtils.ternaryX(GeneralUtils.boolX(new CompareIdentityExpression(left, right)), CONSTANT_ZERO, expr);
                expr.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, ClassHelper.int_TYPE);
                return expr;
            }
            BinaryExpression optimized2 = BinaryExpressionTransformer.tryOptimizeCharComparison(left, right, bin);
            if (optimized2 != null) {
                optimized2.removeNodeMetaData((Object)StaticCompilationMetadataKeys.BINARY_EXP_TARGET);
                return this.transformBinaryExpression(optimized2);
            }
            String name = (String)list[1];
            MethodNode node = (MethodNode)list[0];
            boolean isAssignment = Types.isAssignment(operationType);
            Expression expr = !isAssignment ? left : new ExpressionTransformer(){

                @Override
                public Expression transform(Expression expression) {
                    if (expression == null) {
                        return null;
                    }
                    Expression transformed = expression.transformExpression(this);
                    if (transformed.getEnd() > 0 || transformed.getLineNumber() > 0) {
                        if (transformed != expression) {
                            transformed.setStart(0);
                            transformed.setEnd(-1);
                            transformed.setNameStart(0);
                            transformed.setNameEnd(-1);
                            transformed.setLineNumber(-1);
                            transformed.setColumnNumber(-1);
                            transformed.setLastLineNumber(-1);
                            transformed.setLastColumnNumber(-1);
                        } else if (expression instanceof ConstantExpression) {
                            ConstantExpression ce = (ConstantExpression)expression;
                            ConstantExpression copy = new ConstantExpression(ce.getValue());
                            copy.setConstantName(ce.getConstantName());
                            copy.setDeclaringClass(ce.getDeclaringClass());
                            copy.setSynthetic(ce.isSynthetic());
                            copy.setType(ce.getType());
                            copy.copyNodeMetaData(ce);
                            transformed = copy;
                        } else if (expression instanceof VariableExpression) {
                            VariableExpression ve = (VariableExpression)expression;
                            VariableExpression copy = new VariableExpression(ve.getName(), ve.getOriginType());
                            copy.setAccessedVariable(ve.getAccessedVariable());
                            copy.setClosureSharedVariable(ve.isClosureSharedVariable());
                            copy.setDeclaringClass(ve.getDeclaringClass());
                            if (ve.isDynamicTyped()) {
                                copy.setType(ClassHelper.DYNAMIC_TYPE);
                            }
                            copy.setInStaticContext(ve.isInStaticContext());
                            copy.setModifiers(ve.getModifiers());
                            copy.setSynthetic(ve.isSynthetic());
                            copy.setType(ve.getType());
                            copy.setUseReferenceDirectly(ve.isUseReferenceDirectly());
                            copy.copyNodeMetaData(ve);
                            transformed = copy;
                        }
                    }
                    return transformed;
                }
            }.transform(left);
            MethodNode adapter = StaticCompilationTransformer.BYTECODE_BINARY_ADAPTERS.get(operationType);
            if (adapter != null) {
                ClassExpression classExpression = GeneralUtils.classX(StaticCompilationTransformer.BYTECODE_ADAPTER_CLASS);
                call = GeneralUtils.callX((Expression)classExpression, "compareEquals", (Expression)GeneralUtils.args(expr, right));
                call.setMethodTarget(adapter);
            } else {
                call = GeneralUtils.callX(expr, name, (Expression)GeneralUtils.args(right));
                call.setMethodTarget(node);
            }
            call.setImplicitThis(false);
            if (!isAssignment) {
                call.setSourcePosition(bin);
                return call;
            }
            expr = GeneralUtils.binX(left, Token.newSymbol(100, operation.getStartLine(), operation.getStartColumn()), call);
            expr.putNodeMetaData("original.operator", operation);
            expr.setSourcePosition(bin);
            return expr;
        }
        if (operationType == 100 && leftExpression instanceof TupleExpression && rightExpression instanceof ListExpression) {
            ListOfExpressionsExpression cle = new ListOfExpressionsExpression();
            boolean isDeclaration = bin instanceof DeclarationExpression;
            List<Expression> leftExpressions = ((TupleExpression)leftExpression).getExpressions();
            List<Expression> rightExpressions = ((ListExpression)rightExpression).getExpressions();
            Iterator<Expression> leftIt = leftExpressions.iterator();
            Iterator<Expression> rightIt = rightExpressions.iterator();
            if (isDeclaration) {
                while (leftIt.hasNext()) {
                    Expression left2 = leftIt.next();
                    if (!rightIt.hasNext()) continue;
                    Expression right2 = rightIt.next();
                    DeclarationExpression bexp = new DeclarationExpression(left2, operation, right2);
                    bexp.setSourcePosition(right2);
                    cle.addExpression(bexp);
                }
            } else {
                void var16_27;
                int size = rightExpressions.size();
                ArrayList<DeclarationExpression> tmpAssignments = new ArrayList<DeclarationExpression>(size);
                ArrayList<BinaryExpression> finalAssignments = new ArrayList<BinaryExpression>(size);
                boolean bl = false;
                int n = Math.min(size, leftExpressions.size());
                while (var16_27 < n) {
                    Expression left3 = leftIt.next();
                    Expression right3 = rightIt.next();
                    VariableExpression tmpVar = GeneralUtils.varX("$tmpVar$" + this.tmpVarCounter++);
                    BinaryExpression bexp = new DeclarationExpression(tmpVar, operation, right3);
                    bexp.setSourcePosition(right3);
                    tmpAssignments.add((DeclarationExpression)bexp);
                    bexp = GeneralUtils.binX(left3, operation, GeneralUtils.varX(tmpVar));
                    bexp.setSourcePosition(left3);
                    finalAssignments.add(bexp);
                    ++var16_27;
                }
                for (Expression expression : tmpAssignments) {
                    cle.addExpression(expression);
                }
                for (Expression expression : finalAssignments) {
                    cle.addExpression(expression);
                }
            }
            return this.staticCompilationTransformer.transform(cle);
        }
        return this.staticCompilationTransformer.superTransform(bin);
    }

    private ClassNode findType(Expression expression) {
        ClassNode classNode = this.staticCompilationTransformer.getClassNode();
        return this.staticCompilationTransformer.getTypeChooser().resolveType(expression, classNode);
    }

    private static BinaryExpression tryOptimizeCharComparison(Expression left, Expression right, BinaryExpression bin) {
        int op = bin.getOperation().getType();
        if (StaticTypeCheckingSupport.isCompareToBoolean(op) || op == 123 || op == 120) {
            Character cLeft = BinaryExpressionTransformer.tryCharConstant(left);
            Character cRight = BinaryExpressionTransformer.tryCharConstant(right);
            if (cLeft != null || cRight != null) {
                Expression oLeft = cLeft == null ? left : GeneralUtils.constX(cLeft, true);
                oLeft.setSourcePosition(left);
                Expression oRight = cRight == null ? right : GeneralUtils.constX(cRight, true);
                oRight.setSourcePosition(right);
                bin.setLeftExpression(oLeft);
                bin.setRightExpression(oRight);
                return bin;
            }
        }
        return null;
    }

    private static Character tryCharConstant(Expression expr) {
        String value;
        if (expr instanceof ConstantExpression && ClassHelper.STRING_TYPE.equals(expr.getType()) && (value = (String)((ConstantExpression)expr).getValue()) != null && value.length() == 1) {
            return Character.valueOf(value.charAt(0));
        }
        return null;
    }

    private static Expression transformDeclarationExpression(BinaryExpression bin) {
        Expression rightExpression;
        Character c;
        Expression leftExpression = bin.getLeftExpression();
        if (leftExpression instanceof VariableExpression && ClassHelper.char_TYPE.equals(((VariableExpression)leftExpression).getOriginType()) && (c = BinaryExpressionTransformer.tryCharConstant(rightExpression = bin.getRightExpression())) != null) {
            ConstantExpression ce = GeneralUtils.constX(c, true);
            ce.setSourcePosition(rightExpression);
            bin.setRightExpression(ce);
            return bin;
        }
        return null;
    }

    private static Expression convertInOperatorToTernary(BinaryExpression bin, Expression rightExpression, Expression leftExpression) {
        MethodCallExpression call = GeneralUtils.callX(rightExpression, "isCase", leftExpression);
        call.setMethodTarget((MethodNode)bin.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET));
        call.setSourcePosition(bin);
        call.copyNodeMetaData(bin);
        TernaryExpression tExp = GeneralUtils.ternaryX(GeneralUtils.boolX(GeneralUtils.binX(rightExpression, Token.newSymbol("==", -1, -1), GeneralUtils.nullX())), GeneralUtils.binX(leftExpression, Token.newSymbol("==", -1, -1), GeneralUtils.nullX()), call);
        return tExp;
    }

    private static DeclarationExpression optimizeConstantInitialization(BinaryExpression originalDeclaration, Token operation, ConstantExpression constant, Expression leftExpression, ClassNode declarationType) {
        ConstantExpression cexp = GeneralUtils.constX(BinaryExpressionTransformer.convertConstant((Number)constant.getValue(), ClassHelper.getWrapper(declarationType)), true);
        cexp.setType(declarationType);
        cexp.setSourcePosition(constant);
        DeclarationExpression result = new DeclarationExpression(leftExpression, operation, (Expression)cexp);
        result.setSourcePosition(originalDeclaration);
        result.copyNodeMetaData(originalDeclaration);
        return result;
    }

    private static Object convertConstant(Number source, ClassNode target) {
        if (ClassHelper.Byte_TYPE.equals(target)) {
            return source.byteValue();
        }
        if (ClassHelper.Short_TYPE.equals(target)) {
            return source.shortValue();
        }
        if (ClassHelper.Integer_TYPE.equals(target)) {
            return source.intValue();
        }
        if (ClassHelper.Long_TYPE.equals(target)) {
            return source.longValue();
        }
        if (ClassHelper.Float_TYPE.equals(target)) {
            return Float.valueOf(source.floatValue());
        }
        if (ClassHelper.Double_TYPE.equals(target)) {
            return source.doubleValue();
        }
        if (ClassHelper.BigInteger_TYPE.equals(target)) {
            return DefaultGroovyMethods.asType(source, BigInteger.class);
        }
        if (ClassHelper.BigDecimal_TYPE.equals(target)) {
            return DefaultGroovyMethods.asType(source, BigDecimal.class);
        }
        throw new IllegalArgumentException("Unsupported conversion");
    }

    private static Expression transformPropertyAssignmentToSetterCall(PropertyExpression leftExpression, Expression rightExpression, MethodNode directMCT) {
        return StaticPropertyAccessHelper.transformToSetterCall(leftExpression.getObjectExpression(), directMCT, rightExpression, false, leftExpression.isSafe(), false, true, leftExpression);
    }
}

