/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import groovy.lang.Tuple;
import groovy.lang.Tuple2;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.groovy.ast.tools.ExpressionUtils;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImmutableClassNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.ClosureUtils;
import org.codehaus.groovy.control.ClassNodeResolver;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.trait.Traits;

public class ResolveVisitor
extends ClassCodeExpressionTransformer {
    public static final String[] DEFAULT_IMPORTS = new String[]{"java.lang.", "java.util.", "java.io.", "java.net.", "groovy.lang.", "groovy.util."};
    private static final String BIGINTEGER_STR = "BigInteger";
    private static final String BIGDECIMAL_STR = "BigDecimal";
    public static final String QUESTION_MARK = "?";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected ClassNode currentClass;
    public final CompilationUnit compilationUnit;
    private SourceUnit source;
    private VariableScope currentScope;
    private boolean isTopLevelProperty = true;
    private boolean inPropertyExpression = false;
    private boolean inClosure = false;
    private final Map<ClassNode, ClassNode> possibleOuterClassNodeMap = new HashMap<ClassNode, ClassNode>();
    private Map<GenericsType.GenericsTypeName, GenericsType> genericParameterNames = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
    private final Set<FieldNode> fieldTypesChecked = new HashSet<FieldNode>();
    private final Set<String> resolutionFailedCache = new HashSet<String>();
    private boolean checkingVariableTypeInDeclaration;
    protected ImportNode currImportNode;
    private MethodNode currentMethod;
    private ClassNodeResolver classNodeResolver;

    public ResolveVisitor(CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
        this.setClassNodeResolver(new ClassNodeResolver(){

            @Override
            public ClassNodeResolver.LookupResult findClassNode(String name, CompilationUnit compilationUnit) {
                return compilationUnit == null ? null : super.findClassNode(name, compilationUnit);
            }
        });
    }

    public void setClassNodeResolver(ClassNodeResolver classNodeResolver) {
        this.classNodeResolver = classNodeResolver;
    }

    public void startResolving(ClassNode node, SourceUnit source) {
        this.source = source;
        this.visitClass(node);
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    protected void resetSourceUnit() {
        this.source = null;
    }

    protected void resetVariableScope() {
        this.currentScope = null;
    }

    @Override
    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        ClassNode[] exceptions;
        Parameter[] paras;
        VariableScope oldScope = this.currentScope;
        this.currentScope = node.getVariableScope();
        Map<GenericsType.GenericsTypeName, GenericsType> oldPNames = this.genericParameterNames;
        this.genericParameterNames = node.isStatic() && !Traits.isTrait(node.getDeclaringClass()) ? new HashMap() : new HashMap(this.genericParameterNames);
        this.resolveGenericsHeader(node.getGenericsTypes());
        Parameter[] parameterArray = paras = node.getParameters();
        int n = paras.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter p = parameterArray[n2];
            p.setInitialExpression(this.transform(p.getInitialExpression()));
            this.resolveOrFail(p.getType(), p.getType());
            this.visitAnnotations(p);
            ++n2;
        }
        ClassNode[] classNodeArray = exceptions = node.getExceptions();
        int n3 = exceptions.length;
        n = 0;
        while (n < n3) {
            ClassNode t = classNodeArray[n];
            this.resolveOrFail(t, node);
            ++n;
        }
        this.resolveOrFail(node.getReturnType(), node);
        MethodNode oldCurrentMethod = this.currentMethod;
        this.currentMethod = node;
        super.visitConstructorOrMethod(node, isConstructor);
        this.currentMethod = oldCurrentMethod;
        this.genericParameterNames = oldPNames;
        this.currentScope = oldScope;
    }

    @Override
    public void visitField(FieldNode node) {
        ClassNode t = node.getType();
        if (!this.fieldTypesChecked.contains(node)) {
            this.resolveOrFail(t, node);
        }
        super.visitField(node);
    }

    @Override
    public void visitProperty(PropertyNode node) {
        Map<GenericsType.GenericsTypeName, GenericsType> oldPNames = this.genericParameterNames;
        if (node.isStatic() && !Traits.isTrait(node.getDeclaringClass())) {
            this.genericParameterNames = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
        }
        ClassNode t = node.getType();
        this.resolveOrFail(t, node);
        super.visitProperty(node);
        this.fieldTypesChecked.add(node.getField());
        this.genericParameterNames = oldPNames;
    }

    private void resolveOrFail(ClassNode type, ASTNode node) {
        this.resolveOrFail(type, "", node);
    }

    private void resolveOrFail(ClassNode type, String msg, ASTNode node) {
        this.resolveOrFail(type, msg, node, false);
    }

    private void resolveOrFail(ClassNode type, String msg, ASTNode node, boolean preferImports) {
        if (preferImports) {
            this.resolveGenericsTypes(type.getGenericsTypes());
            if (this.resolveAliasFromModule(type)) {
                return;
            }
        }
        if (this.resolve(type)) {
            return;
        }
        if (this.resolveToInner(type)) {
            return;
        }
        this.addError("unable to resolve class " + type.toString(false) + msg, type.getEnd() > 0 ? type : node);
    }

    protected boolean resolveToInner(ClassNode type) {
        String name;
        if (type instanceof ConstructedClassWithPackage) {
            return false;
        }
        if (type instanceof ConstructedNestedClass) {
            return false;
        }
        ClassNode t = type;
        while (t.isArray()) {
            t = t.getComponentType();
        }
        String temp = name = t.getName();
        while (temp.lastIndexOf(46) != -1) {
            temp = ResolveVisitor.replaceLastPointWithDollar(temp);
            t.setName(temp);
            if (!this.resolve(t, true, false, false)) continue;
            return true;
        }
        t.setName(name);
        return false;
    }

    public ClassNode resolve(String name) {
        return null;
    }

    protected boolean resolve(ClassNode type) {
        return this.resolve(type, true, true, true);
    }

    protected boolean resolve(ClassNode type, boolean testModuleImports, boolean testDefaultImports, boolean testStaticInnerClasses) {
        this.resolveGenericsTypes(type.getGenericsTypes());
        if (type.isResolved() || type.isPrimaryClassNode()) {
            return true;
        }
        if (type.isArray()) {
            ClassNode element = type.getComponentType();
            boolean resolved = this.resolve(element, testModuleImports, testDefaultImports, testStaticInnerClasses);
            if (resolved) {
                ClassNode cn = element.makeArray();
                type.setRedirect(cn);
            }
            return resolved;
        }
        if (this.currentClass == type) {
            return true;
        }
        String typeName = type.getName();
        GenericsType genericsType = this.genericParameterNames.get(new GenericsType.GenericsTypeName(typeName));
        if (genericsType != null) {
            type.setRedirect(genericsType.getType());
            type.setGenericsTypes(new GenericsType[]{genericsType});
            type.setGenericsPlaceHolder(true);
            return true;
        }
        if (this.currentClass.getNameWithoutPackage().equals(typeName)) {
            type.setRedirect(this.currentClass);
            return true;
        }
        return !type.hasPackageName() && this.resolveNestedClass(type) || this.resolveFromModule(type, testModuleImports) || this.resolveFromCompileUnit(type) || testDefaultImports && !type.hasPackageName() && this.resolveFromDefaultImports(type, true) || this.resolveToOuter(type) || testStaticInnerClasses && type.hasPackageName() && this.resolveFromStaticInnerClasses(type, true);
    }

    protected boolean resolveNestedClass(ClassNode type) {
        if (type instanceof ConstructedNestedClass || type instanceof ConstructedClassWithPackage) {
            return false;
        }
        for (ClassNode classToCheck : ResolveVisitor.findHierClasses(this.currentClass).values()) {
            if (!this.setRedirect(type, classToCheck)) continue;
            return true;
        }
        ClassNode possibleOuterClassNode = this.possibleOuterClassNodeMap.get(type);
        if (possibleOuterClassNode != null && this.setRedirect(type, possibleOuterClassNode)) {
            return true;
        }
        List<ClassNode> outerClasses = this.currentClass.getOuterClasses();
        if (!outerClasses.isEmpty()) {
            ListIterator<ClassNode> it = outerClasses.listIterator(outerClasses.size());
            while (it.hasPrevious()) {
                ClassNode outerClass = it.previous();
                if (!this.setRedirect(type, outerClass)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean setRedirect(ClassNode type, ClassNode classToCheck) {
        String typeName = type.getName();
        Predicate<ClassNode> resolver = maybeOuter -> {
            ConstructedNestedClass maybeNested;
            if (!typeName.equals(maybeOuter.getName()) && !this.resolutionFailedCache.contains((maybeNested = new ConstructedNestedClass((ClassNode)maybeOuter, typeName)).getName())) {
                if (this.resolveFromCompileUnit(maybeNested) || this.resolveToOuter(maybeNested)) {
                    type.setRedirect(maybeNested);
                    return true;
                }
                this.resolutionFailedCache.add(maybeNested.getName());
            }
            return false;
        };
        if (resolver.test(classToCheck)) {
            if (this.currentClass != classToCheck && !this.currentClass.getOuterClasses().contains(classToCheck) && !ResolveVisitor.isVisibleNestedClass(type.redirect(), this.currentClass)) {
                type.setRedirect(null);
            } else {
                return true;
            }
        }
        for (ClassNode face : classToCheck.getAllInterfaces()) {
            if (!resolver.test(face)) continue;
            return true;
        }
        return false;
    }

    private static String replaceLastPointWithDollar(String name) {
        int lastPointIndex = name.lastIndexOf(46);
        return String.valueOf(name.substring(0, lastPointIndex)) + "$" + name.substring(lastPointIndex + 1);
    }

    protected boolean resolveFromStaticInnerClasses(ClassNode type, boolean unused) {
        if (!(type instanceof LowerCaseClass) && !(type instanceof ConstructedNestedClass)) {
            if (type instanceof ConstructedClassWithPackage) {
                ConstructedClassWithPackage tmp = (ConstructedClassWithPackage)type;
                String savedName = tmp.className;
                tmp.className = ResolveVisitor.replaceLastPointWithDollar(savedName);
                if (this.resolve(tmp, false, true, true)) {
                    type.setRedirect(tmp.redirect());
                    return true;
                }
                tmp.className = savedName;
            } else {
                String savedName = type.getName();
                String replacedPointType = ResolveVisitor.replaceLastPointWithDollar(savedName);
                type.setName(replacedPointType);
                if (this.resolve(type, false, true, true)) {
                    return true;
                }
                type.setName(savedName);
            }
        }
        return false;
    }

    protected boolean resolveFromDefaultImports(ClassNode type, boolean unused) {
        if (!(type instanceof LowerCaseClass)) {
            String typeName = type.getName();
            if (this.resolveFromDefaultImports(type, DEFAULT_IMPORTS)) {
                return true;
            }
            if (BIGINTEGER_STR.equals(typeName)) {
                type.setRedirect(ClassHelper.BigInteger_TYPE);
                return true;
            }
            if (BIGDECIMAL_STR.equals(typeName)) {
                type.setRedirect(ClassHelper.BigDecimal_TYPE);
                return true;
            }
        }
        return false;
    }

    protected boolean resolveFromDefaultImports(ClassNode type, String[] packagePrefixes) {
        String typeName = type.getName();
        String[] stringArray = packagePrefixes;
        int n = packagePrefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String packagePrefix = stringArray[n2];
            ConstructedClassWithPackage tmp = new ConstructedClassWithPackage(packagePrefix, typeName);
            if (!this.resolutionFailedCache.contains(tmp.getName())) {
                if (this.resolve(tmp, false, false, false)) {
                    type.setRedirect(tmp.redirect());
                    return true;
                }
                this.resolutionFailedCache.add(tmp.getName());
            }
            ++n2;
        }
        return false;
    }

    protected boolean resolveFromCompileUnit(ClassNode type) {
        CompileUnit compileUnit = this.currentClass.getCompileUnit();
        if (compileUnit == null) {
            return false;
        }
        ClassNode cuClass = compileUnit.getClass(type.getName());
        if (cuClass != null) {
            if (type != cuClass) {
                type.setRedirect(cuClass);
            }
            return true;
        }
        return false;
    }

    private void ambiguousClass(ClassNode type, ClassNode iType, String name) {
        if (type.getName().equals(iType.getName())) {
            this.addError("reference to " + name + " is ambiguous, both class " + type.getName() + " and " + iType.getName() + " match", type);
        } else {
            type.setRedirect(iType);
        }
    }

    private boolean resolveAliasFromModule(ClassNode type) {
        String name;
        if (type instanceof ConstructedClassWithPackage) {
            return false;
        }
        ModuleNode module = this.currentClass.getModule();
        if (module == null) {
            return false;
        }
        String pname = name = type.getName();
        int index = name.length();
        do {
            ConstructedNestedClass tmp;
            pname = name.substring(0, index);
            ClassNode aliasedNode = null;
            ImportNode importNode = module.getImport(pname);
            if (importNode != null && importNode != this.currImportNode) {
                aliasedNode = importNode.getType();
            }
            if (aliasedNode == null && (importNode = module.getStaticImports().get(pname)) != null && importNode != this.currImportNode && this.resolve(tmp = new ConstructedNestedClass(importNode.getType(), importNode.getFieldName()), false, false, true) && (tmp.getModifiers() & 8) != 0) {
                type.setRedirect(tmp.redirect());
                return true;
            }
            if (aliasedNode == null) continue;
            if (pname.length() == name.length()) {
                type.setRedirect(aliasedNode);
                return true;
            }
            String className = String.valueOf(aliasedNode.getNameWithoutPackage()) + "$" + name.substring(pname.length() + 1).replace('.', '$');
            ConstructedClassWithPackage tmp2 = new ConstructedClassWithPackage(String.valueOf(aliasedNode.getPackageName()) + ".", className);
            if (!this.resolve(tmp2, true, true, false)) continue;
            type.setRedirect(tmp2.redirect());
            return true;
        } while ((index = pname.lastIndexOf(46)) != -1);
        return false;
    }

    protected boolean resolveFromModule(ClassNode type, boolean testModuleImports) {
        if (type instanceof ConstructedNestedClass) {
            return false;
        }
        if (type instanceof LowerCaseClass) {
            return this.resolveAliasFromModule(type);
        }
        String name = type.getName();
        ModuleNode module = this.currentClass.getModule();
        if (module == null) {
            return false;
        }
        boolean newNameUsed = false;
        if (!type.hasPackageName() && module.hasPackageName() && !(type instanceof ConstructedClassWithPackage)) {
            type.setName(String.valueOf(module.getPackageName()) + name);
            newNameUsed = true;
        }
        List<ClassNode> moduleClasses = module.getClasses();
        for (ClassNode mClass : moduleClasses) {
            if (!mClass.getName().equals(type.getName())) continue;
            if (mClass != type) {
                type.setRedirect(mClass);
            }
            return true;
        }
        if (newNameUsed) {
            type.setName(name);
        }
        if (testModuleImports) {
            ClassNode tmp;
            ConstructedClassWithPackage tmp2;
            if (this.resolveAliasFromModule(type)) {
                return true;
            }
            if (module.hasPackageName() && !this.resolutionFailedCache.contains(((ClassNode)(tmp2 = new ConstructedClassWithPackage(module.getPackageName(), name))).getName())) {
                if (this.resolve(tmp2, false, false, false)) {
                    this.ambiguousClass(type, tmp2, name);
                    return true;
                }
                this.resolutionFailedCache.add(((ClassNode)tmp2).getName());
            }
            for (ImportNode importNode : module.getStaticImports().values()) {
                if (!importNode.getFieldName().equals(name) || this.resolutionFailedCache.contains((tmp = new ConstructedNestedClass(importNode.getType(), name)).getName())) continue;
                if (this.resolve(tmp, false, false, true) && (tmp.getModifiers() & 8) != 0) {
                    type.setRedirect(tmp.redirect());
                    return true;
                }
                this.resolutionFailedCache.add(tmp.getName());
            }
            for (ImportNode importNode : module.getStaticStarImports().values()) {
                tmp = new ConstructedNestedClass(importNode.getType(), name);
                if (this.resolutionFailedCache.contains(tmp.getName())) continue;
                if (this.resolve(tmp, false, false, true) && (tmp.getModifiers() & 8) != 0) {
                    this.ambiguousClass(type, tmp, name);
                    return true;
                }
                this.resolutionFailedCache.add(tmp.getName());
            }
            for (ImportNode importNode : module.getStarImports()) {
                if (importNode.getType() != null) {
                    tmp = new ConstructedNestedClass(importNode.getType(), name);
                    if (this.resolutionFailedCache.contains(tmp.getName())) continue;
                    if (this.resolve(tmp, false, false, true) && (tmp.getModifiers() & 8) != 0) {
                        this.ambiguousClass(type, tmp, name);
                        return true;
                    }
                    this.resolutionFailedCache.add(tmp.getName());
                    continue;
                }
                tmp = new ConstructedClassWithPackage(importNode.getPackageName(), name);
                if (this.resolutionFailedCache.contains(tmp.getName())) continue;
                if (this.resolve(tmp, false, false, true)) {
                    this.ambiguousClass(type, tmp, name);
                    return true;
                }
                this.resolutionFailedCache.add(tmp.getName());
            }
        }
        return false;
    }

    protected boolean resolveToOuter(ClassNode type) {
        String name = type.getName();
        if (type instanceof LowerCaseClass) {
            this.classNodeResolver.cacheClass(name, ClassNodeResolver.NO_CLASS);
            return false;
        }
        if (this.currentClass.getModule().hasPackageName() && name.indexOf(46) == -1) {
            return false;
        }
        ClassNodeResolver.LookupResult lr = this.classNodeResolver.resolveName(name, this.compilationUnit);
        if (lr != null) {
            if (lr.isSourceUnit()) {
                SourceUnit su = lr.getSourceUnit();
                this.currentClass.getCompileUnit().addClassNodeToCompile(type, su);
            } else {
                type.setRedirect(lr.getClassNode());
            }
            return true;
        }
        return false;
    }

    @Override
    public Expression transform(Expression exp) {
        Expression ret;
        if (exp == null) {
            return null;
        }
        if (exp instanceof VariableExpression) {
            ret = this.transformVariableExpression((VariableExpression)exp);
        } else if (exp.getClass() == PropertyExpression.class) {
            ret = this.transformPropertyExpression((PropertyExpression)exp);
        } else if (exp instanceof DeclarationExpression) {
            ret = this.transformDeclarationExpression((DeclarationExpression)exp);
        } else if (exp instanceof BinaryExpression) {
            ret = this.transformBinaryExpression((BinaryExpression)exp);
        } else if (exp instanceof MethodCallExpression) {
            ret = this.transformMethodCallExpression((MethodCallExpression)exp);
        } else if (exp instanceof ClosureExpression) {
            ret = this.transformClosureExpression((ClosureExpression)exp);
        } else if (exp instanceof ConstructorCallExpression) {
            ret = this.transformConstructorCallExpression((ConstructorCallExpression)exp);
        } else if (exp instanceof AnnotationConstantExpression) {
            ret = this.transformAnnotationConstantExpression((AnnotationConstantExpression)exp);
        } else {
            this.resolveOrFail(exp.getType(), exp);
            ret = exp.transformExpression(this);
        }
        if (ret != null && ret != exp) {
            ret.setSourcePosition(exp);
        }
        return ret;
    }

    private static String lookupClassName(PropertyExpression pe) {
        boolean doInitialClassTest = true;
        StringBuilder name = new StringBuilder(32);
        Expression expr = pe;
        while (expr != null) {
            if (expr instanceof VariableExpression) {
                VariableExpression ve = (VariableExpression)expr;
                if (ve.isSuperExpression() || ve.isThisExpression()) {
                    return null;
                }
                String varName = ve.getName();
                Tuple2<StringBuilder, Boolean> classNameInfo = ResolveVisitor.makeClassName(doInitialClassTest, name, varName);
                name = classNameInfo.getV1();
                doInitialClassTest = classNameInfo.getV2();
                break;
            }
            if (expr.getClass() != PropertyExpression.class) {
                return null;
            }
            String property = expr.getPropertyAsString();
            if (property == null || property.equals("class")) {
                return null;
            }
            Tuple2<StringBuilder, Boolean> classNameInfo = ResolveVisitor.makeClassName(doInitialClassTest, name, property);
            name = classNameInfo.getV1();
            doInitialClassTest = classNameInfo.getV2();
            expr = expr.getObjectExpression();
        }
        if (name == null || name.length() == 0) {
            return null;
        }
        return name.toString();
    }

    private static Tuple2<StringBuilder, Boolean> makeClassName(boolean doInitialClassTest, StringBuilder name, String varName) {
        if (doInitialClassTest) {
            if (!ResolveVisitor.testVanillaNameForClass(varName)) {
                return Tuple.tuple(null, Boolean.TRUE);
            }
            return Tuple.tuple(new StringBuilder(varName), Boolean.FALSE);
        }
        name.insert(0, String.valueOf(varName) + ".");
        return Tuple.tuple(name, Boolean.FALSE);
    }

    private static Expression correctClassClassChain(PropertyExpression pe) {
        LinkedList<PropertyExpression> stack = new LinkedList<PropertyExpression>();
        ClassExpression found = null;
        Expression it = pe;
        while (it != null) {
            if (it instanceof ClassExpression) {
                found = (ClassExpression)it;
                break;
            }
            if (it.getClass() != PropertyExpression.class) {
                return pe;
            }
            stack.addFirst((PropertyExpression)it);
            it = it.getObjectExpression();
        }
        if (found == null) {
            return pe;
        }
        if (stack.isEmpty()) {
            return pe;
        }
        Object stackElement = stack.removeFirst();
        if (stackElement.getClass() != PropertyExpression.class) {
            return pe;
        }
        PropertyExpression classPropertyExpression = (PropertyExpression)stackElement;
        String propertyNamePart = classPropertyExpression.getPropertyAsString();
        if (propertyNamePart == null || !propertyNamePart.equals("class")) {
            return pe;
        }
        found.setSourcePosition(classPropertyExpression);
        if (stack.isEmpty()) {
            return found;
        }
        stackElement = stack.removeFirst();
        if (stackElement.getClass() != PropertyExpression.class) {
            return pe;
        }
        PropertyExpression classPropertyExpressionContainer = (PropertyExpression)stackElement;
        classPropertyExpressionContainer.setObjectExpression(found);
        return pe;
    }

    protected Expression transformPropertyExpression(PropertyExpression pe) {
        ClassNode type;
        boolean itlp = this.isTopLevelProperty;
        boolean ipe = this.inPropertyExpression;
        Expression objectExpression = pe.getObjectExpression();
        this.inPropertyExpression = true;
        this.isTopLevelProperty = objectExpression.getClass() != PropertyExpression.class;
        objectExpression = this.transform(objectExpression);
        this.inPropertyExpression = false;
        Expression property = this.transform(pe.getProperty());
        this.isTopLevelProperty = itlp;
        this.inPropertyExpression = ipe;
        boolean spreadSafe = pe.isSpreadSafe();
        PropertyExpression old = pe;
        pe = new PropertyExpression(objectExpression, property, pe.isSafe());
        pe.setSpreadSafe(spreadSafe);
        pe.setSourcePosition(old);
        String className = ResolveVisitor.lookupClassName(pe);
        if (className != null && this.resolve(type = ClassHelper.make(className))) {
            if (type instanceof ImmutableClassNode && !ClassHelper.isPrimitiveType(type)) {
                ClassNode wrapper = ClassHelper.makeWithoutCaching(className);
                wrapper.setRedirect(type);
                type = wrapper;
            }
            type.setStart(pe.getStart());
            type.setEnd(pe.getEnd());
            type.setNameStart2(property.getStart());
            return new ClassExpression(type);
        }
        if (objectExpression instanceof ClassExpression && pe.getPropertyAsString() != null) {
            ClassExpression ce = (ClassExpression)objectExpression;
            ClassNode classNode = ce.getType();
            while (classNode != null) {
                ConstructedNestedClass type2 = new ConstructedNestedClass(classNode, pe.getPropertyAsString());
                if (this.resolve(type2, false, false, false) && (classNode == ce.getType() || ResolveVisitor.isVisibleNestedClass(type2, ce.getType()))) {
                    type2.setNameStart2(property.getStart());
                    return new ClassExpression(type2);
                }
                classNode = classNode.getSuperClass();
            }
        }
        Expression ret = pe;
        this.checkThisAndSuperAsPropertyAccess(pe);
        if (this.isTopLevelProperty) {
            ret = ResolveVisitor.correctClassClassChain(pe);
        }
        return ret;
    }

    private static boolean isVisibleNestedClass(ClassNode innerType, ClassNode outerType) {
        int modifiers = innerType.getModifiers();
        return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers) || !Modifier.isPrivate(modifiers) && Objects.equals(innerType.getPackageName(), outerType.getPackageName());
    }

    private boolean directlyImplementsTrait(ClassNode trait) {
        ClassNode[] interfaces = this.currentClass.getInterfaces();
        if (interfaces == null) {
            return this.currentClass.getSuperClass().equals(trait);
        }
        ClassNode[] classNodeArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode node = classNodeArray[n2];
            if (node.equals(trait)) {
                return true;
            }
            ++n2;
        }
        return this.currentClass.getSuperClass().equals(trait);
    }

    private void checkThisAndSuperAsPropertyAccess(PropertyExpression expression) {
        if (expression.isImplicitThis()) {
            return;
        }
        String prop = expression.getPropertyAsString();
        if (prop == null) {
            return;
        }
        if (!prop.equals("this") && !prop.equals("super")) {
            return;
        }
        ClassNode type = expression.getObjectExpression().getType();
        if (expression.getObjectExpression() instanceof ClassExpression) {
            if (!(this.currentClass instanceof InnerClassNode) && !Traits.isTrait(type)) {
                this.addError("The usage of 'Class.this' and 'Class.super' is only allowed in nested/inner classes.", expression);
                return;
            }
            if (this.currentScope != null && !this.currentScope.isInStaticContext() && Traits.isTrait(type) && "super".equals(prop) && this.directlyImplementsTrait(type)) {
                return;
            }
            ClassNode iterType = this.currentClass;
            while (iterType != null) {
                if (iterType.equals(type)) break;
                iterType = iterType.getOuterClass();
            }
            if (iterType == null) {
                this.addError("The class '" + type.getName() + "' needs to be an outer class of '" + this.currentClass.getName() + "' when using '.this' or '.super'.", expression);
            }
            if ((this.currentClass.getModifiers() & 8) == 0) {
                return;
            }
            if (this.currentScope != null && !this.currentScope.isInStaticContext()) {
                return;
            }
            this.addError("The usage of 'Class.this' and 'Class.super' within static nested class '" + this.currentClass.getName() + "' is not allowed in a static context.", expression);
        }
    }

    protected Expression transformVariableExpression(VariableExpression ve) {
        this.visitAnnotations(ve);
        Variable v = ve.getAccessedVariable();
        if (!(v instanceof DynamicVariable) && !this.checkingVariableTypeInDeclaration) {
            return ve;
        }
        if (v instanceof DynamicVariable) {
            String name = ve.getName();
            ClassNode t = ClassHelper.make(name);
            boolean isClass = t.isResolved();
            if (!isClass) {
                if (Character.isLowerCase(name.charAt(0))) {
                    t = new LowerCaseClass(name);
                }
                isClass = this.resolve(t);
            }
            if (isClass) {
                VariableScope scope = this.currentScope;
                while (scope != null && !scope.isRoot()) {
                    if (scope.removeReferencedClassVariable(ve.getName()) == null) break;
                    scope = scope.getParent();
                }
                return new ClassExpression(t);
            }
        }
        this.resolveOrFail(ve.getType(), ve);
        ClassNode origin = ve.getOriginType();
        if (origin != ve.getType()) {
            this.resolveOrFail(origin, ve);
        }
        return ve;
    }

    private static boolean testVanillaNameForClass(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        return !Character.isLowerCase(name.charAt(0));
    }

    protected Expression transformBinaryExpression(BinaryExpression be) {
        Expression left = this.transform(be.getLeftExpression());
        if (be.getOperation().isA(1100) && left instanceof ClassExpression) {
            ClassExpression ce = (ClassExpression)left;
            String error = "you tried to assign a value to the class '" + ce.getType().getName() + "'";
            if (ce.getType().isScript()) {
                error = String.valueOf(error) + ". Do you have a script with this name?";
            }
            this.addError(error, be.getLeftExpression());
            return be;
        }
        if (left instanceof ClassExpression && be.getOperation().isOneOf(new int[]{1905, 810, 811})) {
            if (be.getRightExpression() instanceof ListExpression) {
                ListExpression list = (ListExpression)be.getRightExpression();
                if (list.getExpressions().isEmpty()) {
                    return new ClassExpression(left.getType().makeArray());
                }
                boolean map = true;
                for (Expression expression : list.getExpressions()) {
                    if (expression instanceof MapEntryExpression) continue;
                    map = false;
                    break;
                }
                if (map) {
                    MapExpression me = new MapExpression();
                    for (Expression expression : list.getExpressions()) {
                        me.addMapEntryExpression((MapEntryExpression)this.transform(expression));
                    }
                    me.setSourcePosition(list);
                    CastExpression ce = new CastExpression(left.getType(), me);
                    ce.setCoerce(true);
                    return ce;
                }
            } else if (be.getRightExpression() instanceof SpreadMapExpression) {
                SpreadMapExpression mapExpression = (SpreadMapExpression)be.getRightExpression();
                Expression right = this.transform(mapExpression.getExpression());
                CastExpression ce = new CastExpression(left.getType(), right);
                ce.setCoerce(true);
                return ce;
            }
            if (be.getRightExpression() instanceof MapEntryExpression) {
                MapExpression me = new MapExpression();
                me.addMapEntryExpression((MapEntryExpression)this.transform(be.getRightExpression()));
                me.setSourcePosition(be.getRightExpression());
                return new CastExpression(left.getType(), me);
            }
        }
        Expression right = this.transform(be.getRightExpression());
        be.setLeftExpression(left);
        be.setRightExpression(right);
        return be;
    }

    protected Expression transformClosureExpression(ClosureExpression ce) {
        boolean oldInClosure = this.inClosure;
        this.inClosure = true;
        Parameter[] parameterArray = ClosureUtils.getParametersSafe(ce);
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter para = parameterArray[n2];
            ClassNode t = para.getType();
            this.resolveOrFail(t, ce);
            this.visitAnnotations(para);
            if (para.hasInitialExpression()) {
                para.setInitialExpression(this.transform(para.getInitialExpression()));
            }
            this.visitAnnotations(para);
            ++n2;
        }
        Statement code = ce.getCode();
        if (code != null) {
            code.visit(this);
        }
        this.inClosure = oldInClosure;
        return ce;
    }

    protected Expression transformConstructorCallExpression(ConstructorCallExpression cce) {
        this.findPossibleOuterClassNodeForNonStaticInnerClassInstantiation(cce);
        ClassNode type = cce.getType();
        if (cce.isUsingAnonymousInnerClass()) {
            this.resolveOrFail(type.getUnresolvedSuperClass(false), type);
        } else {
            this.resolveOrFail(type, cce);
            if (type.isAbstract()) {
                this.addError("You cannot create an instance from the abstract " + ResolveVisitor.getDescription(type) + ".", cce);
            }
        }
        return cce.transformExpression(this);
    }

    private void findPossibleOuterClassNodeForNonStaticInnerClassInstantiation(ConstructorCallExpression cce) {
        Expression firstExpression;
        ArgumentListExpression argumentListExpression;
        List<Expression> expressionList;
        Expression argumentExpression = cce.getArguments();
        if (argumentExpression instanceof ArgumentListExpression && !(expressionList = (argumentListExpression = (ArgumentListExpression)argumentExpression).getExpressions()).isEmpty() && (firstExpression = expressionList.get(0)) instanceof ConstructorCallExpression) {
            ConstructorCallExpression constructorCallExpression = (ConstructorCallExpression)firstExpression;
            ClassNode possibleOuterClassNode = constructorCallExpression.getType();
            this.possibleOuterClassNodeMap.put(cce.getType(), possibleOuterClassNode);
        }
    }

    private static String getDescription(ClassNode node) {
        return String.valueOf(node.isInterface() ? "interface" : "class") + " '" + node.getName() + "'";
    }

    protected Expression transformMethodCallExpression(MethodCallExpression mce) {
        Expression args = this.transform(mce.getArguments());
        Expression method = this.transform(mce.getMethod());
        Expression object = this.transform(mce.getObjectExpression());
        this.resolveGenericsTypes(mce.getGenericsTypes());
        MethodCallExpression ret = new MethodCallExpression(object, method, args);
        ret.setGenericsTypes(mce.getGenericsTypes());
        ret.setMethodTarget(mce.getMethodTarget());
        ret.setImplicitThis(mce.isImplicitThis());
        ret.setSpreadSafe(mce.isSpreadSafe());
        ret.setSafe(mce.isSafe());
        return ret;
    }

    protected Expression transformDeclarationExpression(DeclarationExpression de) {
        this.visitAnnotations(de);
        Expression oldLeft = de.getLeftExpression();
        this.checkingVariableTypeInDeclaration = true;
        Expression left = this.transform(oldLeft);
        this.checkingVariableTypeInDeclaration = false;
        if (left instanceof ClassExpression) {
            ClassExpression ce = (ClassExpression)left;
            this.addError("you tried to assign a value to the class " + ce.getType().getName(), oldLeft);
            return de;
        }
        Expression right = this.transform(de.getRightExpression());
        if (right == de.getRightExpression()) {
            this.fixDeclaringClass(de);
            return de;
        }
        DeclarationExpression newDeclExpr = new DeclarationExpression(left, de.getOperation(), right);
        newDeclExpr.setDeclaringClass(de.getDeclaringClass());
        newDeclExpr.addAnnotations(de.getAnnotations());
        newDeclExpr.copyNodeMetaData(de);
        this.fixDeclaringClass(newDeclExpr);
        return newDeclExpr;
    }

    private void fixDeclaringClass(DeclarationExpression newDeclExpr) {
        if (newDeclExpr.getDeclaringClass() == null && this.currentMethod != null) {
            newDeclExpr.setDeclaringClass(this.currentMethod.getDeclaringClass());
        }
    }

    protected Expression transformAnnotationConstantExpression(AnnotationConstantExpression ace) {
        AnnotationNode an = (AnnotationNode)ace.getValue();
        ClassNode type = an.getClassNode();
        this.resolveOrFail(type, " for annotation", an);
        for (Map.Entry<String, Expression> member : an.getMembers().entrySet()) {
            member.setValue(this.transform(member.getValue()));
        }
        return ace;
    }

    @Override
    protected void visitAnnotation(AnnotationNode node) {
        this.resolveOrFail(node.getClassNode(), " for annotation", node);
        for (Map.Entry<String, Expression> member : node.getMembers().entrySet()) {
            Expression value = ResolveVisitor.transformInlineConstants(this.transform(member.getValue()));
            member.setValue(value);
            this.checkAnnotationMemberValue(value);
        }
    }

    private static Expression transformInlineConstants(Expression exp) {
        if (exp instanceof AnnotationConstantExpression) {
            ConstantExpression ce = (ConstantExpression)exp;
            if (ce.getValue() instanceof AnnotationNode) {
                AnnotationNode an = (AnnotationNode)ce.getValue();
                for (Map.Entry<String, Expression> member : an.getMembers().entrySet()) {
                    member.setValue(ResolveVisitor.transformInlineConstants(member.getValue()));
                }
            }
        } else {
            return ExpressionUtils.transformInlineConstants(exp);
        }
        return exp;
    }

    private void checkAnnotationMemberValue(Expression newValue) {
        if (newValue instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)newValue;
            if (!(pe.getObjectExpression() instanceof ClassExpression)) {
                this.addError("unable to find class '" + pe.getText() + "' for annotation attribute constant", pe.getObjectExpression());
            }
        } else if (newValue instanceof ListExpression) {
            ListExpression le = (ListExpression)newValue;
            for (Expression e : le.getExpressions()) {
                this.checkAnnotationMemberValue(e);
            }
        }
    }

    @Override
    public void visitClass(ClassNode node) {
        ClassNode oldNode = this.currentClass;
        this.currentClass = node;
        if (this.commencingResolution()) {
            try {
                ClassNode sn;
                if (node instanceof InnerClassNode) {
                    MethodNode enclosingMethod;
                    InnerClassNode innerClassNode;
                    if (Modifier.isStatic(node.getModifiers())) {
                        this.genericParameterNames = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
                    }
                    if ((innerClassNode = (InnerClassNode)node).isAnonymous() && (enclosingMethod = innerClassNode.getEnclosingMethod()) != null) {
                        this.resolveGenericsHeader(enclosingMethod.getGenericsTypes());
                    }
                } else {
                    this.genericParameterNames = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
                }
                this.resolveGenericsHeader(node.getGenericsTypes());
                ModuleNode module = node.getModule();
                if (!module.hasImportsResolved()) {
                    ClassNode type;
                    Iterator<ImportNode> iterator = module.getImports().iterator();
                    while (iterator.hasNext()) {
                        ImportNode importNode;
                        this.currImportNode = importNode = iterator.next();
                        type = importNode.getType();
                        if (this.resolve(type, false, false, true)) {
                            this.currImportNode = null;
                            continue;
                        }
                        this.currImportNode = null;
                        this.addError("unable to resolve class " + type.getName(), type);
                    }
                    for (ImportNode importNode : module.getStarImports()) {
                        if (importNode.getLineNumber() <= 0) continue;
                        this.currImportNode = importNode;
                        String importName = importNode.getPackageName();
                        ClassNode type2 = ClassHelper.makeWithoutCaching(importName = importName.substring(0, importName.length() - 1));
                        if (this.resolve(type2, false, false, true)) {
                            importNode.setType(type2);
                            type2.setStart(importNode.getStart() + 7);
                            type2.setEnd(type2.getStart() + importName.length());
                        }
                        this.currImportNode = null;
                    }
                    for (ImportNode importNode : module.getStaticImports().values()) {
                        type = importNode.getType();
                        if (!this.resolve(type, false, false, true)) {
                            this.addError("unable to resolve class " + type.getName(), type);
                            continue;
                        }
                        if (!this.resolve(type = ClassHelper.makeWithoutCaching(String.valueOf(type.getName()) + "$" + importNode.getFieldName()), false, false, true)) continue;
                        Expression nameExpr = importNode.getFieldNameExpr();
                        importNode.setFieldNameExpr(new ClassExpression(type));
                        importNode.getFieldNameExpr().setSourcePosition(nameExpr);
                    }
                    for (ImportNode importNode : module.getStaticStarImports().values()) {
                        type = importNode.getType();
                        if (this.resolve(type, false, false, true)) continue;
                        this.addError("unable to resolve class " + type.getName(), type);
                    }
                    module.setImportsResolved(true);
                }
                if ((sn = node.getUnresolvedSuperClass()) != null) {
                    this.resolveOrFail(sn, "", node, true);
                }
                ClassNode[] classNodeArray = node.getInterfaces();
                int n = classNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode anInterface = classNodeArray[n2];
                    this.resolveOrFail(anInterface, "", node, true);
                    ++n2;
                }
                this.checkCyclicInheritance(node, node.getUnresolvedSuperClass(), node.getInterfaces());
                super.visitClass(node);
                this.finishedResolution();
            }
            finally {
                if (this.currentClass == node) {
                    this.currentClass = oldNode;
                }
            }
        }
    }

    protected boolean commencingResolution() {
        return true;
    }

    protected void finishedResolution() {
    }

    private void checkCyclicInheritance(ClassNode originalNode, ClassNode parentToCompare, ClassNode[] interfacesToCompare) {
        if (!originalNode.isInterface()) {
            if (parentToCompare == null) {
                return;
            }
            if (originalNode == parentToCompare.redirect()) {
                this.addError("Cyclic inheritance involving " + parentToCompare.getName() + " in class " + originalNode.getName(), originalNode);
                originalNode.redirect().setHasInconsistentHierarchy(true);
                return;
            }
            if (interfacesToCompare != null && interfacesToCompare.length > 0) {
                ClassNode[] classNodeArray = interfacesToCompare;
                int n = interfacesToCompare.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode intfToCompare = classNodeArray[n2];
                    if (originalNode == intfToCompare.redirect()) {
                        this.addError("Cycle detected: the type " + originalNode.getName() + " cannot implement itself", originalNode);
                        originalNode.redirect().setHasInconsistentHierarchy(true);
                        return;
                    }
                    ++n2;
                }
            }
            if (parentToCompare == ClassHelper.OBJECT_TYPE) {
                return;
            }
            this.checkCyclicInheritance(originalNode, parentToCompare.getUnresolvedSuperClass(), null);
        } else if (interfacesToCompare != null && interfacesToCompare.length > 0) {
            ClassNode[] classNodeArray = interfacesToCompare;
            int n = interfacesToCompare.length;
            int n3 = 0;
            while (n3 < n) {
                ClassNode intfToCompare = classNodeArray[n3];
                if (originalNode == intfToCompare.redirect()) {
                    this.addError("Cyclic inheritance involving " + intfToCompare.getName() + " in interface " + originalNode.getName(), originalNode);
                    originalNode.redirect().setHasInconsistentHierarchy(true);
                    return;
                }
                ++n3;
            }
            classNodeArray = interfacesToCompare;
            n = interfacesToCompare.length;
            n3 = 0;
            while (n3 < n) {
                ClassNode intf = classNodeArray[n3];
                this.checkCyclicInheritance(originalNode, null, intf.getInterfaces());
                ++n3;
            }
        }
    }

    @Override
    public void visitCatchStatement(CatchStatement cs) {
        this.resolveOrFail(cs.getExceptionType(), cs);
        if (cs.getExceptionType() == ClassHelper.DYNAMIC_TYPE) {
            cs.getVariable().setType(ClassHelper.make(Exception.class));
        }
        super.visitCatchStatement(cs);
    }

    @Override
    public void visitForLoop(ForStatement forLoop) {
        this.resolveOrFail(forLoop.getVariableType(), forLoop);
        super.visitForLoop(forLoop);
    }

    @Override
    public void visitBlockStatement(BlockStatement block) {
        VariableScope oldScope = this.currentScope;
        this.currentScope = block.getVariableScope();
        super.visitBlockStatement(block);
        this.currentScope = oldScope;
    }

    private boolean resolveGenericsTypes(GenericsType[] types) {
        if (types == null) {
            return true;
        }
        this.currentClass.setUsingGenerics(true);
        boolean resolved = true;
        GenericsType[] genericsTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            GenericsType type = genericsTypeArray[n2];
            resolved = this.resolveGenericsType(type) && resolved;
            ++n2;
        }
        return resolved;
    }

    private void resolveGenericsHeader(GenericsType[] types) {
        this.resolveGenericsHeader(types, null, 0);
    }

    private void resolveGenericsHeader(GenericsType[] types, GenericsType rootType, int level) {
        if (types == null) {
            return;
        }
        this.currentClass.setUsingGenerics(true);
        LinkedList<Tuple2<ClassNode, GenericsType>> upperBoundsWithGenerics = new LinkedList<Tuple2<ClassNode, GenericsType>>();
        LinkedList<Tuple2<ClassNode, ClassNode>> upperBoundsToResolve = new LinkedList<Tuple2<ClassNode, ClassNode>>();
        GenericsType[] genericsTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            GenericsType genericsType = genericsTypeArray[n2];
            if (level <= 0 || !genericsType.getName().equals(rootType.getName())) {
                boolean toDealWithGenerics;
                ClassNode classNode = genericsType.getType();
                String name = genericsType.getName();
                GenericsType.GenericsTypeName gtn = new GenericsType.GenericsTypeName(name);
                ClassNode[] bounds = genericsType.getUpperBounds();
                boolean isWild = QUESTION_MARK.equals(name);
                boolean bl = toDealWithGenerics = level == 0 || level > 0 && this.genericParameterNames.get(gtn) != null;
                if (bounds != null) {
                    boolean nameAdded = false;
                    ClassNode[] classNodeArray = bounds;
                    int n3 = bounds.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ClassNode upperBound = classNodeArray[n4];
                        if (!isWild) {
                            if ((!nameAdded && upperBound != null || !this.resolve(classNode)) && toDealWithGenerics) {
                                this.genericParameterNames.put(gtn, genericsType);
                                genericsType.setPlaceholder(true);
                                classNode.setRedirect(upperBound);
                                nameAdded = true;
                            }
                            upperBoundsToResolve.add(Tuple.tuple(upperBound, classNode));
                        }
                        if (upperBound != null && upperBound.isUsingGenerics()) {
                            upperBoundsWithGenerics.add(Tuple.tuple(upperBound, genericsType));
                        }
                        ++n4;
                    }
                } else if (!isWild && toDealWithGenerics) {
                    GenericsType originalGt = this.genericParameterNames.get(gtn);
                    this.genericParameterNames.put(gtn, genericsType);
                    genericsType.setPlaceholder(true);
                    if (originalGt == null) {
                        classNode.setRedirect(ClassHelper.OBJECT_TYPE);
                    } else {
                        classNode.setRedirect(originalGt.getType());
                    }
                }
            }
            ++n2;
        }
        for (Tuple2 tuple2 : upperBoundsToResolve) {
            ClassNode upperBound = (ClassNode)tuple2.getV1();
            ClassNode classNode = (ClassNode)tuple2.getV2();
            this.resolveOrFail(upperBound, classNode);
        }
        for (Tuple2 tuple2 : upperBoundsWithGenerics) {
            ClassNode upperBound = (ClassNode)tuple2.getV1();
            GenericsType gt = (GenericsType)tuple2.getV2();
            this.resolveGenericsHeader(upperBound.getGenericsTypes(), level == 0 ? gt : rootType, level + 1);
        }
    }

    private boolean resolveGenericsType(GenericsType genericsType) {
        if (genericsType.isResolved()) {
            return true;
        }
        this.currentClass.setUsingGenerics(true);
        ClassNode type = genericsType.getType();
        GenericsType.GenericsTypeName name = new GenericsType.GenericsTypeName(type.getName());
        ClassNode[] bounds = genericsType.getUpperBounds();
        if (!this.genericParameterNames.containsKey(name)) {
            if (bounds != null) {
                ClassNode[] classNodeArray = bounds;
                int n = bounds.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode upperBound = classNodeArray[n2];
                    this.resolveOrFail(upperBound, genericsType);
                    type.setRedirect(upperBound);
                    this.resolveGenericsTypes(upperBound.getGenericsTypes());
                    ++n2;
                }
            } else if (genericsType.isWildcard()) {
                type.setRedirect(ClassHelper.OBJECT_TYPE);
            } else {
                this.resolveOrFail(type, genericsType);
            }
        } else {
            GenericsType gt = this.genericParameterNames.get(name);
            type.setRedirect(gt.getType());
            genericsType.setPlaceholder(true);
        }
        if (genericsType.getLowerBound() != null) {
            this.resolveOrFail(genericsType.getLowerBound(), genericsType);
        }
        if (this.resolveGenericsTypes(type.getGenericsTypes())) {
            genericsType.setResolved(genericsType.getType().isResolved());
        }
        return genericsType.isResolved();
    }

    private static Map<String, ClassNode> findHierClasses(ClassNode currentClass) {
        LinkedHashMap<String, ClassNode> hierClasses = new LinkedHashMap<String, ClassNode>();
        ClassNode classToCheck = currentClass;
        while (classToCheck != ClassHelper.OBJECT_TYPE) {
            if (classToCheck == null || hierClasses.containsKey(classToCheck.getName())) break;
            hierClasses.put(classToCheck.getName(), classToCheck);
            classToCheck = classToCheck.getSuperClass();
        }
        return hierClasses;
    }

    private static class ConstructedClassWithPackage
    extends ClassNode {
        final String prefix;
        String className;

        public ConstructedClassWithPackage(String pkg, String name) {
            super(String.valueOf(pkg) + name, 1, ClassHelper.OBJECT_TYPE);
            this.isPrimaryNode = false;
            this.prefix = pkg;
            this.className = name;
        }

        @Override
        public String getName() {
            if (this.redirect() != this) {
                return super.getName();
            }
            return String.valueOf(this.prefix) + this.className;
        }

        @Override
        public boolean hasPackageName() {
            if (this.redirect() != this) {
                return super.hasPackageName();
            }
            return this.className.indexOf(46) != -1;
        }

        @Override
        public String setName(String name) {
            if (this.redirect() != this) {
                return super.setName(name);
            }
            throw new GroovyBugError("ConstructedClassWithPackage#setName should not be called");
        }
    }

    private static class ConstructedNestedClass
    extends ClassNode {
        final ClassNode knownEnclosingType;

        public ConstructedNestedClass(ClassNode outer, String inner) {
            super(String.valueOf(outer.getName()) + "$" + inner.replace('.', '$'), 1, ClassHelper.OBJECT_TYPE);
            this.knownEnclosingType = outer;
            this.isPrimaryNode = false;
        }

        @Override
        public String getUnresolvedName() {
            return super.getUnresolvedName().replace(this.knownEnclosingType.getName(), this.knownEnclosingType.getUnresolvedName());
        }

        @Override
        public boolean hasPackageName() {
            if (this.redirect() != this) {
                return super.hasPackageName();
            }
            return this.knownEnclosingType.hasPackageName();
        }

        @Override
        public String setName(String name) {
            if (this.redirect() != this) {
                return super.setName(name);
            }
            throw new GroovyBugError("ConstructedNestedClass#setName should not be called");
        }
    }

    private static class LowerCaseClass
    extends ClassNode {
        final String className;

        public LowerCaseClass(String name) {
            super(name, 1, ClassHelper.OBJECT_TYPE);
            this.isPrimaryNode = false;
            this.className = name;
        }

        @Override
        public String getName() {
            if (this.redirect() != this) {
                return super.getName();
            }
            return this.className;
        }

        @Override
        public boolean hasPackageName() {
            if (this.redirect() != this) {
                return super.hasPackageName();
            }
            return false;
        }

        @Override
        public String setName(String name) {
            if (this.redirect() != this) {
                return super.setName(name);
            }
            throw new GroovyBugError("LowerCaseClass#setName should not be called");
        }
    }
}

