/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.core.util;

import groovyjarjarantlr.Token;
import groovyjarjarantlr.TokenStream;
import groovyjarjarantlr.TokenStreamException;
import java.io.Reader;
import java.io.StringReader;
import org.codehaus.groovy.antlr.parser.GroovyLexer;
import org.codehaus.groovy.antlr.parser.GroovyRecognizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class GroovyScanner {
    private GroovyLexer lexer;
    private TokenStream stream;
    private boolean whitespaceIncluded;

    public GroovyScanner(String text) {
        this(new StringReader(text), false);
    }

    public GroovyScanner(Reader input) {
        this(input, false);
    }

    public GroovyScanner(Reader input, boolean whitespaceIncluded) {
        this.init(input, whitespaceIncluded);
    }

    private void init(Reader input, boolean whitespaceIncluded) {
        this.whitespaceIncluded = whitespaceIncluded;
        this.lexer = new GroovyLexer(input);
        this.lexer.setWhitespaceIncluded(whitespaceIncluded);
        this.stream = this.lexer.plumb();
        GroovyRecognizer.make(this.lexer);
    }

    public Token nextToken() throws TokenStreamException {
        return this.stream.nextToken();
    }

    public void recover(IDocument document) throws BadLocationException {
        int line = this.lexer.getInputState().getLine();
        int col = this.lexer.getInputState().getColumn();
        int offset = GroovyScanner.getOffset(document, line, col) + 1;
        line = document.getLineOfOffset(offset);
        int lineStart = document.getLineOffset(line);
        col = offset - lineStart + 1;
        String remainingInput = document.get(offset, document.getLength() - offset);
        this.init(new StringReader(remainingInput), this.whitespaceIncluded);
        this.lexer.setLine(++line);
        this.lexer.setColumn(col);
    }

    public static int getOffset(IDocument document, int line, int column) throws BadLocationException {
        return document.getLineOffset(line - 1) + column - 1;
    }
}

