/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.Comment;
import org.codehaus.groovy.ast.TaskEntry;

class SingleLineComment
extends Comment {
    SingleLineComment(int sline, int scol, int eline, int ecol, String string) {
        super(1, sline, scol, eline, ecol, string);
    }

    @Override
    public List<TaskEntry> getPositionsOf(String taskTag, String taskPriority, int[] lineseps, boolean caseSensitive) {
        int i = this.findTaskTag(this.comment, taskTag, caseSensitive, 0);
        if (i == -1) {
            return Collections.emptyList();
        }
        ArrayList<TaskEntry> tasks = new ArrayList<TaskEntry>();
        while (i != -1) {
            if (this.isValidStartLocationForTask(this.comment, i, taskTag)) {
                int offsetToLineStart = this.sline == 1 ? 0 : lineseps[this.sline - 2] + 1;
                int taskTagStart = offsetToLineStart + (this.scol - 1) + i;
                int taskEnd = offsetToLineStart + this.ecol - 2;
                TaskEntry taskEntry = new TaskEntry(taskTagStart, taskEnd, taskTag, taskPriority, this.comment, offsetToLineStart + this.scol - 1);
                tasks.add(taskEntry);
            }
            i = this.findTaskTag(this.comment, taskTag, caseSensitive, i + taskTag.length());
        }
        return tasks;
    }
}

