/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.lang.GroovyClassLoader;
import groovy.lang.Tuple;
import groovy.lang.Tuple3;
import groovy.transform.CompilationUnitAware;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.GroovyException;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.control.ASTTransformationsContext;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.WarningMessage;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.ASTTransformationCollectorCodeVisitor;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.util.URLStreams;

public final class ASTTransformationVisitor
extends ClassCodeVisitorSupport {
    private final ASTTransformationsContext context;
    private final CompilePhase phase;
    private SourceUnit source;
    private List<ASTNode[]> targetNodes;
    private Map<ASTNode, List<ASTTransformation>> transforms;
    private static final Tuple3<String, String, String> COMPILEDYNAMIC_AND_COMPILESTATIC_AND_TYPECHECKED = Tuple.tuple("groovy.transform.CompileDynamic", "groovy.transform.CompileStatic", "groovy.transform.TypeChecked");

    private ASTTransformationVisitor(CompilePhase phase, ASTTransformationsContext context) {
        this.phase = phase;
        this.context = context;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    private static String getTargetName(ASTNode node, ClassNode type) {
        if (node == type) {
            return "type: " + type.toString(false);
        }
        if (node instanceof FieldNode) {
            return "field: " + ((FieldNode)node).getName();
        }
        if (node instanceof MethodNode) {
            return "method: " + ((MethodNode)node).getName();
        }
        if (node instanceof PropertyNode) {
            return "property: " + ((PropertyNode)node).getName();
        }
        if (node instanceof DeclarationExpression) {
            DeclarationExpression expr = (DeclarationExpression)node;
            if (!expr.isMultipleAssignmentDeclaration()) {
                return "variable: " + expr.getVariableExpression().getName();
            }
            node = expr.getLeftExpression();
        }
        return String.valueOf(type.toString(false)) + ":" + node;
    }

    @Override
    public void visitClass(ClassNode classNode) {
        Map<Class<? extends ASTTransformation>, Set<ASTNode>> baseTransforms = classNode.getTransforms(this.phase);
        if (!baseTransforms.isEmpty()) {
            HashMap<Class<? extends ASTTransformation>, ASTTransformation> transformInstances = new HashMap<Class<? extends ASTTransformation>, ASTTransformation>();
            for (Class<? extends ASTTransformation> clazz : baseTransforms.keySet()) {
                try {
                    transformInstances.put(clazz, clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    this.source.getErrorCollector().addError(new SimpleMessage("Could not instantiate Transformation Processor " + clazz, this.source));
                }
            }
            this.transforms = new HashMap<ASTNode, List<ASTTransformation>>();
            for (Map.Entry entry : baseTransforms.entrySet()) {
                for (ASTNode node : (Set)entry.getValue()) {
                    List list = this.transforms.computeIfAbsent(node, k -> new ArrayList());
                    list.add((ASTTransformation)transformInstances.get(entry.getKey()));
                }
            }
            this.targetNodes = new LinkedList<ASTNode[]>();
            super.visitClass(classNode);
            for (ASTNode[] aSTNodeArray : this.targetNodes) {
                for (ASTTransformation snt : this.transforms.get(aSTNodeArray[0])) {
                    try {
                        long t0 = System.nanoTime();
                        boolean okToSet = this.source != null && this.source.getErrorCollector() != null;
                        try {
                            if (okToSet) {
                                this.source.getErrorCollector().transformActive = true;
                            }
                            if (snt instanceof CompilationUnitAware) {
                                ((CompilationUnitAware)((Object)snt)).setCompilationUnit(this.context.getCompilationUnit());
                            }
                            snt.visit(aSTNodeArray, this.source);
                        }
                        finally {
                            if (okToSet) {
                                this.source.getErrorCollector().transformActive = false;
                            }
                        }
                        if (!GroovyLogManager.manager.hasLoggers()) continue;
                        long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0);
                        String sourceName = DefaultGroovyMethods.last(this.source.getName().split("/|\\\\"));
                        GroovyLogManager.manager.log(TraceCategory.AST_TRANSFORM, "Local transform " + snt.getClass().getName() + " applied to " + sourceName + "(" + ASTTransformationVisitor.getTargetName(aSTNodeArray[1], classNode) + ") in " + millis + "ms");
                    }
                    catch (NoClassDefFoundError ncdfe) {
                        String message = "Unable to run AST transform " + snt.getClass().getName() + ": missing class " + ncdfe.getMessage() + ": Are you attempting to use groovy classes in an AST transform in the same project in which it is defined?";
                        this.source.addError(new SyntaxException(message, (Throwable)ncdfe, aSTNodeArray[1].getLineNumber(), aSTNodeArray[1].getColumnNumber()));
                    }
                }
            }
        }
    }

    @Override
    public void visitAnnotations(AnnotatedNode node) {
        super.visitAnnotations(node);
        for (AnnotationNode annotation : this.distinctAnnotations(node)) {
            if (!this.transforms.containsKey(annotation)) continue;
            this.targetNodes.add(new ASTNode[]{annotation, node});
        }
    }

    private List<AnnotationNode> distinctAnnotations(AnnotatedNode node) {
        LinkedList<AnnotationNode> result = new LinkedList<AnnotationNode>();
        AnnotationNode resultAnnotationNode = null;
        int resultIndex = -1;
        for (AnnotationNode annotationNode : node.getAnnotations()) {
            int index = COMPILEDYNAMIC_AND_COMPILESTATIC_AND_TYPECHECKED.indexOf(annotationNode.getClassNode().getName());
            if (-1 != index) {
                Expression value;
                if (1 == index && (value = annotationNode.getMember("value")) != null && "groovy.transform.TypeCheckingMode.SKIP".equals(value.getText())) {
                    index = 0;
                }
                if (resultAnnotationNode != null && index >= resultIndex) continue;
                resultAnnotationNode = annotationNode;
                resultIndex = index;
                continue;
            }
            result.add(annotationNode);
        }
        if (resultAnnotationNode != null) {
            result.add(resultAnnotationNode);
        }
        return result;
    }

    public static void addPhaseOperations(CompilationUnit compilationUnit) {
        ASTTransformationsContext context = compilationUnit.getASTTransformationsContext();
        ASTTransformationVisitor.addGlobalTransforms(context);
        compilationUnit.addPhaseOperation((source, ignore, classNode) -> {
            ASTTransformationCollectorCodeVisitor visitor = new ASTTransformationCollectorCodeVisitor(source, compilationUnit.getTransformLoader());
            visitor.visitClass(classNode);
        }, 4);
        CompilePhase[] compilePhaseArray = CompilePhase.values();
        int n = compilePhaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompilePhase phase = compilePhaseArray[n2];
            switch (phase) {
                case INITIALIZATION: 
                case PARSING: 
                case CONVERSION: {
                    break;
                }
                default: {
                    compilationUnit.addPhaseOperation((source, ignore, classNode) -> {
                        ASTTransformationVisitor visitor = new ASTTransformationVisitor(phase, context);
                        visitor.source = source;
                        visitor.visitClass(classNode);
                    }, phase.getPhaseNumber());
                }
            }
            ++n2;
        }
    }

    public static void addNewPhaseOperation(CompilationUnit compilationUnit, SourceUnit sourceUnit, ClassNode classNode) {
        int phase = compilationUnit.getPhase();
        if (phase < 4) {
            return;
        }
        ASTTransformationCollectorCodeVisitor visitor = new ASTTransformationCollectorCodeVisitor(sourceUnit, compilationUnit.getTransformLoader());
        visitor.visitClass(classNode);
        compilationUnit.addNewPhaseOperation(source -> {
            if (source == sourceUnit) {
                ASTTransformationVisitor visitor = new ASTTransformationVisitor(CompilePhase.fromPhaseNumber(phase), compilationUnit.getASTTransformationsContext());
                visitor.source = source;
                visitor.visitClass(classNode);
            }
        }, phase);
    }

    public static void addGlobalTransformsAfterGrab(ASTTransformationsContext context) {
        ASTTransformationVisitor.doAddGlobalTransforms(context, false);
    }

    public static void addGlobalTransforms(ASTTransformationsContext context) {
        ASTTransformationVisitor.doAddGlobalTransforms(context, true);
    }

    private static void doAddGlobalTransforms(ASTTransformationsContext context, boolean isFirstScan) {
        CompilationUnit compilationUnit = context.getCompilationUnit();
        GroovyClassLoader transformLoader = compilationUnit.getTransformLoader();
        LinkedHashMap<String, URL> transformNames = new LinkedHashMap<String, URL>();
        try {
            Enumeration<URL> globalServices = transformLoader.getResources("META-INF/services/org.codehaus.groovy.transform.ASTTransformation");
            while (globalServices.hasMoreElements()) {
                URL service = globalServices.nextElement();
                Throwable throwable = null;
                Object var8_10 = null;
                try {
                    String className;
                    BufferedReader svcIn = new BufferedReader(new InputStreamReader(URLStreams.openUncachedStream(service), StandardCharsets.UTF_8));
                    try {
                        className = svcIn.readLine();
                    }
                    catch (IOException ioe) {
                        compilationUnit.getErrorCollector().addError(new SimpleMessage("IOException reading the service definition at " + service.toExternalForm() + " because of exception " + ioe.toString(), null));
                        if (svcIn == null) continue;
                        svcIn.close();
                        continue;
                    }
                    try {
                        Set<String> disabledGlobalTransforms = compilationUnit.getConfiguration().getDisabledGlobalASTTransformations();
                        if (disabledGlobalTransforms == null) {
                            disabledGlobalTransforms = Collections.emptySet();
                        }
                        while (className != null) {
                            if (!className.startsWith("#") && className.length() > 0 && !disabledGlobalTransforms.contains(className)) {
                                if (transformNames.containsKey(className)) {
                                    try {
                                        if (!service.toURI().equals(((URL)transformNames.get(className)).toURI())) {
                                            compilationUnit.getErrorCollector().addWarning(2, "The global transform for class " + className + " is defined in both " + ((URL)transformNames.get(className)).toExternalForm() + " and " + service.toExternalForm() + " - the former definition will be used and the latter ignored.", null, null);
                                        }
                                    }
                                    catch (URISyntaxException e) {
                                        compilationUnit.getErrorCollector().addWarning(2, "Failed to parse URL as URI because of exception " + e.toString(), null, null);
                                    }
                                } else if (compilationUnit.allowTransforms) {
                                    transformNames.put(className, service);
                                }
                            }
                            try {
                                className = svcIn.readLine();
                            }
                            catch (IOException ioe) {
                                compilationUnit.getErrorCollector().addError(new SimpleMessage("IOException reading the service definition at " + service.toExternalForm() + " because of exception " + ioe.toString(), null));
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        if (svcIn != null) {
                            svcIn.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
        }
        catch (IOException e) {
            compilationUnit.getErrorCollector().addError(new SimpleMessage("IO Exception attempting to load global transforms:" + e.getMessage(), null));
        }
        if (isFirstScan) {
            for (Map.Entry entry2 : transformNames.entrySet()) {
                context.getGlobalTransformNames().add((String)entry2.getKey());
            }
            ASTTransformationVisitor.addPhaseOperationsForGlobalTransforms(context.getCompilationUnit(), transformNames, isFirstScan);
        } else {
            transformNames.entrySet().removeIf(entry -> !context.getGlobalTransformNames().add((String)entry.getKey()));
            ASTTransformationVisitor.addPhaseOperationsForGlobalTransforms(context.getCompilationUnit(), transformNames, isFirstScan);
        }
    }

    private static void addPhaseOperationsForGlobalTransforms(CompilationUnit compilationUnit, Map<String, URL> transformNames, boolean isFirstScan) {
        GroovyClassLoader transformLoader = compilationUnit.getTransformLoader();
        for (Map.Entry<String, URL> entry : transformNames.entrySet()) {
            try {
                Class gTransClass = transformLoader.loadClass(entry.getKey(), false, true, false);
                GroovyASTTransformation transformAnnotation = gTransClass.getAnnotation(GroovyASTTransformation.class);
                if (transformAnnotation == null) {
                    compilationUnit.getErrorCollector().addWarning(new WarningMessage(2, "Transform Class " + entry.getKey() + " is specified as a global transform in " + entry.getValue().toExternalForm() + " but it is not annotated by " + GroovyASTTransformation.class.getName() + " the global transform associated with it may fail and cause the compilation to fail.", null, null));
                    continue;
                }
                if (ASTTransformation.class.isAssignableFrom(gTransClass)) {
                    try {
                        boolean[] isBuggered = new boolean[1];
                        ASTTransformation instance = (ASTTransformation)gTransClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        if (instance instanceof CompilationUnitAware) {
                            ((CompilationUnitAware)((Object)instance)).setCompilationUnit(compilationUnit);
                        }
                        CompilationUnit.ISourceUnitOperation suOp = source -> {
                            if (isBuggered[0]) {
                                return;
                            }
                            try {
                                long t0 = System.nanoTime();
                                boolean okToSet = source != null && source.getErrorCollector() != null;
                                try {
                                    if (okToSet) {
                                        source.getErrorCollector().transformActive = true;
                                    }
                                    instance.visit(new ASTNode[]{source.getAST()}, source);
                                }
                                finally {
                                    if (okToSet) {
                                        source.getErrorCollector().transformActive = false;
                                    }
                                }
                                if (GroovyLogManager.manager.hasLoggers()) {
                                    long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0);
                                    String sourceName = DefaultGroovyMethods.last(source.getName().split("/|\\\\"));
                                    GroovyLogManager.manager.log(TraceCategory.AST_TRANSFORM, "Global transform " + instance.getClass().getName() + " applied to " + sourceName + " in " + millis + "ms");
                                }
                            }
                            catch (NoClassDefFoundError ncdfe) {
                                source.addException(new GroovyException("Transform " + instance.getClass().getName() + " cannot be run", ncdfe));
                                blArray[0] = true;
                            }
                        };
                        if (isFirstScan) {
                            compilationUnit.addPhaseOperation(suOp, transformAnnotation.phase().getPhaseNumber());
                            continue;
                        }
                        compilationUnit.addNewPhaseOperation(suOp, transformAnnotation.phase().getPhaseNumber());
                    }
                    catch (Throwable t) {
                        if (t instanceof InvocationTargetException) {
                            t = ((InvocationTargetException)t).getTargetException();
                        }
                        compilationUnit.getErrorCollector().addError(new SimpleMessage("Unexpected problem with AST transform: " + t.getMessage(), null));
                    }
                    continue;
                }
                compilationUnit.getErrorCollector().addError(new SimpleMessage("Transform Class " + entry.getKey() + " specified at " + entry.getValue().toExternalForm() + " is not an ASTTransformation.", null));
            }
            catch (Exception e) {
                Throwable t = e instanceof InvocationTargetException ? e.getCause() : e;
                compilationUnit.getErrorCollector().addError(new SimpleMessage("Could not instantiate global transform class " + entry.getKey() + " specified at " + entry.getValue().toExternalForm() + "  because of exception " + t.toString(), null));
            }
        }
    }
}

