/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.antlr;

import groovy.lang.groovydoc.Groovydoc;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.groovydoc.GroovyClassDoc;
import org.codehaus.groovy.groovydoc.GroovyMethodDoc;
import org.codehaus.groovy.tools.groovydoc.LinkArgument;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyClassDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyConstructorDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyExecutableMemberDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyFieldDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyMethodDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyParameter;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyType;
import org.codehaus.groovy.transform.trait.Traits;

public class GroovydocVisitor
extends ClassCodeVisitorSupport {
    private final SourceUnit unit;
    private final List<LinkArgument> links;
    private String packagePath;
    private SimpleGroovyClassDoc currentClassDoc = null;
    private Map<String, GroovyClassDoc> classDocs = new HashMap<String, GroovyClassDoc>();
    private static final String FS = "/";
    private final Map<String, String> aliases = new HashMap<String, String>();

    public GroovydocVisitor(SourceUnit unit, String packagePath, List<LinkArgument> links) {
        this.unit = unit;
        this.packagePath = packagePath;
        this.links = links;
    }

    protected SourceUnit getSourceUnit() {
        return this.unit;
    }

    public void visitClass(ClassNode node) {
        List<String> imports = node.getModule().getImports().stream().map(ImportNode::getClassName).collect(Collectors.toList());
        String name = node.getNameWithoutPackage();
        if (node instanceof InnerClassNode) {
            name = name.replaceAll("\\$", ".");
        }
        this.currentClassDoc = new SimpleGroovyClassDoc(imports, this.aliases, name, this.links);
        if (node.isEnum()) {
            this.currentClassDoc.setTokenType(61);
        }
        if (node.isAnnotationDefinition()) {
            this.currentClassDoc.setTokenType(64);
        }
        if (node.isInterface()) {
            this.currentClassDoc.setTokenType(14);
        }
        if (Traits.isTrait((ClassNode)node)) {
            this.currentClassDoc.setTokenType(15);
        }
        if (node.isScript()) {
            this.currentClassDoc.setScript(true);
        }
        for (ClassNode iface : node.getInterfaces()) {
            this.currentClassDoc.addInterfaceName(this.makeType(iface));
        }
        if (!node.isInterface() && node.getSuperClass() != null) {
            String superName = this.makeType(node.getSuperClass());
            this.currentClassDoc.setSuperClassName(superName);
            String superSimpleName = node.getSuperClass().getNameWithoutPackage();
            if (!this.classDocs.containsKey(superSimpleName)) {
                SimpleGroovyClassDoc superDoc = new SimpleGroovyClassDoc(imports, superName);
                superDoc.setFullPathName(superName);
            }
        }
        if (Modifier.isPublic(node.getModifiers())) {
            this.currentClassDoc.setPublic(true);
        }
        if (Modifier.isProtected(node.getModifiers())) {
            this.currentClassDoc.setProtected(true);
        }
        if (Modifier.isPrivate(node.getModifiers())) {
            this.currentClassDoc.setPrivate(true);
        }
        if (Modifier.isStatic(node.getModifiers())) {
            this.currentClassDoc.setStatic(true);
        }
        if (Modifier.isFinal(node.getModifiers())) {
            this.currentClassDoc.setFinal(true);
        }
        if (Modifier.isAbstract(node.getModifiers())) {
            this.currentClassDoc.setAbstract(true);
        }
        this.currentClassDoc.setFullPathName(this.packagePath + FS + name);
        this.currentClassDoc.setGroovy(true);
        this.currentClassDoc.setNameWithTypeArgs(name);
        this.classDocs.put(this.currentClassDoc.getFullPathName(), this.currentClassDoc);
        super.visitClass(node);
        SimpleGroovyClassDoc parent = this.currentClassDoc;
        boolean explicitCons = false;
        for (GroovyMethodDoc meth : this.currentClassDoc.methods()) {
            if (!(meth instanceof SimpleGroovyConstructorDoc)) continue;
            explicitCons = true;
            break;
        }
        if (!explicitCons) {
            SimpleGroovyConstructorDoc cons = new SimpleGroovyConstructorDoc(name, this.currentClassDoc);
            cons.setPublic(true);
            this.currentClassDoc.add(cons);
        }
        Iterator innerClasses = node.getInnerClasses();
        while (innerClasses.hasNext()) {
            this.visitClass((ClassNode)innerClasses.next());
            parent.addNested(this.currentClassDoc);
            this.currentClassDoc = parent;
        }
    }

    public void visitConstructor(ConstructorNode node) {
        SimpleGroovyConstructorDoc cons = new SimpleGroovyConstructorDoc(this.currentClassDoc.simpleTypeName(), this.currentClassDoc);
        this.setConstructorOrMethodCommon((MethodNode)node, cons);
        this.currentClassDoc.add(cons);
        super.visitConstructor(node);
    }

    public void visitMethod(MethodNode node) {
        SimpleGroovyMethodDoc meth = new SimpleGroovyMethodDoc(node.getName(), this.currentClassDoc);
        meth.setReturnType(new SimpleGroovyType(this.makeType(node.getReturnType())));
        this.setConstructorOrMethodCommon(node, meth);
        this.currentClassDoc.add(meth);
        this.processPropertiesFromGetterSetter(meth);
    }

    private void processPropertiesFromGetterSetter(SimpleGroovyMethodDoc currentMethodDoc) {
        String methodName = currentMethodDoc.name();
        int len = methodName.length();
        String prefix = null;
        String propName = null;
        if (len > 3 && methodName.startsWith("get")) {
            prefix = "get";
            propName = methodName.substring(3);
        } else if (len > 3 && methodName.startsWith("set")) {
            prefix = "set";
            propName = methodName.substring(3);
        } else if (len > 2 && methodName.startsWith("is")) {
            prefix = "is";
            propName = methodName.substring(2);
        } else {
            return;
        }
        SimpleGroovyClassDoc classDoc = this.currentClassDoc;
        if (classDoc == null) {
            return;
        }
        GroovyMethodDoc[] methods = classDoc.methods();
        String expectedMethodName = null;
        expectedMethodName = "set".equals(prefix) && currentMethodDoc.parameters().length >= 1 && !currentMethodDoc.parameters()[0].typeName().equals("boolean") ? "get" + propName : ("get".equals(prefix) && !currentMethodDoc.returnType().typeName().equals("boolean") ? "set" + propName : ("is".equals(prefix) ? "set" + propName : "is" + propName));
        for (GroovyMethodDoc methodDoc : methods) {
            if (!methodDoc.name().equals(expectedMethodName)) continue;
            String fieldName = propName.substring(0, 1).toLowerCase() + propName.substring(1);
            SimpleGroovyFieldDoc currentFieldDoc = new SimpleGroovyFieldDoc(fieldName, classDoc);
            if (expectedMethodName.startsWith("set") && methodDoc.parameters().length >= 1) {
                String typeName = methodDoc.parameters()[0].typeName();
                currentFieldDoc.setType(new SimpleGroovyType(typeName));
            } else {
                currentFieldDoc.setType(methodDoc.returnType());
            }
            if (!methodDoc.isPublic() || !currentMethodDoc.isPublic()) continue;
            classDoc.addProperty(currentFieldDoc);
            break;
        }
    }

    public void visitProperty(PropertyNode node) {
        String name = node.getName();
        SimpleGroovyFieldDoc field = new SimpleGroovyFieldDoc(name, this.currentClassDoc);
        field.setType(new SimpleGroovyType(this.makeType(node.getType())));
        Groovydoc groovydoc = node.getGroovydoc();
        field.setRawCommentText(groovydoc == null ? "" : groovydoc.getContent());
        this.currentClassDoc.addProperty(field);
        super.visitProperty(node);
    }

    private String makeType(ClassNode node) {
        return node.getName().replaceAll("\\.", FS).replaceAll("\\$", ".");
    }

    public void visitField(FieldNode node) {
        String name = node.getName();
        SimpleGroovyFieldDoc field = new SimpleGroovyFieldDoc(name, this.currentClassDoc);
        field.setType(new SimpleGroovyType(this.makeType(node.getType())));
        boolean isProp = node.getDeclaringClass().getProperty(name) != null;
        int mods = node.getModifiers();
        if (this.currentClassDoc.isScript() && (mods & 7) == 0) {
            isProp = true;
            this.currentClassDoc.addProperty(field);
        }
        if (!isProp) {
            if (node.isPublic()) {
                field.setPublic(true);
            }
            if (node.isProtected()) {
                field.setProtected(true);
            }
            if (node.isPrivate()) {
                field.setPrivate(true);
            }
            if (node.isStatic()) {
                field.setStatic(true);
            }
            if (node.isFinal()) {
                field.setFinal(true);
            }
            field.setRawCommentText(node.getGroovydoc().getContent());
            this.currentClassDoc.add(field);
        }
        super.visitField(node);
    }

    private void setConstructorOrMethodCommon(MethodNode node, SimpleGroovyExecutableMemberDoc methOrCons) {
        methOrCons.setRawCommentText(node.getGroovydoc().getContent());
        if (node.isPublic()) {
            methOrCons.setPublic(true);
        }
        if (node.isAbstract()) {
            methOrCons.setAbstract(true);
        }
        if (node.isProtected()) {
            methOrCons.setProtected(true);
        }
        if (node.isPrivate()) {
            methOrCons.setPrivate(true);
        }
        if (node.isStatic()) {
            methOrCons.setStatic(true);
        }
        if (node.isFinal()) {
            methOrCons.setFinal(true);
        }
        for (Parameter param : node.getParameters()) {
            SimpleGroovyParameter p = new SimpleGroovyParameter(param.getName());
            p.setType(new SimpleGroovyType(this.makeType(param.getType())));
            methOrCons.add(p);
        }
    }

    public Map<String, GroovyClassDoc> getGroovyClassDocs() {
        return this.classDocs;
    }
}

