/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.javac;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.tools.javac.JavaAwareResolveVisitor;
import org.codehaus.groovy.tools.javac.JavaCompiler;
import org.codehaus.groovy.tools.javac.JavaCompilerFactory;
import org.codehaus.groovy.tools.javac.JavaStubGenerator;
import org.codehaus.groovy.tools.javac.JavacCompilerFactory;

public class JavaAwareCompilationUnit
extends CompilationUnit {
    private LinkedList javaSources;
    private JavaStubGenerator stubGenerator;
    private JavaCompilerFactory compilerFactory = new JavacCompilerFactory();
    private File generationGoal;
    private boolean keepStubs;

    public JavaAwareCompilationUnit(CompilerConfiguration configuration) {
        this(configuration, null);
    }

    public JavaAwareCompilationUnit(CompilerConfiguration configuration, GroovyClassLoader groovyClassLoader) {
        super(configuration, null, groovyClassLoader);
        this.javaSources = new LinkedList();
        Map<String, Object> options = configuration.getJointCompilationOptions();
        this.generationGoal = (File)options.get("stubDir");
        boolean useJava5 = configuration.getTargetBytecode().equals("1.5");
        this.stubGenerator = new JavaStubGenerator(this.generationGoal, false, useJava5);
        this.keepStubs = Boolean.TRUE.equals(options.get("keepStubs"));
        this.addPhaseOperation(new CompilationUnit.PrimaryClassNodeOperation(){

            public void call(SourceUnit source, GeneratorContext context, ClassNode node) throws CompilationFailedException {
                if (JavaAwareCompilationUnit.this.javaSources.size() != 0) {
                    new JavaAwareResolveVisitor(JavaAwareCompilationUnit.this).startResolving(node, source);
                }
            }
        }, 3);
        this.addPhaseOperation(new CompilationUnit.PrimaryClassNodeOperation(){

            public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                try {
                    if (JavaAwareCompilationUnit.this.javaSources.size() != 0) {
                        JavaAwareCompilationUnit.this.stubGenerator.generateClass(classNode);
                    }
                }
                catch (FileNotFoundException fnfe) {
                    source.addException(fnfe);
                }
            }
        }, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotoPhase(int phase) throws CompilationFailedException {
        super.gotoPhase(phase);
        if (phase == 4 && this.javaSources.size() > 0) {
            Iterator modules = this.getAST().getModules().iterator();
            while (modules.hasNext()) {
                ModuleNode module = (ModuleNode)modules.next();
                module.setImportsResolved(false);
            }
            try {
                JavaCompiler compiler = this.compilerFactory.createCompiler(this.getConfiguration());
                compiler.compile(this.javaSources, this);
            }
            finally {
                if (!this.keepStubs) {
                    this.stubGenerator.clean();
                }
                this.javaSources.clear();
            }
        }
    }

    public void configure(CompilerConfiguration configuration) {
        super.configure(configuration);
        File targetDir = configuration.getTargetDirectory();
        if (targetDir != null) {
            String classOutput = targetDir.getAbsolutePath();
            this.getClassLoader().addClasspath(classOutput);
        }
    }

    private void addJavaSource(File file) {
        String path = file.getAbsolutePath();
        Iterator iter = this.javaSources.iterator();
        while (iter.hasNext()) {
            String su = (String)iter.next();
            if (!path.equals(su)) continue;
            return;
        }
        this.javaSources.add(path);
    }

    public void addSources(String[] paths) {
        for (int i = 0; i < paths.length; ++i) {
            File file = new File(paths[i]);
            if (file.getName().endsWith(".java")) {
                this.addJavaSource(file);
                continue;
            }
            this.addSource(file);
        }
    }

    public void addSources(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getName().endsWith(".java")) {
                this.addJavaSource(files[i]);
                continue;
            }
            this.addSource(files[i]);
        }
    }

    public JavaCompilerFactory getCompilerFactory() {
        return this.compilerFactory;
    }

    public void setCompilerFactory(JavaCompilerFactory compilerFactory) {
        this.compilerFactory = compilerFactory;
    }
}

