/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.lang.GroovyClassLoader;
import java.lang.reflect.Method;
import java.util.Iterator;
import net.sf.retrotranslator.runtime.java.lang._Class;
import net.sf.retrotranslator.runtime.java.lang.annotation.Annotation_;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformationClass;

public class ASTTransformationCollectorCodeVisitor
extends ClassCodeVisitorSupport {
    private SourceUnit source;
    private ClassNode classNode;
    private GroovyClassLoader transformLoader;
    static /* synthetic */ Class class$org$codehaus$groovy$transform$ASTTransformation;
    static /* synthetic */ Class class$org$codehaus$groovy$transform$GroovyASTTransformationClass;

    public ASTTransformationCollectorCodeVisitor(SourceUnit source, GroovyClassLoader transformLoader) {
        this.source = source;
        this.transformLoader = transformLoader;
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    public void visitClass(ClassNode klassNode) {
        ClassNode oldClass = this.classNode;
        this.classNode = klassNode;
        super.visitClass(this.classNode);
        this.classNode = oldClass;
    }

    public void visitAnnotations(AnnotatedNode node) {
        super.visitAnnotations(node);
        Iterator i$ = node.getAnnotations().iterator();
        while (i$.hasNext()) {
            AnnotationNode annotation = (AnnotationNode)i$.next();
            Annotation_ transformClassAnnotation = ASTTransformationCollectorCodeVisitor.getTransformClassAnnotation(annotation.getClassNode());
            if (transformClassAnnotation == null) continue;
            this.addTransformsToClassNode(annotation, transformClassAnnotation);
        }
    }

    private void addTransformsToClassNode(AnnotationNode annotation, Annotation_ transformClassAnnotation) {
        int i$;
        String[] transformClassNames = this.getTransformClassNames(transformClassAnnotation);
        Class[] transformClasses = this.getTransformClasses(transformClassAnnotation);
        if (transformClassNames.length == 0 && transformClasses.length == 0) {
            this.source.getErrorCollector().addError(new SimpleMessage("@GroovyASTTransformationClass in " + annotation.getClassNode().getName() + " does not specify any transform class names/classes", this.source));
        }
        if (transformClassNames.length > 0 && transformClasses.length > 0) {
            this.source.getErrorCollector().addError(new SimpleMessage("@GroovyASTTransformationClass in " + annotation.getClassNode().getName() + " should specify transforms only by class names or by classes and not by both", this.source));
        }
        Object[] arr$ = transformClassNames;
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            String transformClass = arr$[i$];
            try {
                Class klass = this.transformLoader.loadClass(transformClass, false, true, false);
                this.verifyClassAndAddTransform(annotation, klass);
                continue;
            }
            catch (ClassNotFoundException e) {
                this.source.getErrorCollector().addErrorAndContinue(new SimpleMessage("Could not find class for Transformation Processor " + transformClass + " declared by " + annotation.getClassNode().getName(), this.source));
            }
        }
        arr$ = transformClasses;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            Object klass = arr$[i$];
            this.verifyClassAndAddTransform(annotation, (Class)klass);
        }
    }

    private void verifyClassAndAddTransform(AnnotationNode annotation, Class klass) {
        Class<?> clazz = class$org$codehaus$groovy$transform$ASTTransformation;
        if (clazz == null) {
            clazz = class$org$codehaus$groovy$transform$ASTTransformation = new ASTTransformation[0].getClass().getComponentType();
        }
        if (clazz.isAssignableFrom(klass)) {
            this.classNode.addTransform(klass, annotation);
        } else {
            this.source.getErrorCollector().addError(new SimpleMessage("Not an ASTTransformation: " + klass.getName() + " declared by " + annotation.getClassNode().getName(), this.source));
        }
    }

    private static Annotation_ getTransformClassAnnotation(ClassNode annotatedType) {
        if (!annotatedType.isResolved()) {
            return null;
        }
        Annotation_[] arr$ = _Class.getAnnotations((Class)annotatedType.getTypeClass());
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation_ ann = arr$[i$];
            String string = ann.annotationType().getName();
            Class<?> clazz = class$org$codehaus$groovy$transform$GroovyASTTransformationClass;
            if (clazz == null) {
                clazz = new GroovyASTTransformationClass[0].getClass().getComponentType();
            }
            if (!string.equals(clazz.getName())) continue;
            return ann;
        }
        return null;
    }

    private String[] getTransformClassNames(Annotation_ transformClassAnnotation) {
        try {
            Method valueMethod = transformClassAnnotation.getClass().getMethod("value", new Class[0]);
            return (String[])valueMethod.invoke((Object)transformClassAnnotation, new Object[0]);
        }
        catch (Exception e) {
            this.source.addException(e);
            return new String[0];
        }
    }

    private Class[] getTransformClasses(Annotation_ transformClassAnnotation) {
        try {
            Method classesMethod = transformClassAnnotation.getClass().getMethod("classes", new Class[0]);
            return (Class[])classesMethod.invoke((Object)transformClassAnnotation, new Object[0]);
        }
        catch (Exception e) {
            this.source.addException(e);
            return new Class[0];
        }
    }
}

