/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.ant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class ConfigHolder {
    private Project project;
    private String installText;

    static void parseCompileProperties(String value, List<String> fragments, List<String> propertyRefs) throws BuildException {
        int pos;
        int prev = 0;
        while ((pos = value.indexOf("@", prev)) >= 0) {
            if (pos > 0) {
                fragments.add(value.substring(prev, pos));
            }
            if (pos == value.length() - 1) {
                fragments.add("@");
                prev = pos + 1;
                continue;
            }
            if (value.charAt(pos + 1) != '{') {
                if (value.charAt(pos + 1) == '@') {
                    fragments.add("@");
                    prev = pos + 2;
                    continue;
                }
                fragments.add(value.substring(pos, pos + 2));
                prev = pos + 2;
                continue;
            }
            int endName = value.indexOf(125, pos);
            if (endName < 0) {
                throw new BuildException("Syntax error in property: " + value);
            }
            String propertyName = value.substring(pos + 2, endName);
            fragments.add(null);
            propertyRefs.add(propertyName);
            prev = endName + 1;
        }
        if (prev < value.length()) {
            fragments.add(value.substring(prev));
        }
    }

    ConfigHolder(Project project) {
        this.project = project;
    }

    public void addText(String rawText) {
        ArrayList<String> fragments = new ArrayList<String>();
        ArrayList<String> propertyRefs = new ArrayList<String>();
        ConfigHolder.parseCompileProperties(rawText, fragments, propertyRefs);
        StringBuffer sb = new StringBuffer();
        Enumeration<String> fragmentsEnumeration = Collections.enumeration(fragments);
        Enumeration<String> propertyRefsEnumeration = Collections.enumeration(propertyRefs);
        while (fragmentsEnumeration.hasMoreElements()) {
            String fragment = fragmentsEnumeration.nextElement();
            if (fragment == null) {
                String propertyName = propertyRefsEnumeration.nextElement();
                String replacement = this.project.getProperty(propertyName);
                if (replacement == null) {
                    this.project.log("Property @{" + propertyName + "} has not been set", 3);
                }
                fragment = replacement != null ? replacement : "@{" + propertyName + "}";
            }
            sb.append(fragment);
        }
        this.installText = sb.toString();
    }

    public String getText() {
        return this.installText;
    }
}

