/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.ant;

import com.izforge.izpack.ant.ConfigHolder;
import com.izforge.izpack.ant.IzpackAntRunnable;
import com.izforge.izpack.ant.Property;
import com.izforge.izpack.ant.logging.AntHandler;
import com.izforge.izpack.api.data.PackCompression;
import com.izforge.izpack.compiler.listener.PackagerListener;
import com.izforge.izpack.merge.resolve.ResolveUtils;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.PropertySet;

public class IzPackTask
extends Task
implements PackagerListener {
    private ConfigHolder config = null;
    private String input = null;
    private String basedir = null;
    private String output = null;
    private boolean mkdirs;
    private String compression = PackCompression.DEFAULT.toName();
    private int compressionLevel = -1;
    private InstallerType installerType = null;
    private String izPackDir = null;
    private Properties properties;
    private Boolean inheritAll = false;

    public ConfigHolder createConfig() {
        this.config = new ConfigHolder(this.getProject());
        return this.config;
    }

    public void packagerMsg(String str) {
        this.packagerMsg(str, 2);
    }

    public void packagerMsg(String str, int priority) {
        int antPriority;
        switch (priority) {
            case 0: {
                antPriority = 4;
                break;
            }
            case 1: {
                antPriority = 0;
                break;
            }
            case 2: {
                antPriority = 2;
                break;
            }
            case 3: {
                antPriority = 3;
                break;
            }
            case 4: {
                antPriority = 1;
                break;
            }
            default: {
                antPriority = 2;
            }
        }
        this.log(str, antPriority);
    }

    public void packagerStart() {
        this.log(ResourceBundle.getBundle("com/izforge/izpack/ant/langpacks/messages").getString("Packager_starting"), 4);
    }

    public void packagerStop() {
        this.log(ResourceBundle.getBundle("com/izforge/izpack/ant/langpacks/messages").getString("Packager_ended"), 4);
    }

    public void execute() throws BuildException {
        this.checkInput();
        String kind = this.installerType == null ? null : this.installerType.getValue();
        String configText = null;
        if (this.config != null) {
            configText = this.config.getText();
            this.input = null;
        }
        Logger rootLogger = Logger.getLogger("com.izforge.izpack");
        rootLogger.setUseParentHandlers(false);
        rootLogger.setLevel(Level.INFO);
        AntHandler logHandler = new AntHandler(this.getProject());
        try {
            URLClassLoader loader = new URLClassLoader(this.getUrlsForClassloader());
            Class<?> runableClass = loader.loadClass(IzpackAntRunnable.class.getName());
            Constructor<?> constructor = runableClass.getConstructors()[0];
            Object instance = constructor.newInstance(this.compression, kind, this.input, configText, this.basedir, this.output, this.mkdirs, this.compressionLevel, this.properties, this.inheritAll, this.getProject().getProperties(), this.izPackDir, logHandler);
            Thread thread = new Thread((Runnable)instance);
            thread.setContextClassLoader(loader);
            thread.start();
            Thread.sleep(100L);
            thread.join();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private URL[] getUrlsForClassloader() throws IOException {
        HashSet<URL> result = new HashSet<URL>();
        ClassLoader currentLoader = ((Object)((Object)this)).getClass().getClassLoader();
        Enumeration<URL> urlEnumeration = currentLoader.getResources("");
        result.addAll(Collections.list(urlEnumeration));
        urlEnumeration = currentLoader.getResources("META-INF/");
        while (urlEnumeration.hasMoreElements()) {
            URL url = urlEnumeration.nextElement();
            result.add(ResolveUtils.processUrlToJarUrl((URL)url));
        }
        URL[] urlArray = new URL[result.size()];
        return result.toArray(urlArray);
    }

    private void checkInput() {
        if (this.input == null && this.config == null) {
            throw new BuildException(ResourceBundle.getBundle("com/izforge/izpack/ant/langpacks/messages").getString("input_must_be_specified"));
        }
        if (this.output == null) {
            throw new BuildException(ResourceBundle.getBundle("com/izforge/izpack/ant/langpacks/messages").getString("output_must_be_specified"));
        }
        if (this.basedir == null) {
            throw new BuildException(ResourceBundle.getBundle("com/izforge/izpack/ant/langpacks/messages").getString("basedir_must_be_specified"));
        }
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setMkdirs(boolean mkdirs) {
        this.mkdirs = mkdirs;
    }

    public void setInstallerType(InstallerType installerType) {
        this.installerType = installerType;
    }

    public void setIzPackDir(String izPackDir) {
        if (!izPackDir.endsWith("/")) {
            izPackDir = izPackDir + "/";
        }
        this.izPackDir = izPackDir;
    }

    public void setInheritAll(boolean inheritAll) {
        this.inheritAll = inheritAll;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public void addConfiguredProperty(Property property) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        property.execute();
        Properties props = property.getProperties();
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            this.log("Adding property: " + ((Object)((Object)property)).getClass() + name + "=" + value, 3);
            this.properties.setProperty(name, value);
        }
    }

    public void addConfiguredPropertyset(PropertySet ps) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.putAll((Map<?, ?>)ps.getProperties());
    }

    public static class InstallerType
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"standard", "web"};
        }
    }
}

