/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.ant;

import com.izforge.izpack.compiler.CompilerConfig;
import com.izforge.izpack.compiler.container.CompilerContainer;
import com.izforge.izpack.compiler.data.CompilerData;
import com.izforge.izpack.compiler.data.PropertyManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Handler;
import org.apache.tools.ant.BuildException;

public class IzpackAntRunnable
implements Runnable {
    private final CompilerData compilerData;
    private final String input;
    private final Properties properties;
    private final Boolean inheritAll;
    private final Hashtable<String, String> projectProps;
    private final Handler logHandler;

    public IzpackAntRunnable(String compression, String kind, String input, String configText, String basedir, String output, boolean mkdirs, int compressionLevel, Properties properties, Boolean inheritAll, Hashtable<String, String> antProjectProperties, String izPackDir, Handler logHandler) {
        this.compilerData = new CompilerData(compression, kind, input, configText, basedir, output, mkdirs, compressionLevel);
        this.input = input;
        this.properties = properties;
        this.inheritAll = inheritAll;
        this.projectProps = antProjectProperties;
        this.logHandler = logHandler;
        CompilerData.setIzpackHome((String)izPackDir);
    }

    @Override
    public void run() {
        String value;
        String name;
        Enumeration<Object> e;
        CompilerContainer compilerContainer = new CompilerContainer();
        compilerContainer.addConfig("installFile", (Object)(this.input == null ? "<config>" : this.input));
        compilerContainer.addComponent(CompilerData.class, (Object)this.compilerData);
        compilerContainer.addComponent(Handler.class, (Object)this.logHandler);
        CompilerConfig compilerConfig = (CompilerConfig)compilerContainer.getComponent(CompilerConfig.class);
        PropertyManager propertyManager = (PropertyManager)compilerContainer.getComponent(PropertyManager.class);
        if (this.properties != null) {
            e = this.properties.keys();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                value = this.properties.getProperty(name);
                value = IzpackAntRunnable.fixPathString(value);
                propertyManager.addProperty(name, value);
            }
        }
        if (this.inheritAll.booleanValue()) {
            e = this.projectProps.keys();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                value = this.projectProps.get(name);
                value = IzpackAntRunnable.fixPathString(value);
                propertyManager.addProperty(name, value);
            }
        }
        try {
            compilerConfig.executeCompiler();
        }
        catch (Exception e2) {
            throw new BuildException((Throwable)e2);
        }
    }

    private static String fixPathString(String path) {
        StringBuilder fixpath = new StringBuilder(path);
        for (int q = 0; q < fixpath.length(); ++q) {
            if (fixpath.charAt(q) != '\\') continue;
            fixpath.setCharAt(q, '/');
        }
        return fixpath.toString();
    }
}

