/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.ant.logging;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.tools.ant.Project;

public class AntHandler
extends Handler {
    private StringBuilder sb = new StringBuilder();
    private Project project;

    public AntHandler(Project project) {
        this.project = project;
    }

    @Override
    public synchronized void publish(LogRecord record) {
        int level;
        Throwable thrown;
        String msg = record.getMessage();
        if (msg != null) {
            this.sb.append(msg);
        }
        if ((thrown = record.getThrown()) != null) {
            this.sb.append("\n").append(thrown.toString()).append('\n');
        }
        if ((level = this.convert(record.getLevel())) >= 0) {
            this.project.log(this.sb.toString(), level);
        }
        this.sb.setLength(0);
    }

    private int convert(Level level) {
        int lev = level.intValue();
        if (lev >= Level.SEVERE.intValue()) {
            return 0;
        }
        if (lev >= Level.WARNING.intValue()) {
            return 1;
        }
        if (lev >= Level.INFO.intValue()) {
            return 2;
        }
        if (lev >= Level.FINE.intValue()) {
            return 3;
        }
        if (lev > Level.OFF.intValue()) {
            return 4;
        }
        return -1;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

