/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.summary;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.installer.util.SummaryProcessor;
import java.awt.Component;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

public class SummaryPanel
extends IzPanel {
    private static final long serialVersionUID = 3832626166401282361L;
    private JEditorPane textArea;

    public SummaryPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        super(panel, parent, installData, new IzPanelLayout(log), resources);
        this.add(this.createMultiLineLabelLang("SummaryPanel.info"));
        try {
            this.textArea = new JEditorPane();
            this.textArea.setContentType("text/html");
            this.textArea.setEditable(false);
            JScrollPane scroller = new JScrollPane(this.textArea);
            this.add((Component)scroller, "nextLine");
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        this.getLayoutHelper().completeLayout();
    }

    @Override
    public void panelActivate() {
        super.panelActivate();
        String nextText = this.getString("SummaryPanel.next");
        if (nextText == null) {
            nextText = this.getString("installer.next");
        }
        this.parent.getNavigator().setNextText(nextText);
        this.textArea.setText(SummaryProcessor.getSummary(this.installData));
        this.textArea.setCaretPosition(0);
    }

    @Override
    public void panelDeactivate() {
        super.panelDeactivate();
        this.parent.getNavigator().setNextText(this.getString("installer.next"));
    }
}

