/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.event.ProgressNotifiers;
import com.izforge.izpack.event.AbstractProgressInstallerListener;
import java.util.List;
import java.util.logging.Logger;

public class ProgressBarInstallerListener
extends AbstractProgressInstallerListener {
    private static final Logger logger = Logger.getLogger(ProgressBarInstallerListener.class.getName());

    public ProgressBarInstallerListener(InstallData installData, ProgressNotifiers notifiers) {
        super(installData, notifiers);
    }

    public void afterPacks(List<Pack> packs, ProgressListener listener) {
        ProgressNotifiers notifiers = this.getProgressNotifiers();
        int count = notifiers.getNotifiers();
        if (count > 0) {
            String progress = this.getMessage("CustomActions.progress");
            String tip = this.getMessage("CustomActions.tip");
            if ("CustomActions.tip".equals(tip) || "CustomActions.progress".equals(progress)) {
                logger.fine("No messages found for custom action progress bar interactions; skipped");
                return;
            }
            notifiers.setNotifyProgress(true);
            listener.restartAction("Configure", progress, tip, count);
        }
    }
}

