/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.event.AbstractUninstallerListener;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.event.AntAction;
import com.izforge.izpack.util.IoHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class AntActionUninstallerListener
extends AbstractUninstallerListener {
    private List<AntAction> befDel = new ArrayList<AntAction>();
    private List<AntAction> antActions = new ArrayList<AntAction>();

    public void initialise() {
        List allActions;
        String buildResource = this.getBuildResource();
        try {
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/antActions");
            if (in == null) {
                return;
            }
            ObjectInputStream objIn = new ObjectInputStream(in);
            allActions = (List)objIn.readObject();
            objIn.close();
            in.close();
        }
        catch (Exception exception) {
            throw new IzPackException((Throwable)exception);
        }
        for (AntAction action : allActions) {
            List<String> props;
            if (null != buildResource) {
                action.setBuildFile(new File(buildResource));
            }
            if (action.getUninstallOrder().equals("beforedeletion")) {
                this.befDel.add(action);
                continue;
            }
            if (null == buildResource) {
                File tmpFile;
                try {
                    tmpFile = IoHelper.copyToTempFile((File)action.getBuildFile(), (String)".xml");
                }
                catch (IOException exception) {
                    throw new IzPackException((Throwable)exception);
                }
                action.setBuildFile(tmpFile);
            }
            if ((props = action.getPropertyFiles()) != null) {
                ArrayList<String> newProps = new ArrayList<String>();
                for (String propName : props) {
                    try {
                        File propFile = IoHelper.copyToTempFile((String)propName, (String)".properties");
                        newProps.add(propFile.getCanonicalPath());
                    }
                    catch (IOException exception) {
                        throw new IzPackException((Throwable)exception);
                    }
                }
                action.setPropertyFiles(newProps);
            }
            this.antActions.add(action);
        }
    }

    public void beforeDelete(List<File> files, ProgressListener listener) throws InstallerException {
        for (AntAction act : this.befDel) {
            try {
                act.performUninstallAction();
            }
            catch (IzPackException e) {
                act.throwBuildException(e);
            }
        }
    }

    public void afterDelete(List<File> files, ProgressListener listener) throws InstallerException {
        for (AntAction act : this.antActions) {
            try {
                act.performUninstallAction();
            }
            catch (IzPackException e) {
                act.throwBuildException(e);
            }
        }
    }

    private String getBuildResource() {
        String buildResource = null;
        try {
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/build_resource");
            if (is != null) {
                ObjectInputStream ois = new ObjectInputStream(is);
                byte[] content = (byte[])ois.readObject();
                if (null != content) {
                    ByteArrayInputStream bin = new ByteArrayInputStream(content);
                    File buildFile = File.createTempFile("izpack_io", "xml");
                    buildFile.deleteOnExit();
                    IOUtils.copy((InputStream)bin, (OutputStream)new FileOutputStream(buildFile));
                    buildResource = buildFile.getAbsolutePath();
                }
                ois.close();
                is.close();
            }
        }
        catch (Exception exception) {
            throw new IzPackException((Throwable)exception);
        }
        return buildResource;
    }
}

