/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextArea;

public class MultiLineLabel
extends JTextArea {
    private static final long serialVersionUID = 4051045255031894837L;
    public static final int LEAST_ALLOWED = 200;
    private static final int FOUND = 0;
    private static final int NOT_FOUND = 1;
    private static final int NOT_DONE = 0;
    private static final int DONE = 1;
    private static final char[] WHITE_SPACE = new char[]{' ', '\n', '\t'};
    private static final char[] SPACES = new char[]{' ', '\t'};
    private static final char NEW_LINE = '\n';
    protected List<String> line = new ArrayList<String>();
    protected String labelText;
    protected int numLines;
    protected int lineHeight;
    protected int lineAscent;
    protected int lineDescent;
    protected int[] lineWidth;
    protected int maxWidth;
    private int maxAllowed = 200;
    private boolean maxAllowedSet = false;

    public MultiLineLabel(String label) {
        this.labelText = label;
    }

    int getPosition(String target, int start, char[] source, int mode) {
        int targetEnd = target.length() - 1;
        int sourceLength = source.length;
        int position = start;
        if (mode == 0) {
            boolean status = false;
            while (!status) {
                if (++position >= targetEnd) {
                    return targetEnd;
                }
                char temp = target.charAt(position);
                for (int scan = 0; scan < sourceLength; ++scan) {
                    if (source[scan] != temp) continue;
                    status = true;
                }
            }
            return position;
        }
        if (mode == 1) {
            boolean status = false;
            while (!status) {
                if (++position >= targetEnd) {
                    return targetEnd;
                }
                char temp = target.charAt(position);
                status = true;
                for (int scan = 0; scan < sourceLength; ++scan) {
                    if (source[scan] != temp) continue;
                    status = false;
                }
            }
            return position;
        }
        return 0;
    }

    private int breakWord(String word, FontMetrics fm) {
        int width = 0;
        int currentPos = 0;
        int endPos = word.length() - 1;
        if (endPos <= 0) {
            return currentPos;
        }
        while (width < this.maxAllowed && currentPos < endPos) {
            width = fm.stringWidth(this.labelText.substring(0, ++currentPos));
        }
        if (currentPos != endPos) {
            --currentPos;
        }
        return currentPos;
    }

    private void divideLabel() {
        int startPos;
        int currentPos;
        this.line.clear();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int lastPos = currentPos = (startPos = 0);
        int endPos = this.labelText.length() - 1;
        while (currentPos < endPos) {
            String s;
            int width = 0;
            while (width < this.maxAllowed && currentPos < endPos && this.labelText.charAt(currentPos) != '\n') {
                lastPos = currentPos;
                currentPos = this.getPosition(this.labelText, currentPos, WHITE_SPACE, 0);
                width = fontMetrics.stringWidth(this.labelText.substring(startPos, currentPos));
            }
            if (this.labelText.charAt(currentPos) == '\n') {
                lastPos = currentPos;
            }
            if (currentPos == endPos && width <= this.maxAllowed) {
                lastPos = currentPos;
                s = this.labelText.substring(startPos);
                this.line.add(s);
            } else {
                if (lastPos == startPos) {
                    lastPos = startPos + this.breakWord(this.labelText.substring(startPos, currentPos), fontMetrics);
                }
                s = this.labelText.substring(startPos, lastPos);
                this.line.add(s);
            }
            currentPos = startPos = this.getPosition(this.labelText, lastPos, SPACES, 1);
        }
        this.numLines = this.line.size();
        this.lineWidth = new int[this.numLines];
    }

    protected void measure() {
        if (!this.maxAllowedSet) {
            this.maxAllowed = this.getParent().getSize().width;
        }
        if (this.maxAllowed < 20) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return;
        }
        this.divideLabel();
        this.lineHeight = fontMetrics.getHeight();
        this.lineDescent = fontMetrics.getDescent();
        this.maxWidth = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.numLines; ++i) {
            if (i != 0) {
                sb.append('\n');
            }
            sb.append(this.line.get(i));
            this.lineWidth[i] = fontMetrics.stringWidth(this.line.get(i));
            if (this.lineWidth[i] <= this.maxWidth) continue;
            this.maxWidth = this.lineWidth[i];
        }
        super.setText(sb.toString());
        this.setEditable(false);
        this.setOpaque(false);
    }

    @Override
    public void setText(String labelText) {
        this.labelText = labelText;
        this.repaint();
    }

    public void setMaxWidth(int width) {
        this.maxAllowed = width;
        this.maxAllowedSet = true;
        this.repaint();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.maxAllowed = width;
        this.maxAllowedSet = true;
    }

    @Override
    public Dimension getPreferredSize() {
        this.measure();
        Insets margin = this.getMargin();
        return new Dimension(this.maxAllowed, this.numLines * (this.lineHeight + this.lineAscent + this.lineDescent) + margin.top + margin.bottom);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

