/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.language;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.exception.ResourceException;
import com.izforge.izpack.api.resource.Locales;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.container.provider.AbstractInstallDataProvider;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.language.Languages;
import com.izforge.izpack.installer.requirement.RequirementsChecker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class LanguageDialog
extends JDialog {
    private static final long serialVersionUID = 3256443616359887667L;
    private final JFrame frame;
    private final GUIInstallData installData;
    private final Resources resources;
    private final Locales locales;
    private final RequirementsChecker requirements;
    private Map<String, String> displayNames = new HashMap<String, String>();
    private JComboBox comboBox;
    private static final Logger logger = Logger.getLogger(LanguageDialog.class.getName());

    public LanguageDialog(JFrame frame, Resources resources, Locales locales, GUIInstallData installData, RequirementsChecker requirements) {
        super(frame);
        this.frame = frame;
        this.resources = resources;
        this.locales = locales;
        this.installData = installData;
        this.requirements = requirements;
        this.setName(GuiId.DIALOG_PICKER.id);
        this.initialise();
    }

    public void initLangPack() throws Exception {
        switch (this.locales.getLocales().size()) {
            case 0: {
                break;
            }
            case 1: {
                String codeOfUniqueLanguage = this.displayNames.keySet().iterator().next();
                this.propagateLocale(codeOfUniqueLanguage);
                break;
            }
            default: {
                this.frame.setVisible(false);
                this.setVisible(true);
            }
        }
        if (!this.requirements.check()) {
            logger.info("Not all installer requirements are fulfilled.");
            System.exit(-1);
        }
    }

    private void initialise() {
        JPanel contentPane = (JPanel)this.getContentPane();
        Languages languages = new Languages(this.locales, this.installData, contentPane.getFont());
        this.addWindowListener(new WindowHandler());
        this.setTitle("Language Selection");
        GridBagLayout layout = new GridBagLayout();
        contentPane.setLayout(layout);
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 10;
        gbConstraints.insets = new Insets(5, 5, 5, 5);
        gbConstraints.fill = 2;
        gbConstraints.gridx = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.ipadx = 0;
        gbConstraints.ipady = 6;
        ImageIcon img = this.getImage();
        JLabel imgLabel = new JLabel(img);
        gbConstraints.gridy = 0;
        contentPane.add(imgLabel);
        String firstMessage = "Please select your language";
        if (languages.getDisplayType() == Languages.DisplayType.ISO3) {
            firstMessage = "Please select your language below";
        }
        JLabel label1 = new JLabel(firstMessage, 10);
        gbConstraints.gridy = 1;
        gbConstraints.insets = new Insets(15, 5, 5, 5);
        layout.addLayoutComponent(label1, gbConstraints);
        contentPane.add(label1);
        gbConstraints.insets = new Insets(5, 5, 5, 5);
        this.displayNames = languages.getDisplayNames();
        this.comboBox = new JComboBox<Object>(this.displayNames.keySet().toArray());
        this.comboBox.setName(GuiId.COMBO_BOX_LANG_FLAG.id);
        if (this.useFlags()) {
            this.comboBox.setRenderer(new FlagRenderer());
        } else {
            this.comboBox.setRenderer(new LanguageRenderer());
        }
        gbConstraints.gridy = 3;
        layout.addLayoutComponent(this.comboBox, gbConstraints);
        contentPane.add(this.comboBox);
        gbConstraints.insets = new Insets(15, 5, 15, 5);
        JButton okButton = new JButton("OK");
        okButton.setName(GuiId.BUTTON_LANG_OK.id);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LanguageDialog.this.onOK();
            }
        });
        gbConstraints.fill = 0;
        gbConstraints.gridy = 4;
        gbConstraints.anchor = 10;
        layout.addLayoutComponent(okButton, gbConstraints);
        contentPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        if (System.getProperty("mrj.version") == null) {
            this.pack();
        }
        this.setSize(this.getPreferredSize());
        Dimension frameSize = this.getSize();
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.setLocation(center.x - frameSize.width / 2, center.y - frameSize.height / 2 - 10);
        this.setResizable(true);
        this.comboBox.setSelectedItem(Locale.getDefault().getISO3Language().toLowerCase());
        this.setModal(true);
        this.toFront();
    }

    private ImageIcon getImage() {
        ImageIcon img;
        try {
            img = this.resources.getImageIcon("installer.langsel.img", new String[0]);
        }
        catch (Exception err) {
            img = null;
        }
        return img;
    }

    private void onOK() {
        String selectedPack = (String)this.comboBox.getSelectedItem();
        if (selectedPack == null) {
            throw new RuntimeException("installation canceled");
        }
        this.propagateLocale(selectedPack);
        this.dispose();
    }

    private boolean useFlags() {
        return !this.installData.guiPrefs.modifier.containsKey("useFlags") || !"no".equalsIgnoreCase((String)this.installData.guiPrefs.modifier.get("useFlags"));
    }

    private void propagateLocale(String code) {
        try {
            this.locales.setLocale(code);
            Locale newLocale = this.locales.getLocale();
            Locale.setDefault(newLocale);
            JComponent.setDefaultLocale(newLocale);
            SwingUtilities.updateComponentTreeUI(this);
            this.installData.setLocale(this.locales.getLocale(), this.locales.getISOCode());
            this.installData.setMessages(this.locales.getMessages());
            AbstractInstallDataProvider.addCustomLangpack(this.installData, this.locales);
            this.installData.configureGuiButtons();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private class FlagRenderer
    extends LanguageRenderer {
        private TreeMap<String, ImageIcon> icons;
        private TreeMap<String, ImageIcon> grayIcons;

        public FlagRenderer() {
            this.icons = new TreeMap();
            this.grayIcons = new TreeMap();
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            String code = (String)value;
            if (!this.icons.containsKey(code)) {
                try {
                    ImageIcon icon = LanguageDialog.this.resources.getImageIcon("flag." + code, new String[0]);
                    this.icons.put(code, icon);
                    icon = new ImageIcon(GrayFilter.createDisabledImage(icon.getImage()));
                    this.grayIcons.put(code, icon);
                }
                catch (ResourceException exception) {
                    logger.log(Level.WARNING, exception.getMessage(), exception);
                }
            }
            if (isSelected || index == -1) {
                this.setIcon(this.icons.get(code));
            } else {
                this.setIcon(this.grayIcons.get(code));
            }
            return result;
        }
    }

    private class LanguageRenderer
    extends JLabel
    implements ListCellRenderer {
        private LanguageRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String code = (String)value;
            this.setText((String)LanguageDialog.this.displayNames.get(code));
            if (isSelected) {
                this.setForeground(list.getSelectionForeground());
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setForeground(list.getForeground());
                this.setBackground(list.getBackground());
            }
            return this;
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }
}

