/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.panel;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLWriter;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.panel.AbstractPanelView;
import com.izforge.izpack.installer.panel.PanelViews;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractPanels<T extends AbstractPanelView<V>, V>
implements PanelViews<T, V> {
    private final List<Panel> panels = new ArrayList<Panel>();
    private final List<T> panelViews;
    private final InstallData installData;
    private final Variables variables;
    private int index = -1;
    private boolean nextEnabled;
    private boolean previousEnabled;
    private static final Logger logger = Logger.getLogger(AbstractPanels.class.getName());

    public AbstractPanels(List<T> panels, InstallData installData) {
        this.panelViews = panels;
        this.installData = installData;
        this.variables = installData.getVariables();
        this.nextEnabled = !panels.isEmpty();
        int index = 0;
        for (AbstractPanelView panelView : panels) {
            panelView.setIndex(index++);
            this.panels.add(panelView.getPanel());
        }
    }

    @Override
    public List<Panel> getPanels() {
        return this.panels;
    }

    @Override
    public Panel getPanel() {
        return this.index >= 0 && this.index < this.panels.size() ? this.panels.get(this.index) : null;
    }

    @Override
    public List<T> getPanelViews() {
        return this.panelViews;
    }

    @Override
    public V getView() {
        T panelView = this.getPanelView();
        return panelView != null ? (V)((AbstractPanelView)panelView).getView() : null;
    }

    @Override
    public T getPanelView() {
        return this.getPanelView(this.index);
    }

    @Override
    public boolean isValid() {
        T panel = this.getPanelView();
        return panel == null || this.executeValidationActions(panel, true);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean hasNext() {
        return this.getNext(this.index, false) != -1;
    }

    @Override
    public void setNextEnabled(boolean enable) {
        this.nextEnabled = enable;
    }

    @Override
    public boolean isNextEnabled() {
        return this.nextEnabled && this.hasNext();
    }

    @Override
    public boolean next() {
        return this.next(true);
    }

    @Override
    public boolean next(boolean validate) {
        int newIndex;
        boolean result = false;
        if (this.isValid() && (newIndex = this.getNext(this.index, false)) != -1) {
            result = this.switchPanel(newIndex, validate);
        }
        return result;
    }

    @Override
    public void setPreviousEnabled(boolean enable) {
        this.previousEnabled = enable;
    }

    @Override
    public boolean isPreviousEnabled() {
        return this.previousEnabled && this.hasPrevious();
    }

    @Override
    public boolean hasPrevious() {
        return this.getPrevious(this.index, false) != -1;
    }

    @Override
    public boolean previous() {
        return this.previous(this.index);
    }

    @Override
    public boolean previous(int index) {
        int newIndex;
        boolean result = false;
        if (this.isPreviousEnabled() && (newIndex = this.getPrevious(index, true)) != -1) {
            result = this.switchPanel(newIndex, false);
        }
        return result;
    }

    @Override
    public int getNext(int index, boolean visibleOnly) {
        int result = -1;
        List<T> panels = this.getPanelViews();
        for (int i = index + 1; i < panels.size(); ++i) {
            if (!this.canShow((AbstractPanelView)panels.get(i), visibleOnly)) continue;
            result = i;
            break;
        }
        return result;
    }

    @Override
    public int getNext(boolean visibleOnly) {
        return this.getNext(this.index, visibleOnly);
    }

    @Override
    public int getPrevious(int index, boolean visibleOnly) {
        int result = -1;
        for (int i = index - 1; i >= 0; --i) {
            if (!this.canShow(this.getPanelView(i), visibleOnly)) continue;
            result = i;
            break;
        }
        return result;
    }

    @Override
    public int getPrevious(boolean visibleOnly) {
        return this.getPrevious(this.index, visibleOnly);
    }

    @Override
    public int getVisibleIndex(T panel) {
        int result = -1;
        if (((AbstractPanelView)panel).isVisible()) {
            for (int i = 0; i <= ((AbstractPanelView)panel).getIndex() && i < this.panelViews.size(); ++i) {
                if (!((AbstractPanelView)this.panelViews.get(i)).isVisible()) continue;
                ++result;
            }
        }
        return result;
    }

    @Override
    public int getVisible() {
        int result = 0;
        for (AbstractPanelView panelView : this.panelViews) {
            if (!panelView.isVisible()) continue;
            ++result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeInstallationRecord(File file, UninstallData uninstallData) throws Exception {
        FileOutputStream out = new FileOutputStream(file);
        BufferedOutputStream outBuff = new BufferedOutputStream(out);
        try {
            XMLWriter writer = new XMLWriter((OutputStream)out);
            IXMLElement panelsRoot = this.installData.getInstallationRecord();
            for (AbstractPanelView panelView : this.panelViews) {
                Panel panel = panelView.getPanel();
                if (!panel.isVisited()) continue;
                IXMLElement panelRoot = panelView.createPanelRootRecord();
                panelView.createInstallationRecord(panelRoot);
                panelsRoot.addChild(panelRoot);
            }
            writer.write(panelsRoot);
        }
        finally {
            outBuff.close();
            if (file.getAbsolutePath().startsWith(this.installData.getInstallPath())) {
                uninstallData.addFile(file.getAbsolutePath(), true);
            }
        }
    }

    public boolean switchPanel(int newIndex, boolean validate) {
        boolean result;
        T panel = this.getPanelView();
        if (panel != null) {
            ((AbstractPanelView)panel).saveData();
        }
        if (newIndex > this.index && !this.isNextEnabled()) {
            return false;
        }
        this.variables.refresh();
        T oldPanelView = this.getPanelView(this.index);
        T newPanelView = this.getPanelView(newIndex);
        int oldIndex = this.index;
        this.index = newIndex;
        Panel newPanel = ((AbstractPanelView)newPanelView).getPanel();
        newPanel.setVisited(true);
        if (this.switchPanel(newPanelView, oldPanelView)) {
            if (oldIndex > newIndex) {
                for (int i = this.panelViews.size() - 1; i > this.index; --i) {
                    AbstractPanelView futurePanelView = (AbstractPanelView)this.panelViews.get(i);
                    Panel futurePanel = futurePanelView.getPanel();
                    futurePanel.setVisited(false);
                    Set blockedNames = futurePanel.getAffectedVariableNames();
                    this.variables.unregisterBlockedVariableNames(futurePanel.getAffectedVariableNames(), (Object)futurePanel);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Unblocked variables on panel '" + futurePanel.getPanelId() + "': " + this.createListAsString(blockedNames));
                }
            } else {
                Set blockedNames = newPanel.getAffectedVariableNames();
                this.variables.registerBlockedVariableNames(blockedNames, (Object)newPanel);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Blocked variables on panel '" + newPanel.getPanelId() + "': " + this.createListAsString(blockedNames));
                }
            }
            logger.fine("Switched panel index: " + oldIndex + " -> " + this.index);
            result = true;
        } else {
            this.index = oldIndex;
            result = false;
            newPanel.setVisited(false);
        }
        this.variables.refresh();
        return result;
    }

    private String createListAsString(Set<String> list) {
        StringBuffer msg = new StringBuffer("{");
        if (list != null) {
            Iterator<String> it = list.iterator();
            while (it.hasNext()) {
                if (!logger.isLoggable(Level.FINE)) continue;
                msg.append(it.next());
                if (!it.hasNext()) continue;
                msg.append(", ");
            }
        }
        msg.append("}");
        return msg.toString();
    }

    protected abstract boolean switchPanel(T var1, T var2);

    protected boolean executeValidationActions(T panel, boolean validate) {
        boolean result;
        if (validate) {
            result = ((AbstractPanelView)panel).isValid();
        } else {
            this.variables.refresh();
            ((AbstractPanelView)panel).executePreValidationActions();
            ((AbstractPanelView)panel).executePostValidationActions();
            ((AbstractPanelView)panel).saveData();
            result = true;
        }
        return result;
    }

    private T getPanelView(int index) {
        List<T> panels = this.getPanelViews();
        return (T)(index >= 0 && index < panels.size() ? (AbstractPanelView)panels.get(index) : null);
    }

    private boolean canShow(T panel, boolean visibleOnly) {
        return (!visibleOnly || ((AbstractPanelView)panel).isVisible()) && ((AbstractPanelView)panel).canShow();
    }
}

