/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.container.provider;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLParser;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.installer.gui.InstallerFrame;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.picocontainer.injectors.Provider;

public class IconsProvider
implements Provider {
    private static final Logger logger = Logger.getLogger(IconsProvider.class.getName());
    private static final String CUSTOM_ICONS_RESOURCEFILE = "customicons.xml";

    public IconsDatabase provide(Resources resources) throws Exception {
        IconsDatabase icons = new IconsDatabase();
        this.loadIcons(icons);
        this.loadCustomIcons(icons, resources);
        return icons;
    }

    private void loadIcons(IconsDatabase iconsDatabase) throws Exception {
        InputStream inXML = this.getClass().getResourceAsStream("icons.xml");
        this.parseXML(inXML, iconsDatabase);
    }

    private void loadCustomIcons(IconsDatabase icons, Resources resources) throws Exception {
        InputStream inXML = null;
        try {
            inXML = resources.getInputStream(CUSTOM_ICONS_RESOURCEFILE);
        }
        catch (Throwable exception) {
            logger.warning("Resource customicons.xml not defined. No custom icons available");
            return;
        }
        logger.fine("Custom icons available");
        this.parseXML(inXML, icons);
    }

    private void parseXML(InputStream inXML, IconsDatabase icons) {
        ImageIcon img;
        XMLParser parser = new XMLParser();
        IXMLElement data = parser.parse(inXML);
        for (IXMLElement icon : data.getChildrenNamed("icon")) {
            img = this.loadIcon(icon);
            if (img == null) continue;
            icons.put((Object)icon.getAttribute("id"), (Object)img);
        }
        for (IXMLElement icon : data.getChildrenNamed("sysicon")) {
            img = this.loadIcon(icon);
            if (img == null) continue;
            UIManager.put(icon.getAttribute("id"), img);
        }
    }

    private ImageIcon loadIcon(IXMLElement icon) {
        ImageIcon img = null;
        String id = icon.getAttribute("id");
        String path = icon.getAttribute("res");
        URL url = InstallerFrame.class.getResource(path);
        if (url == null) {
            logger.warning("Icon with id '" + id + "': file '" + path + "' not found");
        } else {
            img = new ImageIcon(url);
            logger.fine("Icon with id '" + id + "' found");
        }
        return img;
    }
}

