/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.console;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.util.Console;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public abstract class AbstractTextConsolePanel
extends AbstractConsolePanel {
    private static final Logger logger = Logger.getLogger(AbstractTextConsolePanel.class.getName());

    public AbstractTextConsolePanel(PanelView<ConsolePanel> panel) {
        super(panel);
    }

    @Override
    public boolean run(InstallData installData, Properties properties) {
        return true;
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        String text = this.getText();
        text = installData.getVariables().replace(text);
        if (text != null) {
            try {
                console.paginate(text);
            }
            catch (IOException e) {
                logger.warning("Text pagination failed: " + e.getMessage());
            }
        } else {
            logger.warning("No text to display");
        }
        return this.promptEndPanel(installData, console);
    }

    protected abstract String getText();

    protected String removeHTML(String text) {
        String result = "";
        if (text != null) {
            result = text.replaceAll("\r", " ");
            result = result.replaceAll("\t", "");
            result = result.replaceAll("( )+", " ");
            result = result.replaceAll("<( )*head([^>])*>", "<head>");
            result = result.replaceAll("(<( )*(/)( )*head( )*>)", "</head>");
            result = result.replaceAll("(<head>).*(</head>)", "");
            result = result.replaceAll("<( )*script([^>])*>", "<script>");
            result = result.replaceAll("(<( )*(/)( )*script( )*>)", "</script>");
            result = result.replaceAll("(<script>).*(</script>)", "");
            result = result.replaceAll("<( )*style([^>])*>", "<style>");
            result = result.replaceAll("(<( )*(/)( )*style( )*>)", "</style>");
            result = result.replaceAll("(<style>).*(</style>)", "");
            result = result.replaceAll("(<( )*(/)( )*sup( )*>)", "</sup>");
            result = result.replaceAll("<( )*sup([^>])*>", "<sup>");
            result = result.replaceAll("(<sup>).*(</sup>)", "");
            result = result.replaceAll("<( )*td([^>])*>", "\t");
            result = result.replaceAll("<( )*br( )*>", "\r");
            result = result.replaceAll("<( )*li( )*>", "\r");
            result = result.replaceAll("<( )*div([^>])*>", "\r\r");
            result = result.replaceAll("<( )*tr([^>])*>", "\r\r");
            result = result.replaceAll("(<) h (\\w+) >", "\r");
            result = result.replaceAll("(\\b) (</) h (\\w+) (>) (\\b)", "");
            result = result.replaceAll("<( )*p([^>])*>", "\r\r");
            result = result.replaceAll("<[^>]*>", "");
            result = result.replaceAll("&bull;", " * ");
            result = result.replaceAll("&lsaquo;", "<");
            result = result.replaceAll("&rsaquo;", ">");
            result = result.replaceAll("&trade;", "(tm)");
            result = result.replaceAll("&frasl;", "/");
            result = result.replaceAll("&lt;", "<");
            result = result.replaceAll("&gt;", ">");
            result = result.replaceAll("&copy;", "(c)");
            result = result.replaceAll("&reg;", "(r)");
            result = result.replaceAll("&(.{2,6});", "");
            result = result.replaceAll("(\r)( )+(\r)", "\r\r");
            result = result.replaceAll("(\t)( )+(\t)", "\t\t");
            result = result.replaceAll("(\t)( )+(\r)", "\t\r");
            result = result.replaceAll("(\r)( )+(\t)", "\r\t");
            result = result.replaceAll("(\r)(\t)+(\\r)", "\r\r");
            result = result.replaceAll("(\r)(\t)+", "\r\t");
        }
        return result;
    }
}

