/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.automation;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.installer.automation.AutomatedPanelView;
import com.izforge.izpack.installer.automation.PanelAutomation;
import com.izforge.izpack.installer.panel.AbstractPanels;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AutomatedPanels
extends AbstractPanels<AutomatedPanelView, PanelAutomation> {
    private final AutomatedInstallData installData;
    private static final Logger logger = Logger.getLogger(AutomatedPanels.class.getName());

    public AutomatedPanels(List<AutomatedPanelView> panels, AutomatedInstallData installData) {
        super(panels, (InstallData)installData);
        this.installData = installData;
    }

    @Override
    protected boolean switchPanel(AutomatedPanelView newPanel, AutomatedPanelView oldPanel) {
        boolean result;
        if (newPanel.getViewClass() == null) {
            logger.warning("AutomationHelper class not found for panel class: " + newPanel.getPanel().getClassName());
            result = this.executeValidationActions(newPanel, true);
        } else {
            PanelAutomation view = (PanelAutomation)newPanel.getView();
            newPanel.executePreActivationActions();
            IXMLElement xml = this.installData.getInstallationRecordPanelRoot(newPanel.getPanelId());
            if (xml != null) {
                view.runAutomated((InstallData)this.installData, xml);
                result = this.executeValidationActions(newPanel, true);
            } else {
                logger.log(Level.SEVERE, "No configuration for panel: " + newPanel.getPanel().getPanelId());
                result = false;
            }
        }
        return result;
    }
}

