/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.bootstrap;

import com.izforge.izpack.api.container.Container;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.installer.console.ConsoleInstaller;
import com.izforge.izpack.installer.container.impl.ConsoleInstallerContainer;
import com.izforge.izpack.installer.language.LanguageConsoleDialog;
import com.izforge.izpack.installer.requirement.RequirementsChecker;
import com.izforge.izpack.util.Housekeeper;
import java.util.logging.Logger;

public class InstallerConsole {
    private static final Logger logger = Logger.getLogger(InstallerConsole.class.getName());

    public static void run(int type, int consoleAction, String path, String langCode, String mediaPath, String[] args) {
        ConsoleInstallerContainer applicationComponent = new ConsoleInstallerContainer();
        Container installerContainer = (Container)applicationComponent.getComponent(Container.class);
        try {
            if (mediaPath != null) {
                InstallData installData = (InstallData)applicationComponent.getComponent(InstallData.class);
                installData.setMediaPath(mediaPath);
            }
            ConsoleInstaller consoleInstaller = (ConsoleInstaller)installerContainer.getComponent(ConsoleInstaller.class);
            if (langCode == null) {
                ((LanguageConsoleDialog)installerContainer.getComponent(LanguageConsoleDialog.class)).initLangPack();
            } else {
                ((LanguageConsoleDialog)installerContainer.getComponent(LanguageConsoleDialog.class)).propagateLocale(langCode);
            }
            if (!((RequirementsChecker)installerContainer.getComponent(RequirementsChecker.class)).check()) {
                logger.info("Not all installer requirements are fulfilled.");
                ((Housekeeper)installerContainer.getComponent(Housekeeper.class)).shutDown(-1);
            }
            consoleInstaller.run(consoleAction, path, args);
        }
        catch (Exception e) {
            throw new IzPackException((Throwable)e);
        }
    }
}

