/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.installer.unpacker.Cancellable;
import com.izforge.izpack.installer.unpacker.FileUnpacker;
import com.izforge.izpack.installer.unpacker.PackResources;
import com.izforge.izpack.util.os.FileQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import org.apache.commons.io.IOUtils;

class Pack200FileUnpacker
extends FileUnpacker {
    private final PackResources resources;
    private final Pack200.Unpacker unpacker;

    public Pack200FileUnpacker(Cancellable cancellable, PackResources resources, Pack200.Unpacker unpacker, FileQueue queue) {
        super(cancellable, queue);
        this.resources = resources;
        this.unpacker = unpacker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpack(PackFile file, ObjectInputStream packInputStream, File target) throws IOException, InstallerException {
        int key = packInputStream.readInt();
        InputStream in = null;
        OutputStream out = null;
        JarOutputStream jarOut = null;
        try {
            in = this.resources.getInputStream("packs/pack200-" + key);
            out = this.getTarget(file, target);
            jarOut = new JarOutputStream(out);
            this.unpacker.unpack(in, jarOut);
            jarOut.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(jarOut);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((OutputStream)jarOut);
        this.postCopy(file);
    }
}

