/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.gui;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Locales;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.core.resource.ResourceManager;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.EtchedLineBorder;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.base.InstallerBase;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.installer.debugger.Debugger;
import com.izforge.izpack.installer.gui.DefaultNavigator;
import com.izforge.izpack.installer.gui.GUIListener;
import com.izforge.izpack.installer.gui.InstallerView;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.installer.gui.IzPanelView;
import com.izforge.izpack.installer.gui.IzPanels;
import com.izforge.izpack.installer.gui.IzPanelsListener;
import com.izforge.izpack.installer.gui.Navigator;
import com.izforge.izpack.installer.gui.WindowHandler;
import com.izforge.izpack.installer.unpacker.IUnpacker;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;

public class InstallerFrame
extends JFrame
implements InstallerBase,
InstallerView {
    private static final long serialVersionUID = 3257852069162727473L;
    private static final transient Logger logger = Logger.getLogger(InstallerFrame.class.getName());
    private static final String ICON_RESOURCE = "Installer.image";
    private static final String ICON_RESOURCE_EXT_VARIABLE_NAME = "installerimage.ext";
    private static final String HEADING_ICON_RESOURCE = "Heading.image";
    private GUIInstallData installdata;
    private IconsDatabase icons;
    protected JPanel panelsContainer;
    protected JPanel contentPane;
    protected JButton helpButton = null;
    private final DefaultNavigator navigator;
    protected ArrayList<GUIListener> guiListener = new ArrayList();
    protected JLabel[] headingLabels;
    protected JPanel headingPanel;
    protected JComponent headingCounterComponent;
    private JLabel iconLabel;
    private int interruptCount = 1;
    private static final int MAX_INTERRUPT = 3;
    protected RulesEngine rules;
    private Debugger debugger;
    private boolean imageLeft = false;
    private final IzPanels panels;
    private ResourceManager resourceManager;
    private UninstallDataWriter uninstallDataWriter;
    private Variables variables;
    private UninstallData uninstallData;
    private IUnpacker unpacker;
    private final Housekeeper housekeeper;
    private final Log log;
    private Locales locales;
    private Object usualFTP = null;
    private Object blockFTP = null;

    public InstallerFrame(GUIInstallData installData, RulesEngine rules, IconsDatabase icons, IzPanels panels, UninstallDataWriter uninstallDataWriter, ResourceManager resourceManager, UninstallData uninstallData, Housekeeper housekeeper, DefaultNavigator navigator, Log log, Locales locales) {
        this.installdata = installData;
        this.rules = rules;
        this.resourceManager = resourceManager;
        this.uninstallDataWriter = uninstallDataWriter;
        this.uninstallData = uninstallData;
        this.panels = panels;
        this.variables = installData.getVariables();
        this.housekeeper = housekeeper;
        this.log = log;
        this.locales = locales;
        this.setIcons(icons);
        this.navigator = navigator;
        navigator.setInstallerFrame(this);
        this.addWindowListener(new WindowHandler(navigator));
    }

    public void setUnpacker(IUnpacker unpacker) {
        this.unpacker = unpacker;
    }

    @Override
    public void sizeFrame() {
        this.pack();
        this.setSize(this.installdata.guiPrefs.width, this.installdata.guiPrefs.height);
        this.setPreferredSize(new Dimension(this.installdata.guiPrefs.width, this.installdata.guiPrefs.height));
        this.setResizable(this.installdata.guiPrefs.resizable);
        this.centerFrame(this);
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public void buildGUI() {
        ImageIcon icon;
        this.setDefaultCloseOperation(0);
        ImageIcon jframeIcon = (ImageIcon)this.getIcons().get((Object)"JFrameIcon");
        this.setIconImage(jframeIcon.getImage());
        JPanel glassPane = (JPanel)this.getGlassPane();
        glassPane.addMouseListener(new MouseAdapter(){});
        glassPane.addMouseMotionListener(new MouseMotionAdapter(){});
        glassPane.addKeyListener(new KeyAdapter(){});
        glassPane.addFocusListener(new FocusAdapter(){});
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.panelsContainer = new JPanel();
        this.panelsContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.panelsContainer.setLayout(new GridLayout(1, 1));
        this.contentPane.add((Component)this.panelsContainer, "Center");
        logger.fine("Building GUI. The panel list to display is " + this.installdata.getPanels());
        Messages messages = this.locales.getMessages();
        this.navigator.updateButtonText(messages);
        JPanel navPanel = new JPanel();
        navPanel.setLayout(new BoxLayout(navPanel, 0));
        TitledBorder border = BorderFactory.createTitledBorder((Border)new EtchedLineBorder(), messages.get("installer.madewith", new Object[0]) + " ", 0, 0, new Font("Dialog", 0, 10));
        navPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), border));
        this.helpButton = ButtonFactory.createButton((String)messages.get("installer.help", new Object[0]), (Icon)((Icon)this.getIcons().get((Object)"help")), (Color)this.installdata.buttonsHColor);
        navPanel.add(this.helpButton);
        this.helpButton.setName(GuiId.BUTTON_HELP.id);
        this.helpButton.addActionListener(new HelpHandler());
        ButtonFactory.clearAllMnemonics();
        ButtonFactory.reserveButtonMnemonics((JButton[])new JButton[]{this.helpButton});
        this.navigator.reserveNavigatorButtonMnemonics();
        navPanel.add(Box.createHorizontalGlue());
        navPanel.add(this.navigator.getPrevious());
        navPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        navPanel.add(this.navigator.getNext());
        navPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        navPanel.add(this.navigator.getQuit());
        this.contentPane.add((Component)navPanel, "South");
        if (Debug.isTRACE()) {
            this.debugger = new Debugger(this.installdata, this.getIcons(), this.rules);
            JPanel debugpanel = this.debugger.getDebugPanel();
            if (this.installdata.guiPrefs.modifier.containsKey("showDebugWindow") && Boolean.valueOf((String)this.installdata.guiPrefs.modifier.get("showDebugWindow")).booleanValue()) {
                JFrame debugframe = new JFrame("Debug information");
                debugframe.setContentPane(debugpanel);
                debugframe.setSize(new Dimension(400, 400));
                debugframe.setVisible(true);
            } else {
                debugpanel.setPreferredSize(new Dimension(200, 400));
                this.contentPane.add((Component)debugpanel, "East");
            }
        }
        if ((icon = this.loadIcon(ICON_RESOURCE, "0")) != null) {
            JPanel imgPanel = new JPanel();
            imgPanel.setLayout(new BorderLayout());
            imgPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
            this.iconLabel = new JLabel(icon);
            this.iconLabel.setBorder(BorderFactory.createLoweredBevelBorder());
            imgPanel.add((Component)this.iconLabel, "North");
            this.contentPane.add((Component)imgPanel, "West");
            this.loadAndShowImageForPanelNum(this.iconLabel, 0);
        }
        this.getRootPane().setDefaultButton(this.navigator.setDefaultButton());
        this.callGUIListener(0, navPanel);
        this.createHeading(navPanel);
        this.panels.initialise();
        this.panels.setListener(new IzPanelsListener(){

            @Override
            public void switchPanel(IzPanelView newPanel, IzPanelView oldPanel) {
                InstallerFrame.this.switchPanel(newPanel, oldPanel);
            }
        });
    }

    public Navigator getNavigator() {
        return this.navigator;
    }

    private void callGUIListener(int what) {
        this.callGUIListener(what, null);
    }

    private void callGUIListener(int what, JPanel param) {
        for (GUIListener aGuiListener : this.guiListener) {
            aGuiListener.guiActionPerformed(what, param);
        }
    }

    private ImageIcon loadIcon(String resPrefix, String panelid) {
        ImageIcon icon = null;
        String ext = this.getIconResourceNameExtension();
        try {
            icon = this.resourceManager.getImageIcon(resPrefix, new String[]{resPrefix + "." + panelid + ext});
        }
        catch (ResourceNotFoundException exception) {
            logger.fine("No icon for panel=" + panelid + ": " + exception.getMessage());
        }
        return icon;
    }

    private String getIconResourceNameExtension() {
        try {
            String iconext = this.installdata.getVariable(ICON_RESOURCE_EXT_VARIABLE_NAME);
            if (iconext == null) {
                iconext = "";
            } else if (iconext.length() > 0 && iconext.charAt(0) != '.') {
                iconext = "." + iconext;
            }
            iconext = iconext.trim();
            return iconext;
        }
        catch (Exception e) {
            return "";
        }
    }

    private void loadAndShowImageForPanelNum(JLabel jLabel, int panelNo) {
        this.loadAndShowImage(jLabel, ICON_RESOURCE, panelNo);
    }

    private void loadAndShowImageForPanelOrId(JLabel jLabel, int panelNo, String panelId) {
        this.loadAndShowImage(jLabel, ICON_RESOURCE, panelNo, panelId);
    }

    private void loadAndShowImage(JLabel jLabel, String resPrefix, int panelNo, String panelId) {
        ImageIcon icon = this.loadIcon(resPrefix, panelId);
        if (icon == null) {
            icon = this.loadIcon(resPrefix, panelNo + "");
        }
        jLabel.setVisible(false);
        jLabel.setIcon(icon);
        jLabel.setVisible(true);
    }

    private void loadAndShowImage(JLabel jLabel, String resPrefix, int panelNo) {
        ImageIcon icon = this.loadIcon(resPrefix, panelNo + "");
        if (icon == null) {
            icon = this.loadIcon(resPrefix, panelNo + "");
        }
        if (icon != null) {
            jLabel.setVisible(false);
            jLabel.setIcon(icon);
            jLabel.setVisible(true);
        }
    }

    protected void switchPanel(IzPanelView newPanel, IzPanelView oldPanel) {
        int oldIndex = oldPanel != null ? oldPanel.getIndex() : -1;
        logger.fine("Switching panel, old index is " + oldIndex);
        try {
            this.panelsContainer.setVisible(false);
            IzPanel newView = (IzPanel)newPanel.getView();
            this.showHelpButton(newView.canShowHelp());
            if (Debug.isTRACE()) {
                Panel panel = oldPanel != null ? oldPanel.getPanel() : null;
                this.debugger.switchPanel(newPanel.getPanel(), panel);
            }
            String oldPanelClass = oldPanel != null ? oldPanel.getClass().getName() : null;
            this.log.addDebugMessage("InstallerFrame.switchPanel: try switching newPanel from {0} to {1} ({2} to {3})", new String[]{oldPanelClass, newPanel.getClass().getName(), Integer.toString(oldIndex), Integer.toString(newPanel.getIndex())}, "PanelTrace", null);
            if (oldPanel != null) {
                IzPanel oldView = (IzPanel)oldPanel.getView();
                this.panelsContainer.remove(oldView);
                oldView.panelDeactivate();
            }
            this.panelsContainer.add(newView);
            if (newView.getInitialFocus() != null) {
                JTextComponent inText;
                final Component inFoc = newView.getInitialFocus();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        inFoc.requestFocusInWindow();
                    }
                });
                if (inFoc instanceof JTextComponent && (inText = (JTextComponent)inFoc).isEditable() && inText.getDocument() != null) {
                    inText.setCaretPosition(inText.getDocument().getLength());
                }
            }
            this.performHeading(newPanel);
            this.performHeadingCounter(newPanel);
            newPanel.executePreActivationActions();
            Panel panel = newPanel.getPanel();
            String readonlyCondition = panel.getReadonlyCondition();
            String displayHiddenCondition = panel.getDisplayHiddenCondition();
            newView.panelActivate();
            this.panelsContainer.setVisible(true);
            if (this.iconLabel != null) {
                if (!"UNKNOWN".equals(newPanel.getPanelId())) {
                    this.loadAndShowImageForPanelOrId(this.iconLabel, this.panels.getVisibleIndex(newPanel), newPanel.getPanelId());
                } else {
                    this.loadAndShowImageForPanelNum(this.iconLabel, this.panels.getVisibleIndex(newPanel));
                }
            }
            this.callGUIListener(3);
            this.log.addDebugMessage("InstallerFrame.switchPanel: switched", null, "PanelTrace", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.SEVERE, "Error when switching panel", e);
        }
    }

    public void centerFrame(Window frame) {
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Dimension frameSize = frame.getSize();
        frame.setLocation(center.x - frameSize.width / 2, center.y - frameSize.height / 2 - 10);
    }

    public Dimension getPanelsContainerSize() {
        return this.panelsContainer.getSize();
    }

    public void exit() {
        this.navigator.quit();
    }

    void quit() {
        boolean confirmQuit;
        Panel panel = this.panels.getPanel();
        if (panel.getConfirmQuitType() == Panel.ConfirmQuitType.DYNAMIC) {
            confirmQuit = !this.installdata.isCanClose() && (this.navigator.isNextEnabled() || this.navigator.isPreviousEnabled());
        } else {
            boolean bl = confirmQuit = panel.getConfirmQuitType() == Panel.ConfirmQuitType.CONFIRM;
        }
        if (!confirmQuit) {
            if (!this.writeUninstallData()) {
                // empty if block
            }
            this.shutdown();
        } else {
            this.confirmExit();
        }
    }

    protected void wipeAborted() {
        if (!this.unpacker.interrupt(40000L)) {
            return;
        }
        for (String installedFile : this.uninstallData.getInstalledFilesList()) {
            File file = new File(installedFile);
            file.delete();
        }
    }

    public void install(ProgressListener listener) {
        this.unpacker.setProgressListener(listener);
        Thread unpackerthread = new Thread((Runnable)this.unpacker, "IzPack - Unpacker thread");
        unpackerthread.start();
    }

    @Override
    public void writeInstallationRecord(File file, UninstallData uninstallData) throws Exception {
        this.panels.writeInstallationRecord(file, uninstallData);
    }

    public void setQuitButtonText(String text) {
        if (text == null) {
            Messages messages = this.locales.getMessages();
            text = messages.get("installer.quit", new Object[0]);
        }
        this.navigator.setQuitText(text);
    }

    public void setQuitButtonIcon(String iconName) {
        String useButtonIcons = (String)this.installdata.guiPrefs.modifier.get("useButtonIcons");
        if (useButtonIcons == null || "yes".equalsIgnoreCase(useButtonIcons)) {
            this.navigator.getQuit().setIcon((Icon)this.getIcons().get((Object)iconName));
        }
    }

    public void blockGUI() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().setVisible(true);
        this.getGlassPane().setEnabled(true);
        if (this.usualFTP == null) {
            this.usualFTP = this.getFocusTraversalPolicy();
        }
        if (this.blockFTP == null) {
            this.blockFTP = new BlockFocusTraversalPolicy();
        }
        this.setFocusTraversalPolicy((FocusTraversalPolicy)this.blockFTP);
        this.getGlassPane().requestFocus();
        this.callGUIListener(1);
    }

    public void releaseGUI() {
        this.getGlassPane().setEnabled(false);
        this.getGlassPane().setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.setFocusTraversalPolicy((FocusTraversalPolicy)this.usualFTP);
        this.callGUIListener(2);
    }

    @Override
    public void lockPrevButton() {
        this.navigator.setPreviousEnabled(false);
    }

    @Override
    public void lockNextButton() {
        this.navigator.setNextEnabled(false);
    }

    @Override
    public void lockQuitButton() {
        this.navigator.setQuitEnabled(false);
    }

    @Override
    public void unlockPrevButton() {
        this.navigator.setPreviousEnabled(true);
    }

    @Override
    public void unlockNextButton() {
        this.unlockNextButton(true);
    }

    @Override
    public void unlockQuitButton() {
        this.navigator.setQuitEnabled(true);
    }

    @Override
    public void unlockNextButton(boolean requestFocus) {
        this.navigator.setNextEnabled(true);
        if (requestFocus) {
            this.getRootPane().setDefaultButton(this.navigator.setDefaultButton());
            this.navigator.getNext().requestFocusInWindow();
            if (this.getFocusOwner() != null) {
                logger.fine("Current focus owner: " + this.getFocusOwner().getName());
            }
        }
    }

    public void skipPanel() {
        if (this.panels.isBack()) {
            this.navigatePrevious();
        } else {
            this.navigator.next(false);
        }
    }

    @Override
    public void navigateNext() {
        this.navigator.next();
    }

    @Override
    public void navigatePrevious() {
        this.navigator.previous();
    }

    @Override
    public void showHelp() {
        IzPanel izPanel = (IzPanel)this.panels.getView();
        izPanel.showHelp();
    }

    public Messages getMessages() {
        Messages messages = this.locales.getMessages();
        return messages;
    }

    public IconsDatabase getIcons() {
        return this.icons;
    }

    public void setIcons(IconsDatabase icons) {
        this.icons = icons;
    }

    public List<GUIListener> getGuiListener() {
        return this.guiListener;
    }

    public void addGuiListener(GUIListener listener) {
        this.guiListener.add(listener);
    }

    private void createHeadingLabels(int headingLines, Color back) {
        float fontSize;
        this.headingLabels = new JLabel[headingLines + 1];
        this.headingLabels[0] = new JLabel("");
        this.headingLabels[0].setFont(this.headingLabels[0].getFont().deriveFont(1));
        if (this.installdata.guiPrefs.modifier.containsKey("headingForegroundColor")) {
            Color foreground = Color.decode((String)this.installdata.guiPrefs.modifier.get("headingForegroundColor"));
            this.headingLabels[0].setForeground(foreground);
        }
        if (this.installdata.guiPrefs.modifier.containsKey("headingFontSize") && (double)(fontSize = Float.parseFloat((String)this.installdata.guiPrefs.modifier.get("headingFontSize"))) > 0.0 && (double)fontSize <= 5.0) {
            float currentSize = this.headingLabels[0].getFont().getSize2D();
            this.headingLabels[0].setFont(this.headingLabels[0].getFont().deriveFont(currentSize * fontSize));
        }
        if (this.imageLeft) {
            this.headingLabels[0].setAlignmentX(1.0f);
        }
        for (int i = 1; i < headingLines; ++i) {
            this.headingLabels[i] = new JLabel();
            if (this.imageLeft) {
                this.headingLabels[i].setAlignmentX(1.0f);
                continue;
            }
            this.headingLabels[i].setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 8));
        }
    }

    private void createHeadingCounter(JPanel navPanel, JPanel leftHeadingPanel) {
        String counterPos = "inHeading";
        if (this.installdata.guiPrefs.modifier.containsKey("headingPanelCounterPos")) {
            counterPos = (String)this.installdata.guiPrefs.modifier.get("headingPanelCounterPos");
        }
        if (leftHeadingPanel == null && "inHeading".equalsIgnoreCase(counterPos)) {
            return;
        }
        if (this.installdata.guiPrefs.modifier.containsKey("headingPanelCounter")) {
            this.headingCounterComponent = null;
            if ("progressbar".equalsIgnoreCase((String)this.installdata.guiPrefs.modifier.get("headingPanelCounter"))) {
                JProgressBar headingProgressBar = new JProgressBar();
                headingProgressBar.setStringPainted(true);
                headingProgressBar.setString("");
                headingProgressBar.setValue(0);
                this.headingCounterComponent = headingProgressBar;
                if (this.imageLeft) {
                    this.headingCounterComponent.setAlignmentX(1.0f);
                }
            } else if ("text".equalsIgnoreCase((String)this.installdata.guiPrefs.modifier.get("headingPanelCounter"))) {
                JLabel headingCountPanels = new JLabel(" ");
                this.headingCounterComponent = headingCountPanels;
                if (this.imageLeft) {
                    this.headingCounterComponent.setAlignmentX(1.0f);
                } else {
                    this.headingCounterComponent.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
                }
                if (this.installdata.guiPrefs.modifier.containsKey("headingForegroundColor")) {
                    Color foreground = Color.decode((String)this.installdata.guiPrefs.modifier.get("headingForegroundColor"));
                    headingCountPanels.setForeground(foreground);
                }
            }
            if ("inHeading".equals(counterPos)) {
                leftHeadingPanel.add(this.headingCounterComponent);
            } else if ("inNavigationPanel".equals(counterPos)) {
                int i;
                Component[] comps = navPanel.getComponents();
                for (i = 0; i < comps.length && !comps[i].equals(this.navigator.getPrevious()); ++i) {
                }
                if (i <= comps.length) {
                    navPanel.add(Box.createHorizontalGlue(), i);
                    navPanel.add((Component)this.headingCounterComponent, i);
                }
            }
        }
    }

    private JPanel createHeadingIcon(Color back) {
        ImageIcon icon;
        JPanel imgPanel = new JPanel();
        imgPanel.setLayout(new BoxLayout(imgPanel, 1));
        int borderSize = 8;
        if (this.installdata.guiPrefs.modifier.containsKey("headingImageBorderSize")) {
            borderSize = Integer.parseInt((String)this.installdata.guiPrefs.modifier.get("headingImageBorderSize"));
        }
        imgPanel.setBorder(BorderFactory.createEmptyBorder(borderSize, borderSize, borderSize, borderSize));
        if (back != null) {
            imgPanel.setBackground(back);
        }
        if ((icon = this.loadIcon(HEADING_ICON_RESOURCE, "0")) != null) {
            JLabel iconLab = new JLabel(icon);
            if (this.imageLeft) {
                imgPanel.add((Component)iconLab, "West");
            } else {
                imgPanel.add((Component)iconLab, "East");
            }
            this.headingLabels[this.headingLabels.length - 1] = iconLab;
        }
        return imgPanel;
    }

    private void createHeading(JPanel navPanel) {
        this.headingPanel = null;
        int headingLines = 1;
        if (this.installdata.guiPrefs.modifier.containsKey("headingLineCount")) {
            headingLines = Integer.parseInt((String)this.installdata.guiPrefs.modifier.get("headingLineCount"));
        }
        Color back = null;
        if (this.installdata.guiPrefs.modifier.containsKey("headingBackgroundColor")) {
            back = Color.decode((String)this.installdata.guiPrefs.modifier.get("headingBackgroundColor"));
        }
        if (!this.isHeading(null)) {
            this.createHeadingCounter(navPanel, null);
            return;
        }
        if (this.installdata.guiPrefs.modifier.containsKey("headingImageOnLeft") && (((String)this.installdata.guiPrefs.modifier.get("headingImageOnLeft")).equalsIgnoreCase("yes") || ((String)this.installdata.guiPrefs.modifier.get("headingImageOnLeft")).equalsIgnoreCase("true"))) {
            this.imageLeft = true;
        }
        this.createHeadingLabels(headingLines, back);
        JPanel leftHeadingPanel = new JPanel();
        if (back != null) {
            leftHeadingPanel.setBackground(back);
        }
        leftHeadingPanel.setLayout(new BoxLayout(leftHeadingPanel, 1));
        if (this.imageLeft) {
            leftHeadingPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        }
        for (int i = 0; i < headingLines; ++i) {
            leftHeadingPanel.add(this.headingLabels[i]);
        }
        this.createHeadingCounter(navPanel, leftHeadingPanel);
        JPanel imgPanel = this.createHeadingIcon(back);
        JPanel northPanel = new JPanel();
        if (back != null) {
            northPanel.setBackground(back);
        }
        northPanel.setLayout(new BoxLayout(northPanel, 0));
        if (this.imageLeft) {
            northPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            northPanel.add(imgPanel);
            northPanel.add(Box.createHorizontalGlue());
            northPanel.add(leftHeadingPanel);
        } else {
            northPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
            northPanel.add(leftHeadingPanel);
            northPanel.add(Box.createHorizontalGlue());
            northPanel.add(imgPanel);
        }
        this.headingPanel = new JPanel(new BorderLayout());
        this.headingPanel.add(northPanel);
        this.headingPanel.add((Component)new JSeparator(), "South");
        this.contentPane.add((Component)this.headingPanel, "North");
    }

    public boolean isHeading(IzPanel caller) {
        if (!this.installdata.guiPrefs.modifier.containsKey("useHeadingPanel") || !((String)this.installdata.guiPrefs.modifier.get("useHeadingPanel")).equalsIgnoreCase("yes")) {
            return false;
        }
        if (caller == null) {
            return true;
        }
        return caller.getI18nStringForClass("headline") != null;
    }

    private void performHeading(IzPanelView panel) {
        int i;
        int headingLines = 1;
        if (this.installdata.guiPrefs.modifier.containsKey("headingLineCount")) {
            headingLines = Integer.parseInt((String)this.installdata.guiPrefs.modifier.get("headingLineCount"));
        }
        if (this.headingLabels == null) {
            return;
        }
        IzPanel view = (IzPanel)panel.getView();
        String headline = view.getI18nStringForClass("headline");
        if (headline == null) {
            this.headingPanel.setVisible(false);
            return;
        }
        for (i = 0; i <= headingLines; ++i) {
            if (this.headingLabels[i] == null) continue;
            this.headingLabels[i].setVisible(false);
        }
        for (i = 0; i < headingLines - 1; ++i) {
            String info = view.getI18nStringForClass("headinfo" + Integer.toString(i));
            if (info == null) {
                info = " ";
            }
            if (info.endsWith(":")) {
                info = info.substring(0, info.length() - 1) + ".";
            }
            this.headingLabels[i + 1].setText(info);
            this.headingLabels[i + 1].setVisible(true);
        }
        this.headingLabels[0].setText(headline);
        this.headingLabels[0].setVisible(true);
        int curPanelNo = this.panels.getVisibleIndex(panel);
        if (this.headingLabels[headingLines] != null) {
            this.loadAndShowImage(this.headingLabels[headingLines], HEADING_ICON_RESOURCE, curPanelNo);
            this.headingLabels[headingLines].setVisible(true);
        }
        this.headingPanel.setVisible(true);
    }

    private void performHeadingCounter(IzPanelView panel) {
        if (this.headingCounterComponent != null) {
            int curPanelNo = this.panels.getVisibleIndex(panel);
            int visPanelsCount = this.panels.getVisible();
            Messages messages = this.locales.getMessages();
            String message = String.format("%s %d %s %d", messages.get("installer.step", new Object[0]), curPanelNo + 1, messages.get("installer.of", new Object[0]), visPanelsCount);
            if (this.headingCounterComponent instanceof JProgressBar) {
                this.updateProgressBar(visPanelsCount, curPanelNo + 1, message);
            } else {
                this.updateProgressCounter(message);
            }
        }
    }

    public void updateProgressCounter(String message) {
        ((JLabel)this.headingCounterComponent).setText(message);
    }

    public void updateProgressBar(int maximum, int value, String message) {
        JProgressBar counterComponent = (JProgressBar)this.headingCounterComponent;
        counterComponent.setMaximum(maximum);
        counterComponent.setValue(value);
        counterComponent.setString(message);
    }

    private void showHelpButton(boolean show) {
        if (this.helpButton == null) {
            return;
        }
        this.helpButton.setVisible(show);
    }

    private boolean writeUninstallData() {
        boolean result = true;
        if (this.uninstallDataWriter.isUninstallRequired() && !(result = this.uninstallDataWriter.write())) {
            Messages messages = this.locales.getMessages();
            String title = messages.get("installer.error", new Object[0]);
            String message = messages.get("installer.uninstall.writefailed", new Object[0]);
            JOptionPane.showMessageDialog(this, message, title, 0);
        }
        return result;
    }

    private void shutdown() {
        boolean reboot = false;
        if (this.installdata.isRebootNecessary()) {
            Messages messages = this.locales.getMessages();
            System.out.println("[ There are file operations pending after reboot ]");
            switch (this.installdata.getInfo().getRebootAction()) {
                case 3: {
                    reboot = true;
                    break;
                }
                case 2: {
                    String message = this.variables.replace(messages.get("installer.reboot.ask.message", new Object[0]));
                    String title = this.variables.replace(messages.get("installer.reboot.ask.title", new Object[0]));
                    int res = JOptionPane.showConfirmDialog(this, message, title, 0);
                    if (res != 0) break;
                    reboot = true;
                    break;
                }
                case 1: {
                    String message = this.variables.replace(messages.get("installer.reboot.notice.message", new Object[0]));
                    String title = this.variables.replace(messages.get("installer.reboot.notice.title", new Object[0]));
                    JOptionPane.showConfirmDialog(this, message, title, 0);
                }
            }
            if (reboot) {
                System.out.println("[ Rebooting now automatically ]");
            }
        }
        this.housekeeper.shutDown(0, reboot);
    }

    private void confirmExit() {
        int res;
        if (this.unpacker.isInterruptDisabled() && this.interruptCount < 3) {
            ++this.interruptCount;
            return;
        }
        Messages messages = this.locales.getMessages();
        String mkey = "installer.quit.reversemessage";
        String tkey = "installer.quit.reversetitle";
        String message = messages.get("installer.quit.reversemessage", new Object[0]);
        String title = messages.get("installer.quit.reversetitle", new Object[0]);
        if (message.contains("installer.quit.reversemessage")) {
            message = messages.get("installer.quit.message", new Object[0]);
        }
        if (title.contains("installer.quit.reversetitle")) {
            title = messages.get("installer.quit.title", new Object[0]);
        }
        if ((res = JOptionPane.showConfirmDialog(this, message = this.variables.replace(message), title = this.variables.replace(title), 0)) == 0) {
            this.wipeAborted();
            this.housekeeper.shutDown(0);
        }
    }

    @Override
    public String getTitle() {
        String key = "installer.reversetitle";
        Messages messages = this.installdata.getMessages();
        String message = messages.get("installer.reversetitle", new Object[0]);
        message = message.equals("installer.reversetitle") ? messages.get("installer.title", new Object[0]) + " " + this.installdata.getInfo().getAppName() : this.installdata.getVariables().replace(message);
        return message;
    }

    private class BlockFocusTraversalPolicy
    extends DefaultFocusTraversalPolicy {
        private static final long serialVersionUID = 3258413928261169209L;

        private BlockFocusTraversalPolicy() {
        }

        @Override
        protected boolean accept(Component aComp) {
            return aComp == InstallerFrame.this.getGlassPane();
        }
    }

    class HelpHandler
    implements ActionListener {
        HelpHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InstallerFrame.this.showHelp();
        }
    }
}

