/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.bootstrap;

import com.izforge.izpack.api.container.Container;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Overrides;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.core.data.DefaultVariables;
import com.izforge.izpack.installer.console.ConsoleInstaller;
import com.izforge.izpack.installer.console.ConsoleInstallerAction;
import com.izforge.izpack.installer.container.impl.ConsoleInstallerContainer;
import com.izforge.izpack.installer.language.LanguageConsoleDialog;
import com.izforge.izpack.installer.requirement.RequirementsChecker;
import com.izforge.izpack.util.Housekeeper;
import java.util.logging.Logger;

public class InstallerConsole {
    private static final Logger logger = Logger.getLogger(InstallerConsole.class.getName());

    public static void run(ConsoleInstallerAction consoleAction, String path, String langCode, String mediaPath, Overrides defaults, String[] args) {
        ConsoleInstallerContainer applicationComponent = new ConsoleInstallerContainer();
        Container installerContainer = (Container)applicationComponent.getComponent(Container.class);
        try {
            InstallData installData = (InstallData)applicationComponent.getComponent(InstallData.class);
            if (mediaPath != null) {
                installData.setMediaPath(mediaPath);
            }
            if (defaults != null) {
                defaults.setInstallData(installData);
                defaults.load();
                logger.info("Loaded " + defaults.size() + " override(s) from " + defaults.getFile());
                DefaultVariables variables = (DefaultVariables)applicationComponent.getComponent(DefaultVariables.class);
                variables.setOverrides(defaults);
            }
            if (consoleAction != ConsoleInstallerAction.CONSOLE_GEN_TEMPLATE) {
                if (langCode == null) {
                    ((LanguageConsoleDialog)installerContainer.getComponent(LanguageConsoleDialog.class)).initLangPack();
                } else {
                    ((LanguageConsoleDialog)installerContainer.getComponent(LanguageConsoleDialog.class)).propagateLocale(langCode);
                }
                if (!((RequirementsChecker)installerContainer.getComponent(RequirementsChecker.class)).check()) {
                    logger.info("Not all installer requirements are fulfilled.");
                    ((Housekeeper)installerContainer.getComponent(Housekeeper.class)).shutDown(-1);
                }
            }
            ConsoleInstaller consoleInstaller = (ConsoleInstaller)installerContainer.getComponent(ConsoleInstaller.class);
            consoleInstaller.run(consoleAction, path, args);
        }
        catch (Exception e) {
            throw new IzPackException((Throwable)e);
        }
    }
}

