/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.event;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.event.InstallerListener;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.handler.AbstractPrompt;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.core.handler.ProgressHandler;
import com.izforge.izpack.core.handler.PromptUIHandler;
import com.izforge.izpack.event.SimpleInstallerListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class InstallerListeners {
    private final List<InstallerListener> listeners = new ArrayList<InstallerListener>();
    private final List<InstallerListener> fileListeners = new ArrayList<InstallerListener>();
    private final AutomatedInstallData installData;
    private final Prompt prompt;

    public InstallerListeners(AutomatedInstallData installData, Prompt prompt) {
        this.installData = installData;
        this.prompt = prompt;
    }

    public void add(InstallerListener listener) {
        if (listener instanceof SimpleInstallerListener) {
            ((SimpleInstallerListener)listener).setInstalldata(this.installData);
        }
        this.listeners.add(listener);
    }

    public int size() {
        return this.listeners.size();
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public InstallerListener get(int index) {
        return this.listeners.get(index);
    }

    public List<InstallerListener> getInstallerListeners() {
        return this.listeners;
    }

    public void initialise() {
        for (InstallerListener listener : this.listeners) {
            try {
                listener.initialise();
                if (!listener.isFileListener()) continue;
                this.fileListeners.add(listener);
            }
            catch (IzPackException ize) {
                this.handleError(ize);
            }
        }
    }

    public void beforePacks(List<Pack> packs, ProgressListener listener) throws InstallerException {
        for (InstallerListener l : this.listeners) {
            try {
                if (l instanceof SimpleInstallerListener) {
                    ((SimpleInstallerListener)l).setHandler((AbstractUIProgressHandler)new ProgressHandler(listener, this.prompt));
                }
                l.beforePacks(packs);
            }
            catch (IzPackException ize) {
                this.handleError(ize);
            }
        }
    }

    public void beforePack(Pack pack, int i, ProgressListener listener) throws InstallerException {
        for (InstallerListener l : this.listeners) {
            try {
                if (l instanceof SimpleInstallerListener) {
                    ((SimpleInstallerListener)l).setHandler((AbstractUIProgressHandler)new ProgressHandler(listener, this.prompt));
                }
                l.beforePack(pack, i);
            }
            catch (IzPackException ize) {
                this.handleError(ize);
            }
        }
    }

    public boolean isFileListener() {
        return !this.fileListeners.isEmpty();
    }

    public void beforeDir(File dir, PackFile packFile, Pack pack) throws InstallerException {
        for (InstallerListener l : this.fileListeners) {
            try {
                l.beforeDir(dir, packFile, pack);
            }
            catch (IzPackException ize) {
                this.handleError(ize);
            }
        }
    }

    public void afterDir(File dir, PackFile packFile, Pack pack) throws InstallerException {
        for (InstallerListener l : this.fileListeners) {
            try {
                l.afterDir(dir, packFile, pack);
            }
            catch (IzPackException ize) {
                this.handleError(ize);
            }
        }
    }

    public void beforeFile(File file, PackFile packFile, Pack pack) throws InstallerException {
        for (InstallerListener l : this.fileListeners) {
            try {
                l.beforeFile(file, packFile, pack);
            }
            catch (IzPackException ize) {
                this.handleError(ize);
            }
        }
    }

    public void afterFile(File file, PackFile packFile, Pack pack) throws InstallerException {
        for (InstallerListener l : this.fileListeners) {
            try {
                l.afterFile(file, packFile, pack);
            }
            catch (IzPackException ize) {
                this.handleError(ize);
            }
        }
    }

    public void afterPack(Pack pack, int i, ProgressListener listener) throws InstallerException {
        for (InstallerListener l : this.listeners) {
            try {
                if (l instanceof SimpleInstallerListener) {
                    ((SimpleInstallerListener)l).setHandler((AbstractUIProgressHandler)new ProgressHandler(listener, this.prompt));
                }
                l.afterPack(pack, i);
            }
            catch (IzPackException ize) {
                this.handleError(ize);
            }
        }
    }

    public void afterPacks(List<Pack> packs, ProgressListener listener) throws InstallerException {
        for (InstallerListener l : this.listeners) {
            try {
                if (l instanceof SimpleInstallerListener) {
                    ((SimpleInstallerListener)l).setHandler((AbstractUIProgressHandler)new ProgressHandler(listener, this.prompt));
                }
                l.afterPacks(packs, listener);
            }
            catch (IzPackException ize) {
                this.handleError(ize);
            }
        }
    }

    private void handleError(IzPackException ize) throws IzPackException {
        Messages messages = this.installData.getMessages();
        switch (ize.getPromptType()) {
            case WARNING: {
                PromptUIHandler handler = new PromptUIHandler(this.prompt);
                if (handler.askWarningQuestion(null, AbstractPrompt.getThrowableMessage((Throwable)ize) + "\n" + messages.get("installer.continueQuestion", new Object[0]), 37, 49) == 47) break;
                throw new InstallerException(messages.get("installer.cancelled", new Object[0]));
            }
            default: {
                throw ize;
            }
        }
    }
}

