/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.requirement;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Info;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.installer.RequirementChecker;
import com.izforge.izpack.installer.bootstrap.Installer;
import com.izforge.izpack.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LockFileChecker
implements RequirementChecker {
    private final InstallData installData;
    private final Prompt prompt;
    private static final Logger logger = Logger.getLogger(LockFileChecker.class.getName());

    public LockFileChecker(AutomatedInstallData installData, Prompt prompt) {
        this.installData = installData;
        this.prompt = prompt;
    }

    public boolean check() {
        boolean result = true;
        Info installationInfo = this.installData.getInfo();
        if (installationInfo.isSingleInstance() && !Boolean.getBoolean("MULTIINSTANCE")) {
            String appName = installationInfo.getAppName();
            File file = FileUtil.getLockFile((String)appName);
            if (file.exists()) {
                result = this.handleLockFile(file);
            } else {
                try {
                    if (file.createNewFile()) {
                        logger.fine("Created lock file:" + file.getPath());
                        file.deleteOnExit();
                    } else {
                        logger.warning("Failed to create lock file: " + file.getPath());
                        logger.warning("*** Multiple instances of installer will be allowed ***");
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Lock file could not be created: " + e.getMessage(), e);
                    logger.warning("*** Multiple instances of installer will be allowed ***");
                }
                result = true;
            }
        }
        return result;
    }

    protected boolean handleLockFile(File file) {
        boolean result = false;
        if (Installer.getInstallerMode() == 1) {
            logger.fine("Lock file exists.");
            try {
                this.installData.setVariable("LOCK_FILE", file.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String msg = this.installData.getMessages().get("LockFile.exists.message", new Object[]{"Lock file exist."});
            System.out.println(this.installData.getVariables().replace(msg));
            logger.fine("Leaving temp file alone and exiting");
        } else {
            logger.fine("Lock file exists, asking user for permission to proceed.");
            String msg = this.installData.getMessages().get("LockFile.exists.prompt", new Object[]{"Lock file exist."});
            Prompt.Option selected = this.prompt.confirm(Prompt.Type.WARNING, this.installData.getVariables().replace(msg), Prompt.Options.YES_NO);
            if (selected == Prompt.Option.YES) {
                logger.fine("Setting temp file to delete on continue");
                file.deleteOnExit();
                result = true;
            } else {
                logger.fine("Leaving temp file alone and exiting");
            }
        }
        return result;
    }
}

