/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.izforge.izpack.util.Librarian;
import com.izforge.izpack.util.NativeLibraryClient;
import java.io.File;
import java.io.UnsupportedEncodingException;

public class ShellLink
implements NativeLibraryClient {
    public static final int HIDE = 0;
    public static final int NORMAL = 1;
    public static final int MINIMIZED = 2;
    public static final int MAXIMIZED = 3;
    public static final int MINNOACTIVE = 7;
    private static final int MIN_SHOW = 0;
    private static final int MAX_SHOW = 7;
    public static final int DESKTOP = 1;
    public static final int PROGRAM_MENU = 2;
    public static final int START_MENU = 3;
    public static final int STARTUP = 4;
    private static final int MIN_TYPE = 1;
    private static final int MAX_TYPE = 4;
    private static final int SL_OK = 1;
    private static final int SL_ERROR = -1;
    private static final int SL_INITIALIZED = -2;
    private static final int SL_NOT_INITIALIZED = -3;
    private static final int SL_OUT_OF_HANDLES = -4;
    private static final int SL_NO_IPERSIST = -5;
    private static final int SL_NO_SAVE = -6;
    private static final int SL_WRONG_DATA_TYPE = -7;
    private static final int UNINITIALIZED = -1;
    private static final String LINK_EXTENSION = ".lnk";
    public static final int CURRENT_USER = 0;
    public static final int ALL_USERS = 1;
    private int nativeHandle = -1;
    private String currentUserLinkPath;
    private String allUsersLinkPath;
    private String groupName = "";
    private String linkName = "";
    private String linkFileName = "";
    private String linkDirectory = "";
    private String arguments = "";
    private String description = "";
    private String iconPath = "";
    private String targetPath = "";
    private String workingDirectory = "";
    private String dummyString = "";
    private int hotkey = 0;
    private int iconIndex = 0;
    private int showCommand = 1;
    private int linkType = 1;
    private int userType = 0;
    private boolean runAsAdministrator;
    private boolean initializeSucceeded = false;
    private final Librarian librarian;

    private native int initializeCOM();

    private native int releaseCOM();

    private native int getInterface();

    private native int releaseInterface();

    private native int GetArguments();

    private native int GetDescription();

    private native int GetHotkey();

    private native int GetIconLocation();

    private native int GetPath();

    private native int GetShowCommand();

    private native int GetWorkingDirectory();

    private native int Resolve();

    private native int SetArguments();

    private native int SetDescription();

    private native int SetHotkey();

    private native int SetIconLocation();

    private native int SetPath();

    private native int SetShowCommand();

    private native int SetWorkingDirectory();

    private native int saveLink(String var1);

    private native int loadLink(String var1);

    private native int GetFullLinkPath(int var1, int var2);

    private native int SetRunAsAdministrator();

    private native int GetRunAsAdministrator();

    private native void FreeLibrary(String var1);

    public ShellLink(int type, String name, Librarian librarian) throws Exception {
        if (type < 1 || type > 4) {
            throw new IllegalArgumentException("the type parameter used an illegal value");
        }
        if (name == null) {
            throw new IllegalArgumentException("the name parameter was null");
        }
        this.linkName = name;
        this.linkType = type;
        this.librarian = librarian;
        this.initialize();
        this.setAllLinkPaths();
    }

    public ShellLink(String name, int userType, Librarian librarian) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("the name parameter was null");
        }
        this.userType = userType;
        this.librarian = librarian;
        this.initialize();
        int pathEnd = name.lastIndexOf(File.separator);
        int nameStart = pathEnd + 1;
        int nameEnd = name.lastIndexOf(46);
        if (nameEnd < 0) {
            throw new Exception("illegal file name");
        }
        this.linkName = name.substring(nameStart, nameEnd);
        if (userType == 0) {
            this.currentUserLinkPath = name.substring(0, pathEnd);
        } else {
            this.allUsersLinkPath = name.substring(0, pathEnd);
        }
        this.linkFileName = this.fullLinkName(userType);
        if (this.loadLink(this.linkFileName) != 1) {
            throw new Exception("reading of the file did not succeed");
        }
        this.get();
    }

    public ShellLink(int linkType, int userType, String group, String name, Librarian librarian) throws Exception {
        if (linkType < 1 || linkType > 4) {
            throw new IllegalArgumentException("the type parameter used an illegal value");
        }
        if (name == null) {
            throw new IllegalArgumentException("the name parameter was null");
        }
        this.linkType = linkType;
        this.userType = userType;
        this.librarian = librarian;
        this.initialize();
        this.setAllLinkPaths();
        if (group != null) {
            this.groupName = group;
        }
        this.linkName = name;
        this.linkFileName = this.fullLinkName(userType);
        if (this.loadLink(this.linkFileName) != 1) {
            throw new Exception("Failed to read link: " + this.linkFileName);
        }
        this.get();
    }

    private void initialize() throws Exception {
        try {
            this.librarian.loadLibrary("ShellLink", (NativeLibraryClient)this);
        }
        catch (UnsatisfiedLinkError exception) {
            throw new Exception("Could not locate native library", exception);
        }
        try {
            if (this.initializeCOM() != 1) {
                throw new Exception("could not initialize COM");
            }
            this.initializeSucceeded = true;
        }
        catch (Throwable exception) {
            throw new Exception("unidentified problem initializing COM\n" + exception.toString());
        }
        int successCode = this.getInterface();
        if (successCode != 1) {
            this.releaseCOM();
            this.initializeSucceeded = false;
            if (successCode == -4) {
                throw new Exception("could not get an instance of IShellLink, no more handles available");
            }
            throw new Exception("could not get an instance of IShellLink, failed to co-create instance");
        }
    }

    protected void finalize() throws Throwable {
        this.releaseInterface();
        if (this.initializeSucceeded) {
            this.releaseCOM();
            this.initializeSucceeded = false;
        }
        super.finalize();
    }

    public void freeLibrary(String name) {
        int result = this.releaseInterface();
        if (this.initializeSucceeded) {
            result = this.releaseCOM();
            this.initializeSucceeded = false;
        }
        this.FreeLibrary(name);
    }

    private String fullLinkPath(int userType) {
        StringBuilder path = new StringBuilder();
        if (userType == 0) {
            path.append(this.currentUserLinkPath);
        } else {
            path.append(this.allUsersLinkPath);
        }
        if (this.groupName != null && this.groupName.length() > 0) {
            path.append(File.separator);
            path.append(this.groupName);
        }
        return path.toString();
    }

    private String fullLinkName(int userType) {
        StringBuilder name = new StringBuilder();
        name.append(this.fullLinkPath(userType));
        name.append(File.separator);
        name.append(this.linkName);
        name.append(LINK_EXTENSION);
        return name.toString();
    }

    private void set() throws Exception {
        if (this.SetArguments() != 1) {
            throw new Exception("could not set arguments");
        }
        if (this.SetDescription() != 1) {
            throw new Exception("could not set description");
        }
        if (this.SetHotkey() != 1) {
            throw new Exception("could not set hotkey");
        }
        if (this.SetIconLocation() != 1) {
            throw new Exception("could not set icon location");
        }
        if (this.SetPath() != 1) {
            throw new Exception("could not set target path");
        }
        if (this.SetShowCommand() != 1) {
            throw new Exception("could not set show command");
        }
        if (this.SetWorkingDirectory() != 1) {
            throw new Exception("could not set working directory");
        }
        if (this.SetRunAsAdministrator() != 1) {
            throw new Exception("Could not set Run As Administrator flag");
        }
    }

    private void get() throws Exception {
        if (this.GetArguments() != 1) {
            throw new Exception("could not get arguments");
        }
        if (this.GetDescription() != 1) {
            throw new Exception("could not get description");
        }
        if (this.GetHotkey() != 1) {
            throw new Exception("could not get hotkey");
        }
        if (this.GetIconLocation() != 1) {
            throw new Exception("could not get icon location");
        }
        if (this.GetPath() != 1) {
            throw new Exception("could not get target ath");
        }
        if (this.GetShowCommand() != 1) {
            throw new Exception("could not get show command");
        }
        if (this.GetWorkingDirectory() != 1) {
            throw new Exception("could not get working directory");
        }
        if (this.GetRunAsAdministrator() != 1) {
            throw new Exception("Could not get Run As Administrator flag");
        }
    }

    public void setProgramGroup(String groupName) {
        this.groupName = groupName;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHotkey(int hotkey) {
        this.hotkey = hotkey;
    }

    public void setIconLocation(String path, int index) {
        this.iconPath = path;
        this.iconIndex = index;
    }

    public void setTargetPath(String path) {
        this.targetPath = path;
    }

    public void setShowCommand(int show) {
        if (show < 0 || show > 7) {
            throw new IllegalArgumentException("illegal value for show command " + show);
        }
        this.showCommand = show;
    }

    public void setWorkingDirectory(String dir) {
        this.workingDirectory = dir;
    }

    public void setLinkName(String name) {
        this.linkName = name;
    }

    public void setLinkType(int type) throws IllegalArgumentException, UnsupportedEncodingException {
        if (type < 1 || type > 4) {
            throw new IllegalArgumentException("illegal value for type");
        }
        this.linkType = type;
        this.setAllLinkPaths();
    }

    public int getLinkType() {
        return this.linkType;
    }

    public void setUserType(int type) throws IllegalArgumentException {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException(type + " is not a recognized user type");
        }
        this.userType = type;
    }

    public int getUserType() {
        return this.userType;
    }

    public String getLinkPath(int userType) {
        String result = null;
        result = userType == 0 ? this.currentUserLinkPath : this.allUsersLinkPath;
        return result;
    }

    public String getArguments() {
        return this.arguments;
    }

    public String getDescription() {
        return this.description;
    }

    public int getHotkey() {
        return this.hotkey;
    }

    public String getIconLocation() {
        return this.iconPath;
    }

    public int getIconIndex() {
        return this.iconIndex;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public int getShowCommand() {
        return this.showCommand;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getFileName() {
        return this.linkFileName;
    }

    public String getDirectoryCreated() {
        return this.linkDirectory;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public String getcurrentUserLinkPath() {
        return this.currentUserLinkPath;
    }

    public String getallUsersLinkPath() {
        return this.allUsersLinkPath;
    }

    public void save() throws Exception {
        String saveTo;
        this.set();
        int result = this.Resolve();
        if (result != 1) {
            throw new Exception("cannot resolve target");
        }
        File directory = new File(this.fullLinkPath(this.userType));
        if (!directory.exists()) {
            directory.mkdirs();
            this.linkDirectory = directory.getPath();
        } else {
            this.linkDirectory = "";
        }
        File allUsersFileObj = null;
        long aufLastModVal = 0L;
        if (this.userType == 0) {
            allUsersFileObj = new File(this.fullLinkName(1));
            aufLastModVal = allUsersFileObj.lastModified();
        }
        if ((result = this.saveLink(saveTo = this.fullLinkName(this.userType))) == -5) {
            throw new Exception("could not get handle for IPesist");
        }
        if (result == -6) {
            throw new Exception("the save operation failed");
        }
        if (allUsersFileObj != null) {
            try {
                if (allUsersFileObj.exists() && allUsersFileObj.lastModified() > aufLastModVal) {
                    File curUserFileObj = new File(saveTo);
                    this.moveFileTo(allUsersFileObj, curUserFileObj);
                    allUsersFileObj.getParentFile().delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.linkFileName = saveTo;
    }

    public void setRunAsAdministrator(boolean runAsAdministrator) {
        this.runAsAdministrator = runAsAdministrator;
    }

    public boolean getRunAsAdministrator() {
        return this.runAsAdministrator;
    }

    public void save(String name) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("name was null");
        }
        this.set();
        if (this.Resolve() != 1) {
            throw new Exception("cannot resolve target");
        }
        File directory = new File(name.substring(0, name.lastIndexOf(File.separatorChar)));
        if (!directory.exists()) {
            directory.mkdirs();
            this.linkDirectory = directory.getPath();
        } else {
            this.linkDirectory = null;
        }
        if (this.saveLink(name) != 1) {
            throw new Exception("the save operation failed");
        }
        this.linkFileName = name;
    }

    protected void moveFileTo(File srcFileObj, File destFileObj) {
        if (destFileObj.exists()) {
            File tempFileObj = new File(destFileObj.getPath() + System.currentTimeMillis());
            destFileObj.renameTo(tempFileObj);
            srcFileObj.renameTo(destFileObj);
            tempFileObj.delete();
        } else {
            srcFileObj.renameTo(destFileObj);
        }
    }

    private void setAllLinkPaths() throws IllegalArgumentException {
        this.currentUserLinkPath = "";
        this.allUsersLinkPath = "";
        this.GetFullLinkPath(0, this.linkType);
        this.GetFullLinkPath(1, this.linkType);
        if (this.userType == 0 && this.currentUserLinkPath.length() == 0) {
            this.userType = 1;
        } else if (this.userType == 1 && this.allUsersLinkPath.length() == 0) {
            this.userType = 0;
        }
        if (this.allUsersLinkPath.length() == 0 && this.currentUserLinkPath.length() == 0) {
            throw new IllegalArgumentException("linkType " + this.linkType + " is invalid.");
        }
    }
}

