/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.substitutor.SubstitutionType;
import com.izforge.izpack.core.resource.ResourceManager;
import com.izforge.izpack.core.substitutor.VariableSubstitutorInputStream;
import com.izforge.izpack.util.Debug;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class LogUtils {
    private static final String LOGGING_BASE_CONFIGURATION = "/com/izforge/izpack/installer/logging/logging.base.properties";
    private static final String LOGGING_CONFIGURATION = "/com/izforge/izpack/installer/logging/logging.properties";
    private static final String FILEHANDLER_CLASSNAME = FileHandler.class.getName();
    private static final String CONSOLEHANDLER_CLASSNAME = ConsoleHandler.class.getName();
    private static final boolean OVERRIDE = System.getProperty("java.util.logging.config.class") == null && System.getProperty("java.util.logging.config.file") == null;

    public static void loadConfiguration() throws IOException {
        if (OVERRIDE) {
            LogUtils.loadConfiguration(LOGGING_CONFIGURATION, null);
        }
    }

    public static void loadConfiguration(String resource, Variables variables) throws IOException {
        if (OVERRIDE) {
            InputStream resourceStream = null;
            try {
                resourceStream = LogUtils.class.getResourceAsStream(resource);
                LogUtils.loadLoggingResource(resourceStream, variables);
            }
            finally {
                IOUtils.closeQuietly((InputStream)resourceStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadConfiguration(final Properties configuration) throws IOException {
        if (OVERRIDE) {
            LogManager manager = LogManager.getLogManager();
            InputStream baseResourceStream = null;
            try {
                baseResourceStream = LogUtils.class.getResourceAsStream(LOGGING_BASE_CONFIGURATION);
                Properties baseProps = new Properties();
                baseProps.load(baseResourceStream);
                LogUtils.mergeLoggingConfiguration(configuration, baseProps);
            }
            finally {
                IOUtils.closeQuietly((InputStream)baseResourceStream);
            }
            boolean mkdirs = false;
            String pattern = null;
            if (configuration.getProperty("handlers") != null && configuration.getProperty("handlers").contains(FILEHANDLER_CLASSNAME) && manager.getProperty("handlers").contains(FILEHANDLER_CLASSNAME)) {
                return;
            }
            for (String key : configuration.stringPropertyNames()) {
                if (key.equals(FILEHANDLER_CLASSNAME + ".pattern")) {
                    pattern = FilenameUtils.normalize((String)configuration.getProperty(key));
                    configuration.setProperty(key, pattern);
                    continue;
                }
                if (!key.equals(FILEHANDLER_CLASSNAME + ".mkdirs")) continue;
                mkdirs = Boolean.parseBoolean(configuration.getProperty(key));
                configuration.remove(key);
            }
            if (mkdirs && pattern != null) {
                FileUtils.forceMkdirParent((File)new File(pattern));
            }
            Properties userProps = new Properties();
            InputStream userPropsStream = LogUtils.class.getResourceAsStream(ResourceManager.getInstallLoggingConfigurationResourceName());
            try {
                if (userPropsStream != null) {
                    userProps.load(userPropsStream);
                    for (String userPropName : userProps.stringPropertyNames()) {
                        String level;
                        if (!userPropName.endsWith(".level") || userPropName.startsWith(FILEHANDLER_CLASSNAME) || (level = userProps.getProperty(userPropName)) == null) continue;
                        configuration.setProperty(userPropName, level);
                    }
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)userPropsStream);
            }
            InputStream defaultResourceStream = null;
            try {
                defaultResourceStream = LogUtils.class.getResourceAsStream(LOGGING_CONFIGURATION);
                Properties defaultProps = new Properties();
                defaultProps.load(defaultResourceStream);
                LogUtils.mergeLoggingConfiguration(configuration, defaultProps);
            }
            finally {
                IOUtils.closeQuietly((InputStream)defaultResourceStream);
            }
            if (Debug.isDEBUG()) {
                configuration.setProperty(FILEHANDLER_CLASSNAME + ".level", Level.FINE.toString());
                configuration.setProperty(ConsoleHandler.class.getName() + ".level", Level.FINE.toString());
            }
            String fileLevelName = configuration.getProperty(FILEHANDLER_CLASSNAME + ".level", Level.ALL.toString());
            Level fileLevel = Level.ALL;
            if (fileLevelName != null) {
                fileLevel = Level.parse(fileLevelName);
            }
            String consoleLevelName = configuration.getProperty(CONSOLEHANDLER_CLASSNAME + ".level", Level.INFO.toString());
            Level consoleLevel = Level.INFO;
            if (consoleLevelName != null) {
                consoleLevel = Level.parse(consoleLevelName);
            }
            configuration.setProperty(".level", fileLevel.intValue() < consoleLevel.intValue() ? fileLevelName : consoleLevelName);
            final PipedOutputStream out = new PipedOutputStream();
            PipedInputStream in = new PipedInputStream(out);
            try {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            configuration.store(out, null);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        finally {
                            IOUtils.closeQuietly((OutputStream)out);
                        }
                    }
                }).start();
                manager.readConfiguration(in);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    private static void loadLoggingResource(InputStream resourceStream, Variables variables) throws IOException {
        if (resourceStream != null) {
            InputStream is = variables != null ? new VariableSubstitutorInputStream(resourceStream, null, variables, SubstitutionType.TYPE_JAVA_PROPERTIES, false) : resourceStream;
            Properties props = new Properties();
            props.load(is);
            LogUtils.loadConfiguration(props);
        }
    }

    private static void mergeLoggingConfiguration(Properties to, Properties from) {
        for (String fromName : from.stringPropertyNames()) {
            String fromValue = from.getProperty(fromName);
            if (fromName.matches("\\.?handlers") && to.containsKey(fromName)) {
                String oldValue = to.getProperty(fromName);
                if (fromValue.equals(oldValue)) continue;
                to.setProperty(fromName, oldValue + ", " + fromValue);
                continue;
            }
            if (to.containsKey(fromName)) continue;
            to.setProperty(fromName, fromValue);
        }
    }
}

