/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.automation.PanelAutomation;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.gui.IzPanel;
import java.util.function.Predicate;
import java.util.logging.Logger;

public class PanelHelper {
    private static final Logger logger = Logger.getLogger(PanelHelper.class.getName());

    public static Class<IzPanel> getIzPanel(String className) {
        return PanelHelper.getIzPanel(className, PanelHelper.class.getClassLoader());
    }

    public static Class<IzPanel> getIzPanel(String className, ClassLoader loader) {
        Class<IzPanel> result = PanelHelper.getClass(className.replaceAll("ConsolePanel$", "Panel"), IzPanel.class, loader);
        if (result == null && (result = PanelHelper.getClass(className.replaceAll("ConsoleHelper$", ""), IzPanel.class, loader)) == null) {
            result = PanelHelper.getClass(className.replaceFirst("Console", ""), IzPanel.class, loader);
        }
        return result;
    }

    public static Class<ConsolePanel> getConsolePanel(String className) {
        return PanelHelper.getConsolePanel(className, PanelHelper.class.getClassLoader());
    }

    public static Class<ConsolePanel> getConsolePanel(String className, ClassLoader loader) {
        Class<ConsolePanel> result = PanelHelper.getClass(className.replaceAll("Panel$", "ConsolePanel"), ConsolePanel.class, loader);
        if (result == null) {
            result = PanelHelper.getPanelClass(ConsolePanel.class, className, loader, "Console", "ConsoleHelper");
        }
        return result;
    }

    public static Class<PanelAutomation> getAutomatedPanel(String className) {
        return PanelHelper.getAutomatedPanel(className, PanelAutomation.class.getClassLoader());
    }

    public static Class<PanelAutomation> getAutomatedPanel(String className, ClassLoader loader) {
        return PanelHelper.getPanelClass(PanelAutomation.class, className, loader, "Automation", "AutomationHelper");
    }

    private static <T> Class<T> getPanelClass(Class<T> superType, String className, ClassLoader loader, String ... suffixes) {
        Class<T> result = null;
        for (String suffix : suffixes) {
            result = PanelHelper.getClass(className + suffix, superType, loader);
            if (result != null) break;
        }
        return result;
    }

    private static <T> Class<T> getClass(String name, Class<T> superType, ClassLoader loader) {
        Class<?> result = null;
        try {
            Class<?> type = loader.loadClass(name);
            if (!superType.isAssignableFrom(type)) {
                logger.fine(name + " does not implement " + superType.getName() + ", ignoring");
            } else {
                result = type;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public static String getPanelTitleMessageKey(Panel panel, String defaultSuffix, InstallData installData) {
        return PanelHelper.getPanelSpecificKey(panel, defaultSuffix, key -> installData.getMessages().getMessages().containsKey(key));
    }

    public static String getPanelResourceName(Panel panel, String defaultSuffix, Resources resources) {
        return PanelHelper.getPanelSpecificKey(panel, defaultSuffix, key -> resources.getString(key, null) != null);
    }

    public static String getPanelName(Panel panel) {
        String className = panel.getClassName();
        String panelName = className.substring(className.lastIndexOf(46) + 1);
        panelName = panelName.replaceAll("Console", "");
        return panelName;
    }

    private static String getPanelSpecificKey(Panel panel, String defaultSuffix, Predicate<String> predicate) {
        String key;
        String panelName = PanelHelper.getPanelName(panel);
        String panelId = panel.getPanelId();
        if (panelId != null && predicate.test(key = panelName + "." + panelId)) {
            return key;
        }
        return panelName + "." + defaultSuffix;
    }
}

