/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.console;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.UserInterruptException;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.installer.base.InstallerBase;
import com.izforge.izpack.installer.console.ConsoleAction;
import com.izforge.izpack.installer.console.ConsoleInstallAction;
import com.izforge.izpack.installer.console.ConsoleInstallerAction;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanels;
import com.izforge.izpack.installer.console.GeneratePropertiesAction;
import com.izforge.izpack.installer.console.PropertyInstallAction;
import com.izforge.izpack.installer.data.ConsoleInstallData;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.util.Console;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.PrivilegedRunner;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class ConsoleInstaller
implements InstallerBase {
    private static final Logger logger = Logger.getLogger(ConsoleInstaller.class.getName());
    private final ConsolePanels panels;
    private ConsoleInstallData installData;
    private UninstallDataWriter uninstallDataWriter;
    private Console console;
    private final Housekeeper housekeeper;
    private boolean interrupted = false;

    public ConsoleInstaller(ConsolePanels panels, ConsoleInstallData installData, UninstallDataWriter uninstallDataWriter, Console console, Housekeeper housekeeper) {
        this.panels = panels;
        this.installData = installData;
        this.uninstallDataWriter = uninstallDataWriter;
        this.console = console;
        this.housekeeper = housekeeper;
    }

    public void setMediaPath(String path) {
        this.installData.setMediaPath(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ConsoleInstallerAction type, String path, String[] args) {
        PrivilegedRunner runner = new PrivilegedRunner(this.installData.getPlatform());
        if (!runner.hasCorrectPermissions(this.installData.getInfo(), this.installData.getRules())) {
            try {
                runner.relaunchWithElevatedRights(args);
            }
            catch (Exception e) {
                this.console.println(this.installData.getMessages().get("ConsoleInstaller.permissionError", new Object[0]));
            }
            System.exit(0);
        }
        boolean success = false;
        ConsoleAction action = null;
        this.panels.initialise();
        try {
            action = this.createConsoleAction(type, path, this.console);
            this.panels.setAction(action);
            while (this.panels.hasNext() && (success = this.panels.next(action.isValidating())) && (!action.isValidating() || (success = ((ConsolePanel)this.panels.getView()).handlePanelValidationResult(success)))) {
            }
            if (success) {
                if (action.isValidating()) {
                    success = ((ConsolePanel)this.panels.getView()).handlePanelValidationResult(this.panels.isValid());
                }
                if (success) {
                    success = action.complete();
                }
            }
        }
        catch (UserInterruptException uie) {
            this.interrupted = true;
            success = false;
            this.console.println(uie.getMessage());
        }
        catch (Throwable t) {
            success = false;
            logger.log(Level.SEVERE, t.getMessage(), t);
        }
        finally {
            if (action != null && action.isInstall()) {
                this.shutdown(success, this.console);
            } else {
                this.shutdown(success, false);
            }
        }
    }

    protected void shutdown(boolean exitSuccess, Console console) {
        boolean reboot = false;
        Messages messages = this.installData.getMessages();
        if (this.installData.isRebootNecessary()) {
            console.println("[ " + messages.get("ConsoleInstaller.shutdown.pendingFileOperations", new Object[0]) + " ]");
            switch (this.installData.getInfo().getRebootAction()) {
                case 3: {
                    reboot = true;
                }
            }
            if (reboot) {
                console.println("[ " + messages.get("ConsoleInstaller.shutdown.rebootingNow", new Object[0]) + " ]");
            }
        }
        this.shutdown(exitSuccess, reboot);
    }

    protected void shutdown(boolean exitSuccess, boolean reboot) {
        Messages messages = this.installData.getMessages();
        if (exitSuccess && !this.installData.isInstallSuccess()) {
            logger.severe("Expected successful exit status, but installation data is reporting failure");
            exitSuccess = false;
        }
        this.installData.setInstallSuccess(exitSuccess);
        if (exitSuccess) {
            this.console.println("[ " + messages.get("ConsoleInstaller.shutdown.done", new Object[0]) + " ]");
        } else if (this.interrupted) {
            this.console.println("[ " + messages.get("ConsoleInstaller.shutdown.aborted", new Object[0]) + " ]");
        } else {
            this.console.println("[ " + messages.get("ConsoleInstaller.shutdown.failed", new Object[0]) + " ]");
        }
        this.terminate(exitSuccess, reboot);
    }

    protected void terminate(boolean exitSuccess, boolean reboot) {
        this.housekeeper.shutDown(exitSuccess ? 0 : 1, reboot);
    }

    protected Console getConsole() {
        return this.console;
    }

    private ConsoleAction createConsoleAction(ConsoleInstallerAction type, String path, Console console) throws IOException {
        ConsoleAction action;
        switch (type) {
            case CONSOLE_GEN_TEMPLATE: {
                action = this.createGeneratePropertiesAction(path);
                break;
            }
            case CONSOLE_FROM_TEMPLATE: {
                action = this.createInstallFromPropertiesFileAction(path);
                break;
            }
            case CONSOLE_FROM_SYSTEMPROPERTIES: {
                action = new PropertyInstallAction((InstallData)this.installData, this.uninstallDataWriter, System.getProperties());
                break;
            }
            case CONSOLE_FROM_SYSTEMPROPERTIESMERGE: {
                action = this.createInstallFromSystemPropertiesMergeAction(path, console);
                break;
            }
            default: {
                action = this.createInstallAction();
            }
        }
        return action;
    }

    private ConsoleAction createInstallAction() {
        return new ConsoleInstallAction(this.console, (InstallData)this.installData, this.uninstallDataWriter);
    }

    private ConsoleAction createGeneratePropertiesAction(String path) throws IOException {
        return new GeneratePropertiesAction((InstallData)this.installData, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsoleAction createInstallFromPropertiesFileAction(String path) throws IOException {
        FileInputStream in = new FileInputStream(path);
        try {
            Properties properties = new Properties();
            properties.load(in);
            PropertyInstallAction propertyInstallAction = new PropertyInstallAction((InstallData)this.installData, this.uninstallDataWriter, properties);
            return propertyInstallAction;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsoleAction createInstallFromSystemPropertiesMergeAction(String path, Console console) throws IOException {
        FileInputStream in = new FileInputStream(path);
        try {
            Properties properties = new Properties();
            properties.load(in);
            Properties systemProperties = System.getProperties();
            Enumeration<?> e = systemProperties.propertyNames();
            while (e.hasMoreElements()) {
                String newValue;
                String key = (String)e.nextElement();
                String oldValue = (String)properties.setProperty(key, newValue = systemProperties.getProperty(key));
                if (oldValue == null) continue;
                console.println("Warning: Property " + key + " overwritten: '" + oldValue + "' --> '" + newValue + "'");
            }
            PropertyInstallAction propertyInstallAction = new PropertyInstallAction((InstallData)this.installData, this.uninstallDataWriter, properties);
            return propertyInstallAction;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    @Override
    public void writeInstallationRecord(File file, UninstallData uninstallData) throws Exception {
        this.panels.writeInstallationRecord(file, uninstallData);
    }
}

