/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.container.provider;

import com.izforge.izpack.api.data.GUIPrefs;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.LookAndFeels;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.resource.Locales;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.core.data.DefaultVariables;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.container.provider.AbstractInstallDataProvider;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.JavaVersion;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.awt.Color;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class GUIInstallDataProvider
extends AbstractInstallDataProvider {
    private static final Logger logger = Logger.getLogger(GUIInstallDataProvider.class.getName());
    public static final String MODIFIER_USE_BUTTON_ICONS = "useButtonIcons";
    public static final String MODIFIER_USE_LABEL_ICONS = "useLabelIcons";
    public static final String MODIFIER_LABEL_FONT_SIZE = "labelFontSize";
    private static final Map<String, String> substanceVariants = new HashMap<String, String>();
    private static final Map<String, String> radianceVariants = new HashMap<String, String>(48);
    private static final Map<String, String> looksVariants = new HashMap<String, String>();

    public GUIInstallData provide(Resources resources, Locales locales, DefaultVariables variables, Housekeeper housekeeper, PlatformModelMatcher matcher) throws Exception {
        GUIInstallData guiInstallData = new GUIInstallData((Variables)variables, matcher.getCurrentPlatform());
        guiInstallData.setVariable("INSTALLER_MODE", "gui");
        this.loadInstallData(guiInstallData, resources, matcher, housekeeper);
        this.loadGUIInstallData(guiInstallData, resources);
        this.loadInstallerRequirements(guiInstallData, resources);
        this.loadDynamicVariables((Variables)variables, (InstallData)guiInstallData, resources);
        this.loadDynamicConditions(guiInstallData, resources);
        this.loadDefaultLocale(guiInstallData, locales);
        AbstractInstallDataProvider.addCustomLangpack(guiInstallData, locales);
        AbstractInstallDataProvider.addUserInputLangpack(guiInstallData, locales);
        this.loadLookAndFeel(guiInstallData);
        if (UIManager.getColor("Button.background") != null) {
            guiInstallData.buttonsHColor = UIManager.getColor("Button.background");
        }
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        return guiInstallData;
    }

    protected void loadLookAndFeel(GUIInstallData installData) throws Exception {
        String variant;
        String syskey = "unix";
        if (OsVersion.IS_WINDOWS) {
            syskey = "windows";
        } else if (OsVersion.IS_OSX) {
            syskey = "mac";
        }
        GUIPrefs.LookAndFeel lookAndFeel = null;
        if (installData.guiPrefs.lookAndFeelMapping.containsKey(syskey)) {
            lookAndFeel = (GUIPrefs.LookAndFeel)installData.guiPrefs.lookAndFeelMapping.get(syskey);
        }
        boolean useButtonIcons = true;
        if (installData.guiPrefs.modifier.containsKey(MODIFIER_USE_BUTTON_ICONS) && "no".equalsIgnoreCase((String)installData.guiPrefs.modifier.get(MODIFIER_USE_BUTTON_ICONS))) {
            useButtonIcons = false;
        }
        ButtonFactory.useButtonIcons((boolean)useButtonIcons);
        boolean useLabelIcons = true;
        if (installData.guiPrefs.modifier.containsKey(MODIFIER_USE_LABEL_ICONS) && "no".equalsIgnoreCase((String)installData.guiPrefs.modifier.get(MODIFIER_USE_LABEL_ICONS))) {
            useLabelIcons = false;
        }
        LabelFactory.setUseLabelIcons((boolean)useLabelIcons);
        if (installData.guiPrefs.modifier.containsKey(MODIFIER_LABEL_FONT_SIZE)) {
            String valStr = (String)installData.guiPrefs.modifier.get(MODIFIER_LABEL_FONT_SIZE);
            try {
                LabelFactory.setLabelFontSize((float)Float.parseFloat(valStr));
            }
            catch (NumberFormatException ex) {
                logger.warning("Error parsing guiprefs 'labelFontSize' value (" + valStr + ')');
            }
        }
        if (lookAndFeel == null) {
            if (!"mac".equals(syskey)) {
                String syslaf = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(syslaf);
                if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                    ButtonFactory.useButtonIcons((boolean)useButtonIcons);
                }
            }
            return;
        }
        if (lookAndFeel.is(LookAndFeels.KUNSTSTOFF)) {
            ButtonFactory.useHighlightButtons();
            ButtonFactory.useButtonIcons((boolean)useButtonIcons);
            installData.buttonsHColor = new Color(255, 255, 255);
            Class<?> lafClass = Class.forName("com.incors.plaf.kunststoff.KunststoffLookAndFeel");
            Class<?> mtheme = Class.forName("javax.swing.plaf.metal.MetalTheme");
            Class[] params = new Class[]{mtheme};
            Class<?> theme = Class.forName("com.izforge.izpack.gui.IzPackKMetalTheme");
            Method setCurrentThemeMethod = lafClass.getMethod("setCurrentTheme", params);
            LookAndFeel kunststoff = (LookAndFeel)lafClass.newInstance();
            MetalTheme ktheme = (MetalTheme)theme.newInstance();
            Object[] kparams = new Object[]{ktheme};
            UIManager.setLookAndFeel(kunststoff);
            setCurrentThemeMethod.invoke((Object)kunststoff, kparams);
            return;
        }
        if (lookAndFeel.is(LookAndFeels.METOUIA)) {
            UIManager.setLookAndFeel("net.sourceforge.mlf.metouia.MetouiaLookAndFeel");
            return;
        }
        if (lookAndFeel.is(LookAndFeels.NIMBUS)) {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                logger.info("Using laf " + info.getClassName());
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
            return;
        }
        if (lookAndFeel.is(LookAndFeels.LOOKS)) {
            variant = looksVariants.get("plasticXP");
            String variantName = lookAndFeel.getVariantName();
            if (looksVariants.containsKey(variantName)) {
                variant = looksVariants.get(variantName);
            }
            logger.info("Using laf " + variant);
            UIManager.setLookAndFeel(variant);
            return;
        }
        if (lookAndFeel.is(LookAndFeels.SUBSTANCE)) {
            String variantName = lookAndFeel.getVariantName();
            Map<String, String> variants = substanceVariants;
            if (JavaVersion.CURRENT.feature() > 8) {
                variants = radianceVariants;
            }
            variant = variants.containsKey(variantName) ? variants.get(variantName) : variants.get("default");
            logger.info("Using laf " + variant);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        UIManager.setLookAndFeel(variant);
                        UIManager.getLookAndFeelDefaults().put("ClassLoader", JPanel.class.getClassLoader());
                        GUIInstallDataProvider.this.checkSubstanceLafLoaded();
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Error loading Substance look and feel: " + e.getMessage(), e);
                        System.out.println("Substance Graphite failed to initialize");
                    }
                }
            });
        }
    }

    private void checkSubstanceLafLoaded() throws ClassNotFoundException {
        UIDefaults defaults = UIManager.getDefaults();
        String uiClassName = (String)defaults.get("PanelUI");
        ClassLoader cl = (ClassLoader)defaults.get("ClassLoader");
        ClassLoader classLoader = cl != null ? cl : JPanel.class.getClassLoader();
        Class<?> aClass = (Class<?>)defaults.get(uiClassName);
        logger.fine("PanelUI: " + uiClassName);
        logger.fine("ClassLoader: " + classLoader);
        logger.fine("Cached class: " + aClass);
        if (aClass != null) {
            return;
        }
        if (classLoader == null) {
            logger.fine("Using system loader to load " + uiClassName);
            aClass = Class.forName(uiClassName, true, Thread.currentThread().getContextClassLoader());
            logger.fine("Done loading");
        } else {
            logger.fine("Using custom loader to load " + uiClassName);
            aClass = classLoader.loadClass(uiClassName);
            logger.fine("Done loading");
        }
        if (aClass != null) {
            logger.fine("Loaded class: " + aClass.getName());
        } else {
            logger.fine("Couldn't load the class");
        }
    }

    private void loadGUIInstallData(GUIInstallData installData, Resources resources) throws Exception {
        installData.guiPrefs = (GUIPrefs)resources.getObject("GUIPrefs");
    }

    static {
        substanceVariants.put("default", "org.pushingpixels.substance.api.skin.SubstanceBusinessLookAndFeel");
        substanceVariants.put("autumn", "org.pushingpixels.substance.api.skin.SubstanceAutumnLookAndFeel");
        substanceVariants.put("business", "org.pushingpixels.substance.api.skin.SubstanceBusinessLookAndFeel");
        substanceVariants.put("business-black", "org.pushingpixels.substance.api.skin.SubstanceBusinessBlackSteelLookAndFeel");
        substanceVariants.put("business-blue", "org.pushingpixels.substance.api.skin.SubstanceBusinessBlueSteelLookAndFeel");
        substanceVariants.put("creme", "org.pushingpixels.substance.api.skin.SubstanceCremeLookAndFeel");
        substanceVariants.put("creme-coffee", "org.pushingpixels.substance.api.skin.SubstanceCremeCoffeeLookAndFeel");
        substanceVariants.put("dust", "org.pushingpixels.substance.api.skin.SubstanceDustLookAndFeel");
        substanceVariants.put("dust-coffee", "org.pushingpixels.substance.api.skin.SubstanceDustCoffeeLookAndFeel");
        substanceVariants.put("gemini", "org.pushingpixels.substance.api.skin.SubstanceGeminiLookAndFeel");
        substanceVariants.put("graphite", "org.pushingpixels.substance.api.skin.SubstanceGraphiteLookAndFeel");
        substanceVariants.put("mariner", "org.pushingpixels.substance.api.skin.SubstanceMarinerLookAndFeel");
        substanceVariants.put("mist-aqua", "org.pushingpixels.substance.api.skin.SubstanceMistAquaLookAndFeel");
        substanceVariants.put("mist-silver", "org.pushingpixels.substance.api.skin.SubstanceMistSilverLookAndFeel");
        substanceVariants.put("moderate", "org.pushingpixels.substance.api.skin.SubstanceModerateLookAndFeel");
        substanceVariants.put("nebula", "org.pushingpixels.substance.api.skin.SubstanceNebulaLookAndFeel");
        substanceVariants.put("nebula-brick-wall", "org.pushingpixels.substance.api.skin.SubstanceNebulaBrickWallLookAndFeel");
        substanceVariants.put("officeblack", "org.pushingpixels.substance.api.skin.SubstanceOfficeBlack2007LookAndFeel");
        substanceVariants.put("officeblue", "org.pushingpixels.substance.api.skin.SubstanceOfficeBlue2007LookAndFeel");
        substanceVariants.put("officesilver", "org.pushingpixels.substance.api.skin.SubstanceOfficeSilver2007LookAndFeel");
        substanceVariants.put("sahara", "org.pushingpixels.substance.api.skin.SubstanceSaharaLookAndFeel");
        radianceVariants.put("default", "org.pushingpixels.radiance.theming.api.skin.RadianceBusinessLookAndFeel");
        radianceVariants.put("autumn", "org.pushingpixels.radiance.theming.api.skin.RadianceAutumnLookAndFeel");
        radianceVariants.put("business", "org.pushingpixels.radiance.theming.api.skin.RadianceBusinessLookAndFeel");
        radianceVariants.put("business-black", "org.pushingpixels.radiance.theming.api.skin.RadianceBusinessBlackSteelLookAndFeel");
        radianceVariants.put("business-blue", "org.pushingpixels.radiance.theming.api.skin.RadianceBusinessBlueSteelLookAndFeel");
        radianceVariants.put("cerulean", "org.pushingpixels.radiance.theming.api.skin.RadianceCeruleanLookAndFeel");
        radianceVariants.put("creme", "org.pushingpixels.radiance.theming.api.skin.RadianceCremeLookAndFeel");
        radianceVariants.put("creme-coffee", "org.pushingpixels.radiance.theming.api.skin.RadianceCremeCoffeeLookAndFeel");
        radianceVariants.put("dust", "org.pushingpixels.radiance.theming.api.skin.RadianceDustLookAndFeel");
        radianceVariants.put("dust-coffee", "org.pushingpixels.radiance.theming.api.skin.RadianceDustCoffeeLookAndFeel");
        radianceVariants.put("gemini", "org.pushingpixels.radiance.theming.api.skin.RadianceGeminiLookAndFeel");
        radianceVariants.put("graphite", "org.pushingpixels.radiance.theming.api.skin.RadianceGraphiteLookAndFeel");
        radianceVariants.put("graphite-aqua", "org.pushingpixels.radiance.theming.api.skin.RadianceGraphiteAquaLookAndFeel");
        radianceVariants.put("graphite-chalk", "org.pushingpixels.radiance.theming.api.skin.RadianceGraphiteChalkLookAndFeel");
        radianceVariants.put("graphite-electric", "org.pushingpixels.radiance.theming.api.skin.RadianceGraphiteElectricLookAndFeel");
        radianceVariants.put("graphite-glass", "org.pushingpixels.radiance.theming.api.skin.RadianceGraphiteGlassLookAndFeel");
        radianceVariants.put("graphite-gold", "org.pushingpixels.radiance.theming.api.skin.RadianceGraphiteGoldLookAndFeel");
        radianceVariants.put("graphite-sienna", "org.pushingpixels.radiance.theming.api.skin.RadianceGraphiteSiennaLookAndFeel");
        radianceVariants.put("graphite-sunset", "org.pushingpixels.radiance.theming.api.skin.RadianceGraphiteSunsetLookAndFeel");
        radianceVariants.put("green-magic", "org.pushingpixels.radiance.theming.api.skin.RadianceGreenMagicLookAndFeel");
        radianceVariants.put("magellan", "org.pushingpixels.radiance.theming.api.skin.RadianceMagellanLookAndFeel");
        radianceVariants.put("mariner", "org.pushingpixels.radiance.theming.api.skin.RadianceMarinerLookAndFeel");
        radianceVariants.put("mist-aqua", "org.pushingpixels.radiance.theming.api.skin.RadianceMistAquaLookAndFeel");
        radianceVariants.put("mist-silver", "org.pushingpixels.radiance.theming.api.skin.RadianceMistSilverLookAndFeel");
        radianceVariants.put("moderate", "org.pushingpixels.radiance.theming.api.skin.RadianceModerateLookAndFeel");
        radianceVariants.put("nebula", "org.pushingpixels.radiance.theming.api.skin.RadianceNebulaLookAndFeel");
        radianceVariants.put("nebula-amethyst", "org.pushingpixels.radiance.theming.api.skin.RadianceNebulaAmethystLookAndFeel");
        radianceVariants.put("nebula-brick-wall", "org.pushingpixels.radiance.theming.api.skin.RadianceNebulaBrickWallLookAndFeel");
        radianceVariants.put("night-shade", "org.pushingpixels.radiance.theming.api.skin.RadianceNightShadeLookAndFeel");
        radianceVariants.put("raven", "org.pushingpixels.radiance.theming.api.skin.RadianceRavenLookAndFeel");
        radianceVariants.put("sahara", "org.pushingpixels.radiance.theming.api.skin.RadianceSaharaLookAndFeel");
        radianceVariants.put("sentinel", "org.pushingpixels.radiance.theming.api.skin.RadianceSentinelLookAndFeel");
        radianceVariants.put("twilight", "org.pushingpixels.radiance.theming.api.skin.RadianceTwilightLookAndFeel");
        radianceVariants.put("field-of-wheat", "org.pushingpixels.radiance.theming.extras.api.skinpack.RadianceFieldOfWheatLookAndFeel");
        radianceVariants.put("harvest", "org.pushingpixels.radiance.theming.extras.api.skinpack.RadianceHarvestLookAndFeel");
        radianceVariants.put("magma", "org.pushingpixels.radiance.theming.extras.api.skinpack.RadianceMagmaLookAndFeel");
        radianceVariants.put("officeblack", "org.pushingpixels.radiance.theming.extras.api.skinpack.RadianceOfficeBlack2007LookAndFeel");
        radianceVariants.put("officeblue", "org.pushingpixels.radiance.theming.extras.api.skinpack.RadianceOfficeBlue2007LookAndFeel");
        radianceVariants.put("officesilver", "org.pushingpixels.radiance.theming.extras.api.skinpack.RadianceOfficeSilver2007LookAndFeel");
        radianceVariants.put("streetlights", "org.pushingpixels.radiance.theming.extras.api.skinpack.RadianceStreetlightsLookAndFeel");
        looksVariants.put("windows", "com.jgoodies.looks.windows.WindowsLookAndFeel");
        looksVariants.put("plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel");
        looksVariants.put("plastic3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
        looksVariants.put("plasticXP", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
    }
}

