/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.language;

import com.izforge.izpack.api.exception.UserInterruptException;
import com.izforge.izpack.api.resource.Locales;
import com.izforge.izpack.installer.container.provider.AbstractInstallDataProvider;
import com.izforge.izpack.installer.data.ConsoleInstallData;
import com.izforge.izpack.installer.language.Languages;
import com.izforge.izpack.util.Console;
import com.izforge.izpack.util.Housekeeper;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LanguageConsoleDialog {
    private final ConsoleInstallData installData;
    private final Console console;
    private final Housekeeper housekeeper;
    private final Locales locales;
    private Map<String, String> displayNames = new LinkedHashMap<String, String>();
    private static final Logger logger = Logger.getLogger(LanguageConsoleDialog.class.getName());

    public LanguageConsoleDialog(Locales locales, ConsoleInstallData installData, Console console, Housekeeper housekeeper) {
        this.installData = installData;
        this.console = console;
        this.housekeeper = housekeeper;
        this.locales = locales;
    }

    public void initLangPack() {
        Languages languages = new Languages(this.locales, this.installData);
        this.displayNames = languages.getDisplayNames();
        switch (this.locales.getLocales().size()) {
            case 0: {
                break;
            }
            case 1: {
                String codeOfUniqueLanguage = this.displayNames.keySet().iterator().next();
                this.propagateLocale(codeOfUniqueLanguage);
                break;
            }
            default: {
                Iterator<String> iterator = this.displayNames.keySet().iterator();
                this.console.println("Select your language");
                String defaultIso3Lang = this.installData.getVariable("DEFAULT_ISO3_LANG");
                if (defaultIso3Lang == null || !this.displayNames.containsKey(defaultIso3Lang.toLowerCase())) {
                    defaultIso3Lang = Locale.getDefault().getISO3Language();
                }
                int i = 0;
                int defaultCodeIndex = -1;
                while (iterator.hasNext()) {
                    String langCode = iterator.next();
                    if (langCode.equalsIgnoreCase(defaultIso3Lang)) {
                        defaultCodeIndex = i;
                    }
                    this.console.println(i + "  [" + (i == defaultCodeIndex ? "x" : " ") + "] " + langCode);
                    ++i;
                }
                try {
                    int numberOfUniqueLanguage = this.console.prompt(this.installData.getMessages().get("ConsoleInstaller.inputSelection", new Object[0]), 0, this.displayNames.keySet().size() - 1, defaultCodeIndex, 0);
                    String[] keys = this.displayNames.keySet().toArray(new String[0]);
                    this.propagateLocale(keys[numberOfUniqueLanguage]);
                    break;
                }
                catch (UserInterruptException uie) {
                    this.console.println(uie.getMessage());
                    this.console.println("[ Console installation ABORTED by the user! ]");
                    this.housekeeper.shutDown(1);
                }
            }
        }
    }

    public void propagateLocale(String code) {
        try {
            this.locales.setLocale(code);
            Locale newLocale = this.locales.getLocale();
            Locale.setDefault(newLocale);
            this.installData.setLocale(this.locales.getLocale(), this.locales.getISOCode());
            this.installData.setMessages(this.locales.getMessages());
            AbstractInstallDataProvider.addCustomLangpack(this.installData, this.locales);
            AbstractInstallDataProvider.addUserInputLangpack(this.installData, this.locales);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }
}

