/*
 * Decompiled with CFR 0.152.
 */
package org.izpack.mojo;

import com.izforge.izpack.compiler.CompilerConfig;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenProjectValueSource;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.apache.maven.shared.filtering.PropertiesEscapingBackSlashValueSource;
import org.codehaus.plexus.interpolation.ValueSource;

public class IzPackMojo
extends AbstractMojo {
    private File descriptor;
    private String descriptorEncoding;
    private File izpackBasedir;
    private String kind;
    private String fileExtension;
    private File customPanelDirectory;
    private boolean attach = true;
    protected MavenProject project;
    private MavenProjectHelper projectHelper;
    private List classpathElements;
    private MavenResourcesFiltering mavenResourcesFiltering;
    private MavenSession session;
    private String classifier;
    private File installerFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.init();
        this.buildInstaller();
    }

    private void init() throws MojoFailureException {
        File dir;
        this.classifier = this.kind;
        if (this.installerFile == null) {
            this.installerFile = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + "-" + this.classifier + "." + this.fileExtension);
        }
        if (!(dir = this.installerFile.getParentFile()).exists() && !dir.mkdirs()) {
            throw new MojoFailureException("Could not create directory " + dir);
        }
        if (this.attach) {
            this.checkForDuplicateAttachArtifact();
        }
    }

    private File interpolateDescriptorFile() throws MavenFilteringException {
        Resource resource = new Resource();
        resource.setFiltering(true);
        resource.setDirectory(this.descriptor.getAbsoluteFile().getParent());
        String descriptorFileName = this.descriptor.getName();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add(descriptorFileName);
        resource.setIncludes(includes);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(resources, this.izpackBasedir, this.project, this.descriptorEncoding, null, null, this.session);
        mavenResourcesExecution.setUseDefaultFilterWrappers(true);
        mavenResourcesExecution.addFilerWrapperWithEscaping((ValueSource)new PropertiesEscapingBackSlashValueSource(true, this.project.getProperties()), "@{", "}", null);
        mavenResourcesExecution.addFilerWrapperWithEscaping((ValueSource)new MavenProjectValueSource(this.project, true), "@{", "}", null);
        this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
        return new File(this.izpackBasedir, descriptorFileName);
    }

    private void buildInstaller() throws MojoExecutionException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader(classLoader));
        try {
            String config = this.interpolateDescriptorFile().getAbsolutePath();
            String basedir = this.izpackBasedir.getAbsolutePath();
            CompilerConfig c = new CompilerConfig(config, basedir, this.kind, this.installerFile.getAbsolutePath());
            CompilerConfig.setIzpackHome((String)basedir);
            c.executeCompiler();
            if (!c.wasSuccessful()) {
                throw new MojoExecutionException("IzPack compilation ERROR");
            }
        }
        catch (Exception ce) {
            throw new MojoExecutionException("IzPack compilation ERROR", ce);
        }
        finally {
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        if (this.attach) {
            this.projectHelper.attachArtifact(this.project, this.fileExtension, this.classifier, this.installerFile);
        }
    }

    private void checkForDuplicateAttachArtifact() throws MojoFailureException {
        List attachedArtifacts = this.project.getAttachedArtifacts();
        for (Artifact artifact : attachedArtifacts) {
            if (!this.installerFile.equals(artifact.getFile())) continue;
            throw new MojoFailureException("Duplicate installers found: " + this.installerFile);
        }
    }

    private ClassLoader getClassLoader(ClassLoader classLoader) throws MojoExecutionException {
        ArrayList<URL> classpathURLs = new ArrayList<URL>();
        try {
            URL customerPanelUrl = this.customPanelDirectory.toURI().toURL();
            classpathURLs.add(customerPanelUrl);
            this.getLog().debug((CharSequence)("Added to classpath " + this.customPanelDirectory));
            for (int i = 0; i < this.classpathElements.size(); ++i) {
                String element = (String)this.classpathElements.get(i);
                File f = new File(element);
                URL newURL = f.toURI().toURL();
                classpathURLs.add(newURL);
                this.getLog().debug((CharSequence)("Added to classpath " + element));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error parsing classpath: " + e.getMessage());
        }
        URL[] urls = classpathURLs.toArray(new URL[classpathURLs.size()]);
        return new URLClassLoader(urls, classLoader);
    }
}

