/*
 * Decompiled with CFR 0.152.
 */
package org.izpack.mojo;

import com.izforge.izpack.api.data.Info;
import com.izforge.izpack.api.data.binding.IzpackProjectInstaller;
import com.izforge.izpack.api.exception.CompilerException;
import com.izforge.izpack.compiler.CompilerConfig;
import com.izforge.izpack.compiler.container.CompilerContainer;
import com.izforge.izpack.compiler.data.CompilerData;
import com.izforge.izpack.compiler.data.PropertyManager;
import com.izforge.izpack.compiler.logging.MavenStyleLogFormatter;
import java.io.File;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public class IzPackNewMojo
extends AbstractMojo {
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private String comprFormat;
    private String kind;
    private String installFile;
    private String baseDir;
    private String output;
    private boolean mkdirs;
    private boolean validating;
    private int comprLevel;
    private boolean autoIncludeUrl;
    private boolean autoIncludeDevelopers;
    private File outputDirectory;
    private String finalName;
    private String classifier;
    private boolean enableAttachArtifact;
    private boolean enableOverrideArtifact;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File jarFile = this.getJarFile();
        CompilerData compilerData = this.initCompilerData(jarFile);
        CompilerContainer compilerContainer = new CompilerContainer();
        compilerContainer.addConfig("installFile", (Object)this.installFile);
        compilerContainer.getComponent(IzpackProjectInstaller.class);
        compilerContainer.addComponent(CompilerData.class, (Object)compilerData);
        compilerContainer.addComponent(Handler.class, (Object)this.createLogHandler());
        CompilerConfig compilerConfig = (CompilerConfig)compilerContainer.getComponent(CompilerConfig.class);
        PropertyManager propertyManager = (PropertyManager)compilerContainer.getComponent(PropertyManager.class);
        this.initMavenProperties(propertyManager);
        try {
            compilerConfig.executeCompiler();
        }
        catch (CompilerException e) {
            throw new MojoFailureException("Failure during compilation process", (Throwable)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure", e);
        }
        if (this.classifier != null && !this.classifier.isEmpty()) {
            if (this.enableAttachArtifact) {
                this.projectHelper.attachArtifact(this.project, "jar", this.classifier, jarFile);
            }
        } else if (this.enableOverrideArtifact) {
            this.project.getArtifact().setFile(jarFile);
        }
    }

    private File getJarFile() {
        File file;
        if (this.output != null) {
            file = new File(this.output);
        } else {
            String localClassifier = this.classifier;
            if (this.classifier == null || this.classifier.trim().isEmpty()) {
                localClassifier = "";
            } else if (!this.classifier.startsWith("-")) {
                localClassifier = "-" + this.classifier;
            }
            file = new File(this.outputDirectory, this.finalName + localClassifier + ".jar");
        }
        return file;
    }

    private void initMavenProperties(PropertyManager propertyManager) {
        if (this.project != null) {
            Properties properties = this.project.getProperties();
            for (String propertyName : properties.stringPropertyNames()) {
                String value;
                if (propertyManager.addProperty(propertyName, value = properties.getProperty(propertyName))) {
                    this.getLog().debug((CharSequence)("Maven property added: " + propertyName + "=" + value));
                    continue;
                }
                this.getLog().warn((CharSequence)("Maven property " + propertyName + " could not be overridden"));
            }
        }
    }

    private CompilerData initCompilerData(File jarFile) {
        Info info = new Info();
        if (this.project != null) {
            if (this.autoIncludeDevelopers && this.project.getDevelopers() != null) {
                for (Developer dev : this.project.getDevelopers()) {
                    info.addAuthor(new Info.Author(dev.getName(), dev.getEmail()));
                }
            }
            if (this.autoIncludeUrl) {
                info.setAppURL(this.project.getUrl());
            }
        }
        return new CompilerData(this.comprFormat, this.kind, this.installFile, null, this.baseDir, jarFile.getPath(), this.mkdirs, this.validating, this.comprLevel, info);
    }

    private Handler createLogHandler() {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter((Formatter)new MavenStyleLogFormatter());
        Log log = this.getLog();
        Level level = Level.OFF;
        if (log.isDebugEnabled()) {
            level = Level.FINE;
        } else if (log.isInfoEnabled()) {
            level = Level.INFO;
        } else if (log.isWarnEnabled()) {
            level = Level.WARNING;
        } else if (log.isErrorEnabled()) {
            level = Level.SEVERE;
        }
        consoleHandler.setLevel(level);
        return consoleHandler;
    }
}

