/*
 * Decompiled with CFR 0.152.
 */
package org.izpack.mojo;

import com.izforge.izpack.api.data.Info;
import com.izforge.izpack.api.data.binding.IzpackProjectInstaller;
import com.izforge.izpack.api.exception.CompilerException;
import com.izforge.izpack.compiler.CompilerConfig;
import com.izforge.izpack.compiler.container.CompilerContainer;
import com.izforge.izpack.compiler.data.CompilerData;
import com.izforge.izpack.compiler.data.PropertyManager;
import com.izforge.izpack.compiler.logging.MavenStyleLogFormatter;
import java.io.File;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="izpack", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class IzPackNewMojo
extends AbstractMojo {
    @Parameter(property="session", required=true, readonly=true, defaultValue="${session}")
    private MavenSession session;
    @Parameter(property="project", required=true, readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="default")
    private String comprFormat;
    @Parameter(defaultValue="standard")
    private String kind;
    @Parameter(required=true, defaultValue="${basedir}/src/main/izpack/install.xml")
    private File installFile;
    @Parameter(defaultValue="${project.build.directory}/staging")
    private File baseDir;
    @Parameter(defaultValue="false")
    private boolean mkdirs;
    @Parameter(defaultValue="-1")
    private int comprLevel;
    @Parameter(defaultValue="false")
    private boolean autoIncludeUrl;
    @Parameter(defaultValue="false")
    private boolean autoIncludeDevelopers;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(alias="jarName", property="jar.finalName", defaultValue="${project.build.finalName}")
    private String finalName;
    @Parameter
    private String classifier;
    @Parameter
    private String excludeProperties;
    private PropertyManager propertyManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File jarFile = this.getJarFile();
        CompilerData compilerData = this.initCompilerData(jarFile);
        CompilerContainer compilerContainer = new CompilerContainer();
        compilerContainer.addConfig("installFile", (Object)this.installFile.getPath());
        compilerContainer.getComponent(IzpackProjectInstaller.class);
        compilerContainer.addComponent(CompilerData.class, (Object)compilerData);
        compilerContainer.addComponent(Handler.class, (Object)this.createLogHandler());
        CompilerConfig compilerConfig = (CompilerConfig)compilerContainer.getComponent(CompilerConfig.class);
        this.propertyManager = (PropertyManager)compilerContainer.getComponent(PropertyManager.class);
        this.initMavenProperties(this.propertyManager);
        try {
            compilerConfig.executeCompiler();
        }
        catch (CompilerException e) {
            throw new MojoFailureException("Failure during compilation process", (Throwable)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure", e);
        }
        Artifact artifact = this.project.getArtifact();
        artifact.setFile(jarFile);
    }

    private File getJarFile() {
        String localClassifier = this.classifier;
        if (this.classifier == null || this.classifier.trim().isEmpty()) {
            localClassifier = "";
        } else if (!this.classifier.startsWith("-")) {
            localClassifier = "-" + this.classifier;
        }
        return new File(this.outputDirectory, this.finalName + localClassifier + ".jar");
    }

    private void initMavenProperties(PropertyManager propertyManager) {
        if (this.project != null) {
            Properties properties = this.project.getProperties();
            Properties userProps = this.session.getUserProperties();
            String[] exclusionList = null;
            if (this.excludeProperties != null) {
                exclusionList = this.excludeProperties.split(",");
            }
            for (String propertyName : properties.stringPropertyNames()) {
                String value = userProps.containsKey(propertyName) ? userProps.getProperty(propertyName) : properties.getProperty(propertyName);
                if (this.containsExcludedProperty(propertyName, exclusionList)) continue;
                if (propertyManager.addProperty(propertyName, value)) {
                    this.getLog().debug((CharSequence)("Maven property added: " + propertyName + "=" + value));
                    continue;
                }
                this.getLog().warn((CharSequence)("Maven property " + propertyName + " could not be overridden"));
            }
        }
    }

    private CompilerData initCompilerData(File jarFile) {
        Info info = new Info();
        if (this.project != null) {
            if (this.autoIncludeDevelopers && this.project.getDevelopers() != null) {
                for (Developer dev : this.project.getDevelopers()) {
                    info.addAuthor(new Info.Author(dev.getName(), dev.getEmail()));
                }
            }
            if (this.autoIncludeUrl) {
                info.setAppURL(this.project.getUrl());
            }
        }
        return new CompilerData(this.comprFormat, this.kind, this.installFile.getPath(), null, this.baseDir.getPath(), jarFile.getPath(), this.mkdirs, this.comprLevel, info);
    }

    private Handler createLogHandler() {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter((Formatter)new MavenStyleLogFormatter());
        Log log = this.getLog();
        Level level = Level.OFF;
        if (log.isDebugEnabled()) {
            level = Level.FINE;
        } else if (log.isInfoEnabled()) {
            level = Level.INFO;
        } else if (log.isWarnEnabled()) {
            level = Level.WARNING;
        } else if (log.isErrorEnabled()) {
            level = Level.SEVERE;
        }
        consoleHandler.setLevel(level);
        return consoleHandler;
    }

    private boolean containsExcludedProperty(String property, String[] exclusionList) {
        if (exclusionList == null) {
            return false;
        }
        for (String s : exclusionList) {
            if (!property.contains(s.trim())) continue;
            return true;
        }
        return false;
    }
}

