/*
 * Decompiled with CFR 0.152.
 */
package org.izpack.mojo;

import com.izforge.izpack.api.data.Info;
import com.izforge.izpack.api.data.binding.IzpackProjectInstaller;
import com.izforge.izpack.api.exception.CompilerException;
import com.izforge.izpack.compiler.CompilerConfig;
import com.izforge.izpack.compiler.container.CompilerContainer;
import com.izforge.izpack.compiler.data.CompilerData;
import com.izforge.izpack.compiler.data.PropertyManager;
import com.izforge.izpack.compiler.logging.MavenStyleLogFormatter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="izpack", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class IzPackNewMojo
extends AbstractMojo {
    @Parameter(property="session", required=true, readonly=true, defaultValue="${session}")
    private MavenSession session;
    @Parameter(property="project", required=true, readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="default")
    private String comprFormat;
    @Parameter(defaultValue="standard")
    private String kind;
    @Parameter(required=true, defaultValue="${basedir}/src/main/izpack/install.xml")
    private File installFile;
    @Parameter(defaultValue="${project.build.directory}/staging")
    private File baseDir;
    @Parameter(defaultValue="false")
    private boolean mkdirs;
    @Parameter(defaultValue="-1")
    private int comprLevel;
    @Parameter(defaultValue="false")
    private boolean autoIncludeUrl;
    @Parameter(defaultValue="false")
    private boolean autoIncludeDevelopers;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter
    private String finalName;
    @Parameter
    private String classifier;
    @Parameter(defaultValue="true")
    private boolean enableAttachArtifact;
    @Parameter
    private Set<String> excludeProperties;
    private Set<String> trimmedExcludeProperties;
    @Parameter
    private Set<String> includeProperties;
    @Parameter(defaultValue="false")
    private boolean skipIzPack;
    @Parameter
    private Map<String, String> manifestEntries;
    private PropertyManager propertyManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File jarFile = this.getJarFile();
        if (this.isSkipIzPack()) {
            this.getLog().info((CharSequence)"Skipping IzPack creation.");
            IzPackNewMojo.createEmptyFile(jarFile);
        } else {
            this.createIzPack(jarFile);
        }
        if (this.project.getPackaging().equals("izpack-jar")) {
            this.project.getArtifact().setFile(jarFile);
        } else if (this.enableAttachArtifact) {
            this.projectHelper.attachArtifact(this.project, "jar", this.classifier, jarFile);
        }
    }

    private void createIzPack(File jarFile) throws MojoFailureException, MojoExecutionException {
        CompilerData compilerData = this.initCompilerData(jarFile);
        CompilerContainer compilerContainer = new CompilerContainer();
        compilerContainer.addConfig("installFile", (Object)this.installFile.getPath());
        compilerContainer.getComponent(IzpackProjectInstaller.class);
        compilerContainer.addComponent(CompilerData.class, (Object)compilerData);
        compilerContainer.addComponent(Handler.class, (Object)this.createLogHandler());
        CompilerConfig compilerConfig = (CompilerConfig)compilerContainer.getComponent(CompilerConfig.class);
        this.propertyManager = (PropertyManager)compilerContainer.getComponent(PropertyManager.class);
        this.addMavenProperties();
        try {
            compilerConfig.executeCompiler();
        }
        catch (CompilerException e) {
            throw new MojoFailureException("Failure during compilation process", (Throwable)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure", e);
        }
    }

    private boolean isSkipIzPack() {
        Properties userProperties = this.session.getUserProperties();
        boolean skipIzPack = this.skipIzPack;
        String skipIzPackStr = userProperties.getProperty("skipIzPack");
        if (skipIzPackStr != null) {
            skipIzPack = Boolean.parseBoolean(skipIzPackStr);
        }
        return skipIzPack;
    }

    private static void createEmptyFile(File jarFile) throws MojoExecutionException {
        try {
            jarFile.createNewFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failure", (Exception)e);
        }
    }

    private File getJarFile() {
        if (this.classifier == null || this.classifier.trim().isEmpty()) {
            this.classifier = "installer";
        }
        String installerFileName = this.finalName;
        if (this.finalName == null) {
            installerFileName = this.project.getBuild().getFinalName();
            if (!this.project.getPackaging().equals("izpack-jar")) {
                installerFileName = installerFileName + "-" + this.classifier;
            }
        }
        return new File(this.outputDirectory, installerFileName + ".jar");
    }

    private void addMavenProperties() {
        if (this.includeProperties == null) {
            this.trimExcludeProperties();
            List<String> includedProperties = this.initMavenProperties(this.project.getProperties().stringPropertyNames());
            if (!includedProperties.isEmpty()) {
                includedProperties.sort(String.CASE_INSENSITIVE_ORDER);
                this.getLog().warn((CharSequence)("You have not provided list of Maven properties to be included in the installer. Some of the sensitive maven properties may get included in the list. It is recommended to use 'includedProperties' to avoid this. Following Maven properties got included in the installer:\n" + String.join((CharSequence)", ", includedProperties)));
            }
        } else {
            List<String> includedProperties = this.initMavenProperties(this.trimIncludeProperties());
            if (!includedProperties.isEmpty()) {
                includedProperties.sort(String.CASE_INSENSITIVE_ORDER);
                this.getLog().info((CharSequence)("Following Maven properties got included in the installer:\n" + String.join((CharSequence)", ", includedProperties)));
            }
        }
    }

    private List<String> initMavenProperties(Set<String> propertyNames) {
        Properties properties = this.project.getProperties();
        Properties userProps = this.session.getUserProperties();
        ArrayList<String> includedProperties = new ArrayList<String>();
        for (String propertyName : propertyNames) {
            String existingValue;
            if (this.containsExcludedProperty(propertyName)) continue;
            String value = userProps.getProperty(propertyName);
            if (value == null) {
                value = properties.getProperty(propertyName);
            }
            if ((existingValue = this.propertyManager.getProperty(propertyName)) != null && existingValue.equals(value)) {
                includedProperties.add(propertyName + "=" + value);
                this.getLog().debug((CharSequence)("Maven property exists: " + propertyName + "=" + value));
                continue;
            }
            if (this.propertyManager.addProperty(propertyName, value)) {
                includedProperties.add(propertyName + "=" + value);
                this.getLog().debug((CharSequence)("Maven property added: " + propertyName + "=" + value));
                continue;
            }
            includedProperties.add(propertyName + "=" + existingValue);
            this.getLog().warn((CharSequence)("Property " + propertyName + "=" + existingValue + " could not be overridden with maven property " + propertyName + "=" + value));
        }
        return includedProperties;
    }

    private CompilerData initCompilerData(File jarFile) {
        Info info = new Info();
        if (this.autoIncludeDevelopers && this.project.getDevelopers() != null) {
            for (Developer dev : this.project.getDevelopers()) {
                info.addAuthor(new Info.Author(dev.getName(), dev.getEmail()));
            }
        }
        if (this.autoIncludeUrl) {
            info.setAppURL(this.project.getUrl());
        }
        return new CompilerData(this.comprFormat, this.kind, this.installFile.getPath(), null, this.baseDir.getPath(), jarFile.getPath(), this.mkdirs, this.comprLevel, info, this.manifestEntries);
    }

    private Handler createLogHandler() {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter((Formatter)new MavenStyleLogFormatter());
        Log log = this.getLog();
        Level level = Level.OFF;
        if (log.isDebugEnabled()) {
            level = Level.FINE;
        } else if (log.isInfoEnabled()) {
            level = Level.INFO;
        } else if (log.isWarnEnabled()) {
            level = Level.WARNING;
        } else if (log.isErrorEnabled()) {
            level = Level.SEVERE;
        }
        consoleHandler.setLevel(level);
        return consoleHandler;
    }

    private void trimExcludeProperties() {
        if (this.excludeProperties != null) {
            this.trimmedExcludeProperties = new HashSet<String>();
            for (String word : this.excludeProperties) {
                this.trimmedExcludeProperties.add(word.trim().toLowerCase());
            }
        }
    }

    private boolean containsExcludedProperty(String property) {
        if (this.trimmedExcludeProperties != null) {
            for (String word : this.trimmedExcludeProperties) {
                if (!property.toLowerCase().contains(word)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<String> trimIncludeProperties() {
        HashSet<String> trimmedIncludeProperties = new HashSet<String>();
        if (this.includeProperties != null) {
            for (String word : this.includeProperties) {
                trimmedIncludeProperties.add(word.trim());
            }
        }
        return trimmedIncludeProperties;
    }
}

