/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.compile;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.installer.unpacker.IUnpacker;
import com.izforge.izpack.panels.compile.CompileHandler;
import com.izforge.izpack.panels.compile.CompileResult;
import com.izforge.izpack.panels.compile.CompileWorker;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class CompilePanel
extends IzPanel
implements ActionListener,
CompileHandler {
    private static final long serialVersionUID = 3258408430669674552L;
    private JComboBox compilerComboBox;
    private JComboBox argumentsComboBox;
    private JButton startButton;
    private JButton browseButton;
    private JLabel opLabel;
    private JProgressBar packProgressBar;
    private JProgressBar overallProgressBar;
    private boolean validated = false;
    private CompileWorker worker;
    private int noOfJobs;

    public CompilePanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, VariableSubstitutor variableSubstitutor, IUnpacker unpacker, PlatformModelMatcher matcher) throws IOException {
        super(panel, parent, installData, resources);
        unpacker.setProgressListener((ProgressListener)this);
        this.worker = new CompileWorker((InstallData)installData, this, variableSubstitutor, resources, matcher);
        JLabel heading = new JLabel();
        JPanel subpanel = new JPanel();
        JLabel compilerLabel = new JLabel();
        this.compilerComboBox = new JComboBox();
        this.browseButton = ButtonFactory.createButton((String)this.getString("CompilePanel.browse"), (Color)installData.buttonsHColor);
        JLabel argumentsLabel = new JLabel();
        this.argumentsComboBox = new JComboBox();
        this.startButton = ButtonFactory.createButton((String)this.getString("CompilePanel.start"), (Color)installData.buttonsHColor);
        JLabel tipLabel = LabelFactory.create((String)this.getString("CompilePanel.tip"), (Icon)((Icon)parent.getIcons().get((Object)"tip")), (int)11);
        this.opLabel = new JLabel();
        this.packProgressBar = new JProgressBar();
        JLabel overallLabel = new JLabel();
        this.overallProgressBar = new JProgressBar();
        this.setLayout(new GridBagLayout());
        Font font = heading.getFont();
        font = font.deriveFont(1, (float)font.getSize() * 2.0f);
        heading.setFont(font);
        heading.setHorizontalAlignment(0);
        heading.setText(this.getString("CompilePanel.heading"));
        heading.setVerticalAlignment(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        this.add(heading, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.9;
        this.add(subpanel, gridBagConstraints);
        subpanel.setLayout(new GridBagLayout());
        int row = 0;
        compilerLabel.setHorizontalAlignment(2);
        compilerLabel.setLabelFor(this.compilerComboBox);
        compilerLabel.setText(this.getString("CompilePanel.choose_compiler"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = row;
        gridBagConstraints.fill = 2;
        subpanel.add((Component)compilerLabel, gridBagConstraints);
        this.compilerComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = row++;
        gridBagConstraints.fill = 2;
        for (String availableCompiler : this.worker.getAvailableCompilers()) {
            this.compilerComboBox.addItem(availableCompiler);
        }
        subpanel.add((Component)this.compilerComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = row++;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 13;
        this.browseButton.addActionListener(this);
        subpanel.add((Component)this.browseButton, gridBagConstraints);
        argumentsLabel.setHorizontalAlignment(2);
        argumentsLabel.setLabelFor(this.argumentsComboBox);
        argumentsLabel.setText(this.getString("CompilePanel.additional_arguments"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = row;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        subpanel.add((Component)argumentsLabel, gridBagConstraints);
        this.argumentsComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = row++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        for (String availableArgument : this.worker.getAvailableArguments()) {
            this.argumentsComboBox.addItem(availableArgument);
        }
        subpanel.add((Component)this.argumentsComboBox, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = row++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        subpanel.add((Component)tipLabel, gridBagConstraints);
        this.opLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = row++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        subpanel.add((Component)this.opLabel, gridBagConstraints);
        this.packProgressBar.setValue(0);
        this.packProgressBar.setString(this.getString("CompilePanel.progress.initial"));
        this.packProgressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = row++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        subpanel.add((Component)this.packProgressBar, gridBagConstraints);
        overallLabel.setText(this.getString("CompilePanel.progress.overall"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = row++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        subpanel.add((Component)overallLabel, gridBagConstraints);
        this.overallProgressBar.setValue(0);
        this.overallProgressBar.setString("");
        this.overallProgressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = row++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        subpanel.add((Component)this.overallProgressBar, gridBagConstraints);
        this.startButton.setText(this.getString("CompilePanel.start"));
        this.startButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = row;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        subpanel.add((Component)this.startButton, gridBagConstraints);
    }

    public boolean isValidated() {
        return this.validated;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.startButton) {
            this.worker.setCompiler((String)this.compilerComboBox.getSelectedItem());
            this.worker.setCompilerArguments((String)this.argumentsComboBox.getSelectedItem());
            this.blockGUI();
            this.worker.startThread();
        } else if (e.getSource() == this.browseButton) {
            File file_chosen;
            this.parent.blockGUI();
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File((String)this.compilerComboBox.getSelectedItem()).getParentFile());
            int result = chooser.showDialog((Component)this.parent, this.getString("CompilePanel.browse.approve"));
            if (result == 0 && (file_chosen = chooser.getSelectedFile()).isFile()) {
                this.compilerComboBox.setSelectedItem(file_chosen.getAbsolutePath());
            }
            this.parent.releaseGUI();
        }
    }

    private void blockGUI() {
        this.startButton.setEnabled(false);
        this.browseButton.setEnabled(false);
        this.compilerComboBox.setEnabled(false);
        this.argumentsComboBox.setEnabled(false);
        this.parent.blockGUI();
    }

    private void releaseGUI(boolean allowconfig) {
        if (allowconfig) {
            this.startButton.setEnabled(true);
            this.browseButton.setEnabled(true);
            this.compilerComboBox.setEnabled(true);
            this.argumentsComboBox.setEnabled(true);
        }
        this.parent.releaseGUI();
    }

    @Override
    public void handleCompileError(CompileResult error) {
        String message = error.getMessage();
        this.opLabel.setText(message);
        CompilerErrorDialog dialog = new CompilerErrorDialog((Frame)this.parent, message, this.installData.buttonsHColor);
        dialog.show(error);
        if (dialog.getResult() == 23) {
            error.setAction(39);
        } else if (dialog.getResult() == 47) {
            error.setAction(31);
        } else {
            error.setAction(27);
        }
    }

    public void startAction(String name, int noOfJobs1) {
        this.noOfJobs = noOfJobs1;
        this.overallProgressBar.setMaximum(noOfJobs1);
        this.parent.lockPrevButton();
    }

    public void stopAction() {
        CompileResult result = this.worker.getResult();
        this.releaseGUI(result.isReconfigure());
        if (result.isContinue()) {
            this.parent.lockPrevButton();
            this.packProgressBar.setString(this.getString("CompilePanel.progress.finished"));
            this.packProgressBar.setEnabled(false);
            this.packProgressBar.setValue(this.packProgressBar.getMaximum());
            this.overallProgressBar.setValue(this.noOfJobs);
            String no_of_jobs = Integer.toString(this.noOfJobs);
            this.overallProgressBar.setString(no_of_jobs + " / " + no_of_jobs);
            this.overallProgressBar.setEnabled(false);
            this.opLabel.setText(" ");
            this.opLabel.setEnabled(false);
            this.validated = true;
            this.installData.setInstallSuccess(true);
            if (this.installData.getPanels().indexOf(this) != this.installData.getPanels().size() - 1) {
                this.parent.unlockNextButton();
            }
        } else {
            this.installData.setInstallSuccess(false);
        }
    }

    public void progress(int val, String msg) {
        this.packProgressBar.setValue(val + 1);
        this.opLabel.setText(msg);
    }

    public void nextStep(String jobName, int max, int jobNo) {
        this.packProgressBar.setValue(0);
        this.packProgressBar.setMaximum(max);
        this.packProgressBar.setString(jobName);
        this.opLabel.setText("");
        this.overallProgressBar.setValue(jobNo);
        this.overallProgressBar.setString(Integer.toString(jobNo) + " / " + Integer.toString(this.noOfJobs));
    }

    public void setSubStepNo(int max) {
        this.packProgressBar.setMaximum(max);
    }

    public void progress(String message) {
    }

    public void restartAction(String name, String overallMessage, String tip, int steps) {
        this.startAction(name, steps);
    }

    public void panelActivate() {
        this.compilerComboBox.removeAllItems();
        for (String availableCompiler : this.worker.getAvailableCompilers()) {
            this.compilerComboBox.addItem(availableCompiler);
        }
        Dimension dim = this.parent.getPanelsContainerSize();
        dim.width -= dim.width / 4;
        dim.height = 150;
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
        this.parent.lockNextButton();
    }

    protected class CompilerErrorDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 3762537797721995317L;
        public static final int RESULT_NONE = 0;
        public static final int RESULT_IGNORE = 23;
        public static final int RESULT_ABORT = 42;
        public static final int RESULT_RECONFIGURE = 47;
        private Color buttonHColor;
        private JTextArea commandText;
        private JTextArea stdErrText;
        private JTextArea errorMessageText;
        private JButton ignoreButton;
        private JTextArea stdOutText;
        private JButton abortButton;
        private JButton reconfigButton;
        private int result;

        public CompilerErrorDialog(Frame parent, String title, Color buttonHColor) {
            super(parent, title, true);
            this.buttonHColor = null;
            this.result = 0;
            this.buttonHColor = buttonHColor;
            this.initComponents();
        }

        private void initComponents() {
            JPanel errorMessagePane = new JPanel();
            this.errorMessageText = new JTextArea();
            JTextArea seeBelowText = new JTextArea();
            JTabbedPane errorDisplayPane = new JTabbedPane();
            JScrollPane commandScrollPane = new JScrollPane();
            this.commandText = new JTextArea();
            JScrollPane stdOutScrollPane = new JScrollPane();
            this.stdOutText = new JTextArea();
            JScrollPane stdErrScrollPane = new JScrollPane();
            this.stdErrText = new JTextArea();
            JPanel buttonsPanel = new JPanel();
            this.reconfigButton = ButtonFactory.createButton((String)CompilePanel.this.getString("CompilePanel.error.reconfigure"), (Color)this.buttonHColor);
            this.ignoreButton = ButtonFactory.createButton((String)CompilePanel.this.getString("CompilePanel.error.ignore"), (Color)this.buttonHColor);
            this.abortButton = ButtonFactory.createButton((String)CompilePanel.this.getString("CompilePanel.error.abort"), (Color)this.buttonHColor);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    CompilerErrorDialog.this.closeDialog();
                }
            });
            errorMessagePane.setLayout(new BoxLayout(errorMessagePane, 1));
            this.errorMessageText.setBackground(super.getBackground());
            this.errorMessageText.setEditable(false);
            this.errorMessageText.setLineWrap(true);
            this.errorMessageText.setWrapStyleWord(true);
            errorMessagePane.add(this.errorMessageText);
            seeBelowText.setBackground(super.getBackground());
            seeBelowText.setEditable(false);
            seeBelowText.setLineWrap(true);
            seeBelowText.setWrapStyleWord(true);
            seeBelowText.setText(CompilePanel.this.getString("CompilePanel.error.seebelow"));
            errorMessagePane.add(seeBelowText);
            this.getContentPane().add((Component)errorMessagePane, "North");
            Font output_font = new Font("Monospaced", 0, 12);
            this.commandText.setFont(output_font);
            this.commandText.setEditable(false);
            this.commandText.setRows(10);
            this.commandText.setColumns(82);
            this.commandText.setWrapStyleWord(true);
            this.commandText.setLineWrap(true);
            commandScrollPane.setViewportView(this.commandText);
            errorDisplayPane.addTab("Command", commandScrollPane);
            this.stdOutText.setFont(output_font);
            this.stdOutText.setEditable(false);
            this.stdOutText.setWrapStyleWord(true);
            this.stdOutText.setLineWrap(true);
            stdOutScrollPane.setViewportView(this.stdOutText);
            errorDisplayPane.addTab("Standard Output", null, stdOutScrollPane);
            this.stdErrText.setFont(output_font);
            this.stdErrText.setEditable(false);
            this.stdErrText.setWrapStyleWord(true);
            this.stdErrText.setLineWrap(true);
            stdErrScrollPane.setViewportView(this.stdErrText);
            errorDisplayPane.addTab("Standard Error", null, stdErrScrollPane);
            this.getContentPane().add((Component)errorDisplayPane, "Center");
            buttonsPanel.setLayout(new FlowLayout(2));
            this.reconfigButton.addActionListener(this);
            buttonsPanel.add(this.reconfigButton);
            this.ignoreButton.addActionListener(this);
            buttonsPanel.add(this.ignoreButton);
            this.abortButton.addActionListener(this);
            buttonsPanel.add(this.abortButton);
            this.getContentPane().add((Component)buttonsPanel, "South");
            this.pack();
        }

        void closeDialog() {
            this.setVisible(false);
            this.dispose();
        }

        public void show(CompileResult error) {
            this.errorMessageText.setText(error.getMessage());
            this.commandText.setText(error.getCmdline());
            this.stdOutText.setText(error.getStdout());
            this.stdErrText.setText(error.getStderr());
            super.setVisible(true);
        }

        public int getResult() {
            return this.result;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean closenow = false;
            if (e.getSource() == this.ignoreButton) {
                this.result = 23;
                closenow = true;
            } else if (e.getSource() == this.abortButton) {
                this.result = 42;
                closenow = true;
            } else if (e.getSource() == this.reconfigButton) {
                this.result = 47;
                closenow = true;
            }
            if (closenow) {
                this.setVisible(false);
                this.dispose();
            }
        }
    }
}

