/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.path;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IzPanelConstraints;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LayoutConstants;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.installer.gui.LayoutHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PathSelectionPanel
extends JPanel
implements ActionListener,
LayoutConstants {
    private static final long serialVersionUID = 3618700794577105718L;
    private JTextField textField;
    private JButton browseButton;
    private IzPanel parent;
    private GUIInstallData installData;
    private final Log log;

    public PathSelectionPanel(IzPanel parent, GUIInstallData installData, Log log) {
        this.parent = parent;
        this.installData = installData;
        this.log = log;
        this.createLayout();
    }

    protected void createLayout() {
        LayoutHelper layoutHelper = new LayoutHelper((JComponent)this, (InstallData)this.installData);
        layoutHelper.startLayout((LayoutManager2)new IzPanelLayout(this.log));
        IzPanelConstraints ipc = IzPanelLayout.getDefaultConstraint((int)1);
        ipc.setXStretch(1.0);
        this.textField = new JTextField(this.installData.getInstallPath(), 50);
        this.textField.addActionListener(this);
        this.parent.setInitialFocus((Component)this.textField);
        this.add((Component)this.textField, ipc);
        this.add(IzPanelLayout.createHorizontalFiller((int)3));
        this.browseButton = ButtonFactory.createButton((String)this.parent.getInstallerFrame().getMessages().get("TargetPanel.browse", new Object[0]), (Icon)((Icon)this.parent.getInstallerFrame().getIcons().get((Object)"open")), (Color)this.installData.buttonsHColor);
        this.browseButton.setName(GuiId.BUTTON_BROWSE.id);
        this.browseButton.addActionListener(this);
        this.add(this.browseButton);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension preferredSize = super.getPreferredSize();
        Dimension retval = this.parent.getSize();
        retval.height = preferredSize.height;
        return retval;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.browseButton) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setName(GuiId.TARGET_PANEL_FILE_CHOOSER.id);
            fileChooser.setCurrentDirectory(new File(this.textField.getText()));
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileSelectionMode(1);
            fileChooser.addChoosableFileFilter(fileChooser.getAcceptAllFileFilter());
            if (fileChooser.showSaveDialog(this) == 0) {
                String path = fileChooser.getSelectedFile().getAbsolutePath();
                this.textField.setText(path);
            }
        } else if (this.parent instanceof ActionListener) {
            ((ActionListener)this.parent).actionPerformed(e);
        }
    }

    public String getPath() {
        return this.textField.getText();
    }

    public void setPath(String path) {
        this.textField.setText(path);
    }

    public JTextField getPathInputField() {
        return this.textField;
    }

    public JButton getBrowseButton() {
        return this.browseButton;
    }
}

