/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.treepacks;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.installer.util.PackHelper;
import com.izforge.izpack.panels.packs.PacksModel;
import com.izforge.izpack.panels.packs.PacksPanelAutomationHelper;
import com.izforge.izpack.util.Console;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class TreePacksConsolePanel
extends AbstractConsolePanel
implements ConsolePanel {
    private Messages messages;
    private final Prompt prompt;
    private final InstallData installData;
    private PacksModel packsModel;
    private static final String REQUIRED = "TreePacksPanel.required";
    private static final String UNSELECTABLE = "TreePacksPanel.unselectable";
    private static final String DEPENDENT = "TreePacksPanel.dependent";
    private static final String CHILDREN = "TreePacksPanel.children";
    private static final String DONE = "TreePacksPanel.done";
    private static final String CONFIRM = "TreePacksPanel.confirm";
    private static final String NUMBER = "TreePacksPanel.no.number";
    private static final String PROMPT = "TreePacksPanel.prompt";
    private static final String INVALID = "TreePacksPanel.invalid";
    private static final String REQUIRED_SPACE = "TreePacksPanel.space.required";

    public TreePacksConsolePanel(PanelView<ConsolePanel> panel, InstallData installData, Prompt prompt) {
        super(panel);
        this.installData = installData;
        this.prompt = prompt;
    }

    public boolean run(InstallData installData, Properties properties) {
        return true;
    }

    public boolean run(InstallData installData, Console console) {
        this.printHeadLine(installData, console);
        this.packsModel = new PacksModel(installData);
        try {
            this.messages = installData.getMessages().newMessages("packsLang.xml");
        }
        catch (ResourceNotFoundException exception) {
            this.messages = installData.getMessages();
        }
        this.displayPackMenu(installData, console);
        this.out(Prompt.Type.INFORMATION, installData.getMessages().get(DONE, new Object[0]));
        List<Pack> selectedPacks = this.packsModel.updatePacksToInstall();
        if (selectedPacks.size() == 0) {
            this.out(Prompt.Type.WARNING, "You have not selected any packs!");
            this.out(Prompt.Type.WARNING, "Are you sure you want to continue?");
        }
        return this.promptEndPanel(installData, console);
    }

    private void out(Prompt.Type type, String message) {
        this.prompt.message(type, message);
    }

    private void displayPackMenu(InstallData installData, Console console) {
        this.printPackMenu();
        List<Pack> visiblePacks = this.packsModel.getVisiblePacks();
        int maxRow = visiblePacks.size();
        while (true) {
            int choice = -1;
            try {
                choice = console.prompt(this.messages.get(PROMPT, new Object[0]), 0, maxRow, -1) - 1;
            }
            catch (NumberFormatException e) {
                this.out(Prompt.Type.WARNING, installData.getMessages().get(NUMBER, new Object[0]));
                continue;
            }
            if (choice <= maxRow && choice >= 0) {
                if (!this.packsModel.isCheckBoxSelectable(choice)) {
                    this.out(Prompt.Type.WARNING, installData.getMessages().get(INVALID, new Object[0]));
                    continue;
                }
                this.packsModel.toggleValueAt(choice);
                this.printPackMenu();
                continue;
            }
            if (choice == -1) break;
            this.out(Prompt.Type.WARNING, installData.getMessages().get(INVALID, new Object[0]));
        }
    }

    public void printPackMenu() {
        int row = 0;
        long totalSize = this.packsModel.getTotalByteSize();
        for (Pack pack : this.packsModel.getVisiblePacks()) {
            System.out.println(this.generateRowEntry(row, pack));
            ++row;
        }
        System.out.println(this.messages.get(REQUIRED_SPACE, new Object[0]) + " " + Pack.toByteUnitsString((long)totalSize));
        System.out.println(this.messages.get(CONFIRM, new Object[0]));
    }

    private String generateRowEntry(int row, Pack pack) {
        Map<String, Pack> nameToPack = this.packsModel.getNameToPack();
        String extraRow = "";
        String dependencies = "";
        String children = "";
        String marker = " ";
        if (this.packsModel.isChecked(row)) {
            marker = "x";
        }
        if (this.packsModel.isPartiallyChecked(row)) {
            marker = "o";
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = row + 1;
        objectArray[1] = marker;
        objectArray[2] = PackHelper.getPackName((Pack)pack, (Messages)this.messages);
        objectArray[3] = Pack.toByteUnitsString((long)pack.getSize());
        String mainRow = String.format("%-4d [%s] [%s] (%-4s)", objectArray);
        if (pack.hasDependencies()) {
            for (String dependentPackName : pack.getDependencies()) {
                Pack dependentPack = nameToPack.get(dependentPackName);
                dependencies = dependencies + PackHelper.getPackName((Pack)dependentPack, (Messages)this.messages) + ", ";
            }
            dependencies = dependencies.substring(0, dependencies.length() - 2);
            dependencies = this.messages.get(DEPENDENT, new Object[0]) + ": " + dependencies;
        }
        if (pack.hasChildren()) {
            for (String childPackName : pack.getChildren()) {
                Pack childPack = nameToPack.get(childPackName);
                children = children + PackHelper.getPackName((Pack)childPack, (Messages)this.messages) + ", ";
            }
            children = children.substring(0, children.length() - 2);
            children = this.messages.get(CHILDREN, new Object[0]) + ": " + children;
        }
        if (pack.isRequired()) {
            extraRow = extraRow + String.format("\n      >> %s", this.messages.get(REQUIRED, new Object[0]));
        } else if (!this.packsModel.isCheckBoxSelectable(row)) {
            extraRow = extraRow + String.format("\n      >> %s", this.messages.get(UNSELECTABLE, new Object[0]));
        }
        if (!dependencies.isEmpty()) {
            extraRow = extraRow + String.format("\n      >> %s", dependencies);
        }
        if (!children.isEmpty()) {
            extraRow = extraRow + String.format("\n      >> %s", children);
        }
        return mainRow + extraRow;
    }

    public void createInstallationRecord(IXMLElement panelRoot) {
        new PacksPanelAutomationHelper().createInstallationRecord(this.installData, panelRoot);
    }
}

